/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.persist.BatchedPstmt;
import io.ebeaninternal.server.persist.BatchedPstmtHolder;
import io.ebeaninternal.server.persist.dml.PersistHandler;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.util.Str;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.OptimisticLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmlHandler
implements PersistHandler,
BindableRequest {
    private static final Logger logger = LoggerFactory.getLogger(DmlHandler.class);
    private static final int[] GENERATED_KEY_COLUMNS = new int[]{1};
    private static final short BATCHED_FIRST = 1;
    private static final short BATCHED = 2;
    final PersistRequestBean<?> persistRequest;
    private final StringBuilder bindLog;
    final SpiTransaction transaction;
    private final boolean logLevelSql;
    private final long now = System.currentTimeMillis();
    DataBind dataBind;
    BatchedPstmt batchedPstmt;
    String sql;
    private short batchedStatus;

    DmlHandler(PersistRequestBean<?> persistRequest) {
        this.persistRequest = persistRequest;
        this.transaction = persistRequest.transaction();
        this.logLevelSql = this.transaction.isLogSql();
        this.bindLog = this.logLevelSql ? new StringBuilder(50) : null;
    }

    @Override
    public void pushJson(String json) {
        this.dataBind.pushJson(json);
    }

    @Override
    public long now() {
        return this.now;
    }

    @Override
    public PersistRequestBean<?> getPersistRequest() {
        return this.persistRequest;
    }

    DataBind bind(PreparedStatement stmt) {
        return new DataBind(this.persistRequest.dataTimeZone(), stmt, this.transaction.getInternalConnection());
    }

    @Override
    public abstract void bind() throws SQLException;

    @Override
    public abstract int execute() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int executeNoBatch() throws SQLException {
        long startNanos = System.nanoTime();
        try {
            int n = this.execute();
            return n;
        }
        finally {
            this.persistRequest.addTimingNoBatch(startNanos);
        }
    }

    void checkRowCount(int rowCount) throws OptimisticLockException {
        try {
            this.persistRequest.checkRowCount(rowCount);
            this.persistRequest.postExecute();
        }
        catch (OptimisticLockException e) {
            String m = e.getMessage() + " sql[" + this.sql + "] bind[" + this.bindLog + "]";
            this.persistRequest.transaction().logSummary("OptimisticLockException:" + m);
            throw new OptimisticLockException(m, null, e.getEntity());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.dataBind.getPstmt().addBatch();
    }

    @Override
    public void close() {
        try {
            if (this.dataBind != null) {
                this.dataBind.close();
            }
        }
        catch (SQLException ex) {
            logger.error(null, (Throwable)ex);
        }
    }

    @Override
    public void setIdValue(Object idValue) {
        this.persistRequest.setBoundId(idValue);
    }

    void logSql(String sql) {
        if (this.logLevelSql) {
            switch (this.batchedStatus) {
                case 1: {
                    this.transaction.logSql(sql);
                    this.transaction.logSql(Str.add(" -- bind(", this.bindLog.toString(), ")"));
                    return;
                }
                case 2: {
                    this.transaction.logSql(Str.add(" -- bind(", this.bindLog.toString(), ")"));
                    return;
                }
            }
            this.transaction.logSql(Str.add(sql, "; -- bind(", this.bindLog.toString(), ")"));
        }
    }

    @Override
    public void bind(Object value, int sqlType) throws SQLException {
        if (this.logLevelSql) {
            if (this.bindLog.length() > 0) {
                this.bindLog.append(",");
            }
            if (value == null) {
                this.bindLog.append("null");
            } else {
                String sval = value.toString();
                if (sval.length() > 50) {
                    this.bindLog.append(sval, 0, 47).append("...");
                } else {
                    this.bindLog.append(sval);
                }
            }
        }
        this.dataBind.setObject(value, sqlType);
    }

    @Override
    public void bindNoLog(Object value, int sqlType, String logPlaceHolder) throws SQLException {
        if (this.logLevelSql) {
            if (this.bindLog.length() > 0) {
                this.bindLog.append(",");
            }
            this.bindLog.append(logPlaceHolder);
        }
        this.dataBind.setObject(value, sqlType);
    }

    @Override
    public void bind(Object value, BeanProperty prop) throws SQLException {
        this.bindInternal(this.logLevelSql, value, prop);
    }

    @Override
    public void bindNoLog(Object value, BeanProperty prop) throws SQLException {
        this.bindInternal(false, value, prop);
    }

    private void bindInternal(boolean log, Object value, BeanProperty prop) throws SQLException {
        if (log) {
            if (this.bindLog.length() > 0) {
                this.bindLog.append(",");
            }
            if (prop.isLob()) {
                this.bindLog.append("[LOB]");
            } else {
                String sv = String.valueOf(value);
                if (sv.length() > 50) {
                    sv = sv.substring(0, 47) + "...";
                }
                this.bindLog.append(sv);
            }
        }
        prop.bind(this.dataBind, value);
    }

    PreparedStatement getPstmt(SpiTransaction t, String sql, boolean genKeys) throws SQLException {
        Connection conn = t.getInternalConnection();
        if (genKeys) {
            return conn.prepareStatement(sql, GENERATED_KEY_COLUMNS);
        }
        return conn.prepareStatement(sql);
    }

    PreparedStatement getPstmtBatch(SpiTransaction t, String sql, PersistRequestBean<?> request, boolean genKeys) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().getPstmtHolder();
        this.batchedPstmt = batch.getBatchedPstmt(sql);
        if (this.batchedPstmt != null) {
            this.batchedStatus = (short)(this.batchedPstmt.isEmpty() ? 1 : 2);
            return this.batchedPstmt.getStatement(request);
        }
        this.batchedStatus = 1;
        PreparedStatement stmt = this.getPstmt(t, sql, genKeys);
        this.batchedPstmt = new BatchedPstmt(stmt, genKeys, sql, t);
        batch.addStmt(this.batchedPstmt, request);
        return stmt;
    }
}

