/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

public final class SimpleTextParser {
    private final String oql;
    private final char[] chars;
    private final int eof;
    private int pos;
    private String word;
    private String lowerWord;

    public SimpleTextParser(String oql) {
        this.oql = oql;
        this.chars = oql.toCharArray();
        this.eof = oql.length();
    }

    public boolean isEmpty() {
        return this.oql.isEmpty();
    }

    public int getPos() {
        return this.pos;
    }

    String getOql() {
        return this.oql;
    }

    public String getWord() {
        return this.word;
    }

    private String peekNextWord() {
        int origPos = this.pos;
        String nw = this.nextWordInternal();
        this.pos = origPos;
        return nw;
    }

    public boolean isMatch(String lowerMatch, String nextWordMatch) {
        String nw;
        if (this.isMatch(lowerMatch) && (nw = this.peekNextWord()) != null) {
            nw = nw.toLowerCase();
            return nw.equals(nextWordMatch);
        }
        return false;
    }

    public boolean isFinished() {
        return this.word == null;
    }

    public int findWordLower(String lowerMatch, int afterPos) {
        this.pos = afterPos;
        return this.findWordLower(lowerMatch);
    }

    public int findWordLower(String lowerMatch) {
        do {
            if (this.nextWord() != null) continue;
            return -1;
        } while (!lowerMatch.equals(this.lowerWord));
        return this.pos - this.lowerWord.length();
    }

    public boolean isMatch(String lowerMatch) {
        return lowerMatch.equals(this.lowerWord);
    }

    public String nextWord() {
        this.word = this.nextWordInternal();
        if (this.word != null) {
            this.lowerWord = this.word.toLowerCase();
        }
        return this.word;
    }

    private String nextWordInternal() {
        this.trimLeadingWhitespace();
        if (this.pos >= this.eof) {
            return null;
        }
        int start = this.pos;
        if (this.chars[this.pos] == '(') {
            this.moveToClose();
        } else {
            this.moveToEndOfWord();
        }
        return this.oql.substring(start, this.pos);
    }

    private void moveToClose() {
        ++this.pos;
        int openParenthesisCount = 0;
        while (this.pos < this.eof) {
            char c = this.chars[this.pos];
            if (c == '(') {
                ++openParenthesisCount;
            } else if (c == ')') {
                if (openParenthesisCount > 0) {
                    --openParenthesisCount;
                } else {
                    ++this.pos;
                    return;
                }
            }
            ++this.pos;
        }
    }

    private void moveToEndOfWord() {
        char c = this.chars[this.pos];
        boolean isOperator = this.isOperator(c);
        while (this.pos < this.eof) {
            c = this.chars[this.pos];
            if (this.isWordTerminator(c, isOperator)) {
                return;
            }
            ++this.pos;
        }
    }

    private boolean isWordTerminator(char c, boolean isOperator) {
        return Character.isWhitespace(c) || (this.isOperator(c) ? !isOperator : c == '(' || isOperator);
    }

    private boolean isOperator(char c) {
        switch (c) {
            case '<': {
                return true;
            }
            case '>': {
                return true;
            }
            case '=': {
                return true;
            }
            case '!': {
                return true;
            }
        }
        return false;
    }

    private void trimLeadingWhitespace() {
        char c;
        while (this.pos < this.eof && Character.isWhitespace(c = this.chars[this.pos])) {
            ++this.pos;
        }
    }
}

