/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.IsoJsonDateTimeParser;
import io.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

final class ScalarTypeTimestamp
extends ScalarTypeBaseDateTime<Timestamp> {
    ScalarTypeTimestamp(JsonConfig.DateTime mode) {
        super(mode, Timestamp.class, true, 93);
    }

    @Override
    protected String toJsonNanos(Timestamp value) {
        return String.valueOf(value.getTime());
    }

    @Override
    protected String toJsonISO8601(Timestamp value) {
        return IsoJsonDateTimeParser.formatIso(value.toInstant());
    }

    @Override
    public long convertToMillis(Timestamp value) {
        return value.getTime();
    }

    @Override
    public Timestamp convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis);
    }

    @Override
    public Timestamp convertFromTimestamp(Timestamp ts) {
        return ts;
    }

    @Override
    public Timestamp convertFromInstant(Instant ts) {
        return Timestamp.from(ts);
    }

    @Override
    public Timestamp convertToTimestamp(Timestamp t) {
        return t;
    }

    @Override
    public void bind(DataBinder binder, Timestamp value) throws SQLException {
        if (value == null) {
            binder.setNull(93);
        } else {
            binder.setTimestamp(value);
        }
    }

    @Override
    public Timestamp read(DataReader reader) throws SQLException {
        return reader.getTimestamp();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toTimestamp(value);
    }

    public Timestamp toBeanType(Object value) {
        return BasicTypeConverter.toTimestamp(value);
    }
}

