/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

final class TypeResolver {
    private TypeResolver() {
    }

    static Class<?>[] resolveRawArgs(Class<?> type, Class<?> subType) {
        return TypeResolver.resolveRawArguments(TypeResolver.resolveGenericType(type, subType), subType);
    }

    private static Class<?>[] resolveRawArguments(Type genericType, Class<?> subType) {
        Class[] result;
        block3: {
            block4: {
                block2: {
                    result = null;
                    if (!(genericType instanceof ParameterizedType)) break block2;
                    ParameterizedType paramType = (ParameterizedType)genericType;
                    Type[] arguments = paramType.getActualTypeArguments();
                    result = new Class[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        result[i] = TypeResolver.resolveRawClass(arguments[i], subType);
                    }
                    break block3;
                }
                if (!(genericType instanceof TypeVariable)) break block4;
                result = new Class[]{TypeResolver.resolveRawClass(genericType, subType)};
                break block3;
            }
            if (!(genericType instanceof Class)) break block3;
            TypeVariable<Class<T>>[] typeParams = ((Class)genericType).getTypeParameters();
            result = new Class[typeParams.length];
            for (int i = 0; i < typeParams.length; ++i) {
                result[i] = TypeResolver.resolveRawClass(typeParams[i], subType);
            }
        }
        return result;
    }

    private static Type resolveGenericType(Class<?> type, Type subType) {
        Type superClass;
        Type result;
        Class rawType = subType instanceof ParameterizedType ? (Class)((ParameterizedType)subType).getRawType() : (Class)subType;
        if (type.equals(rawType)) {
            return subType;
        }
        if (type.isInterface()) {
            for (Type superInterface : rawType.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || (result = TypeResolver.resolveGenericType(type, superInterface)) == null) continue;
                return result;
            }
        }
        if ((superClass = rawType.getGenericSuperclass()) != null && !superClass.equals(Object.class) && (result = TypeResolver.resolveGenericType(type, superClass)) != null) {
            return result;
        }
        return null;
    }

    private static Class<?> resolveRawClass(Type genericType, Class<?> subType) {
        if (genericType instanceof Class) {
            return genericType;
        }
        if (genericType instanceof ParameterizedType) {
            return TypeResolver.resolveRawClass(((ParameterizedType)genericType).getRawType(), subType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> component = TypeResolver.resolveRawClass(arrayType.getGenericComponentType(), subType);
            return Array.newInstance(component, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = TypeResolver.getTypeVariableMap(subType).get(variable);
            genericType = genericType == null ? TypeResolver.resolveBound(variable) : TypeResolver.resolveRawClass(genericType, subType);
        }
        return genericType instanceof Class ? (Class)genericType : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType) {
        Class<?> type;
        HashMap map = new HashMap();
        TypeResolver.populateSuperTypeArgs(targetType.getGenericInterfaces(), map);
        Type genericType = targetType.getGenericSuperclass();
        for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            if (genericType instanceof ParameterizedType) {
                TypeResolver.populateTypeArgs((ParameterizedType)genericType, map);
            }
            TypeResolver.populateSuperTypeArgs(type.getGenericInterfaces(), map);
            genericType = type.getGenericSuperclass();
        }
        type = targetType;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                TypeResolver.populateTypeArgs((ParameterizedType)genericType, map);
            }
            type = type.getEnclosingClass();
        }
        return map;
    }

    private static void populateSuperTypeArgs(Type[] types, Map<TypeVariable<?>, Type> map) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                TypeResolver.populateTypeArgs(parameterizedType, map);
                Type rawType = parameterizedType.getRawType();
                if (!(rawType instanceof Class)) continue;
                TypeResolver.populateSuperTypeArgs(((Class)rawType).getGenericInterfaces(), map);
                continue;
            }
            if (!(type instanceof Class)) continue;
            TypeResolver.populateSuperTypeArgs(((Class)type).getGenericInterfaces(), map);
        }
    }

    private static void populateTypeArgs(ParameterizedType type, Map<TypeVariable<?>, Type> map) {
        if (type.getRawType() instanceof Class) {
            Type owner;
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            if (type.getOwnerType() != null && (owner = type.getOwnerType()) instanceof ParameterizedType) {
                TypeResolver.populateTypeArgs((ParameterizedType)owner, map);
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    map.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                Type resolvedType = map.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = TypeResolver.resolveBound(typeVariableArgument);
                }
                map.put(variable, resolvedType);
            }
        }
    }

    private static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = TypeResolver.resolveBound((TypeVariable)bound);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    private static final class Unknown {
        private Unknown() {
        }
    }
}

