/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.core.type.ScalarDataReader;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlBeanLoad;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreeProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SqlTreeNodeBean
implements SqlTreeNode {
    private static final SqlTreeNode[] NO_CHILDREN = new SqlTreeNode[0];
    final STreeType desc;
    final IdBinder idBinder;
    final SqlTreeNode[] children;
    private final boolean partialObject;
    private final STreeProperty[] properties;
    private final String extraWhere;
    private final STreePropertyAssoc nodeBeanProp;
    final boolean readId;
    private final boolean readIdNormal;
    private final boolean disableLazyLoad;
    private final InheritInfo inheritInfo;
    final String prefix;
    private final Map<String, String> pathMap;
    final STreePropertyAssocMany lazyLoadParent;
    private final SpiQuery.TemporalMode temporalMode;
    private final boolean temporalVersions;
    private final IdBinder lazyLoadParentIdBinder;
    String baseTableAlias;
    private boolean intersectionAsOfTableAlias;
    private final boolean aggregation;

    SqlTreeNodeBean(String prefix, STreePropertyAssoc beanProp, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean withId, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this(prefix, beanProp, beanProp.target(), props, myChildren, withId, null, temporalMode, disableLazyLoad);
    }

    SqlTreeNodeBean(STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myList, boolean withId, STreePropertyAssocMany many, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this(null, null, desc, props, myList, withId, many, temporalMode, disableLazyLoad);
    }

    private SqlTreeNodeBean(String prefix, STreePropertyAssoc beanProp, STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myChildren, boolean withId, STreePropertyAssocMany lazyLoadParent, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad) {
        this.lazyLoadParent = lazyLoadParent;
        this.lazyLoadParentIdBinder = lazyLoadParent == null ? null : lazyLoadParent.idBinder();
        this.prefix = prefix;
        this.desc = desc;
        this.inheritInfo = desc.inheritInfo();
        this.idBinder = desc.idBinder();
        this.temporalMode = temporalMode;
        this.temporalVersions = temporalMode == SpiQuery.TemporalMode.VERSIONS;
        this.nodeBeanProp = beanProp;
        this.extraWhere = beanProp == null ? null : beanProp.extraWhere();
        this.aggregation = props.isAggregation();
        boolean aggregationRoot = props.isAggregationRoot();
        this.readId = !aggregationRoot && withId && desc.hasId();
        this.readIdNormal = this.readId && !this.temporalVersions;
        this.disableLazyLoad = disableLazyLoad || !this.readIdNormal || desc.isRawSqlBased();
        this.partialObject = props.isPartialObject();
        this.properties = props.getProps();
        this.children = myChildren == null ? NO_CHILDREN : myChildren.toArray(new SqlTreeNode[0]);
        this.pathMap = this.createPathMap(prefix, desc);
    }

    boolean isRoot() {
        return false;
    }

    @Override
    public final boolean isSingleProperty() {
        return this.properties != null && this.properties.length == 1 && this.children.length == 0;
    }

    @Override
    public final ScalarDataReader<?> getSingleAttributeReader() {
        STreePropertyAssocOne assocOne;
        if (this.properties == null || this.properties.length == 0) {
            if (this.children.length == 0) {
                return this.desc.idBinder().getBeanProperty();
            }
            return this.children[0].getSingleAttributeReader();
        }
        if (this.properties[0] instanceof STreePropertyAssocOne && (assocOne = (STreePropertyAssocOne)this.properties[0]).isAssocId()) {
            return assocOne.idReader();
        }
        return this.properties[0];
    }

    private Map<String, String> createPathMap(String prefix, STreeType desc) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (STreePropertyAssocMany many : desc.propsMany()) {
            String name = many.name();
            m.put(name, this.getPath(prefix, name));
        }
        return m;
    }

    private String getPath(String prefix, String propertyName) {
        if (prefix == null) {
            return propertyName;
        }
        return prefix + "." + propertyName;
    }

    @Override
    public final void buildRawSqlSelectChain(List<String> selectChain) {
        if (this.readId) {
            if (this.inheritInfo != null) {
                selectChain.add(this.getPath(this.prefix, this.inheritInfo.getDiscriminatorColumn()));
            }
            this.idBinder.buildRawSqlSelectChain(this.prefix, selectChain);
        }
        for (STreeProperty property : this.properties) {
            property.buildRawSqlSelectChain(this.prefix, selectChain);
        }
        for (SqlTreeNode child : this.children) {
            child.buildRawSqlSelectChain(selectChain);
        }
    }

    @Override
    public EntityBean load(DbReadContext ctx, EntityBean parentBean, EntityBean contextParent) throws SQLException {
        return this.createLoad(ctx, parentBean).perform();
    }

    final Load createLoad(DbReadContext ctx, EntityBean parentBean) {
        return this.inheritInfo != null ? new LoadInherit(ctx, parentBean) : new Load(ctx, parentBean);
    }

    @Override
    public final void appendGroupBy(DbSqlContext ctx, boolean subQuery) {
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        if (this.lazyLoadParent != null) {
            this.lazyLoadParent.addSelectExported(ctx, this.prefix);
        }
        if (this.readId) {
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
        }
        for (STreeProperty property : this.properties) {
            if (property.isAggregation()) continue;
            property.appendSelect(ctx, subQuery);
        }
        for (SqlTreeNode child : this.children) {
            child.appendGroupBy(ctx, subQuery);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
        for (SqlTreeNode child : this.children) {
            child.appendDistinctOn(ctx, subQuery);
        }
    }

    @Override
    public final void appendSelect(DbSqlContext ctx, boolean subQuery) {
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        if (this.temporalVersions) {
            ctx.appendHistorySysPeriod();
        }
        if (this.lazyLoadParent != null) {
            this.lazyLoadParent.addSelectExported(ctx, this.prefix);
        }
        if (this.readId) {
            if (!subQuery && this.inheritInfo != null) {
                ctx.appendColumn(this.inheritInfo.getDiscriminatorColumn());
            }
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
        }
        this.appendSelect(ctx, subQuery, this.properties);
        for (SqlTreeNode child : this.children) {
            child.appendSelect(ctx, subQuery);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public final boolean isAggregation() {
        if (this.aggregation) {
            return true;
        }
        for (SqlTreeNode child : this.children) {
            if (!child.isAggregation()) continue;
            return true;
        }
        return false;
    }

    private void appendSelect(DbSqlContext ctx, boolean subQuery, STreeProperty[] props) {
        for (STreeProperty prop : props) {
            prop.appendSelect(ctx, subQuery);
        }
    }

    final void appendSelectId(DbSqlContext ctx, STreeProperty prop) {
        if (prop != null) {
            prop.appendSelect(ctx, false);
        }
    }

    @Override
    public final void appendWhere(DbSqlContext ctx) {
        if (this.inheritInfo != null && this.nodeBeanProp == null && !this.inheritInfo.isRoot()) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            ctx.append(" ").append(ctx.getTableAlias(this.prefix)).append(".");
            ctx.append(this.inheritInfo.getWhere());
        }
        this.appendExtraWhere(ctx);
        for (SqlTreeNode child : this.children) {
            child.appendWhere(ctx);
        }
    }

    void appendExtraWhere(DbSqlContext ctx) {
        if (this.extraWhere != null) {
            if (ctx.length() > 0) {
                ctx.append(" and");
            }
            String ta = ctx.getTableAlias(this.prefix);
            ctx.append(" ").append(this.extraWhere.replace("${ta}", ta));
        }
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        if (this.nodeBeanProp != null && this.nodeBeanProp.isFormula()) {
            this.nodeBeanProp.appendFrom(ctx, joinType, null);
        }
        ctx.pushJoin(this.prefix);
        ctx.pushTableAlias(this.prefix);
        this.baseTableAlias = ctx.getTableAlias(this.prefix);
        joinType = this.appendFromBaseTable(ctx, joinType);
        for (STreeProperty property : this.properties) {
            property.appendFrom(ctx, joinType, null);
        }
        for (SqlTreeNode child : this.children) {
            child.appendFrom(ctx, joinType);
        }
        ctx.popTableAlias();
        ctx.popJoin();
    }

    @Override
    public final void addSoftDeletePredicate(SpiQuery<?> query) {
        if (this.desc.isSoftDelete()) {
            query.addSoftDeletePredicate(this.desc.softDeletePredicate(this.baseTableAlias));
        }
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
        if (this.desc.isHistorySupport()) {
            query.incrementAsOfTableCount();
        }
        if (this.lazyLoadParent != null && this.lazyLoadParent.isManyToManyWithHistory()) {
            query.incrementAsOfTableCount();
        }
        if (this.intersectionAsOfTableAlias) {
            query.incrementAsOfTableCount();
        }
        for (SqlTreeNode child : this.children) {
            child.addAsOfTableAlias(query);
        }
    }

    @Override
    public void dependentTables(Set<String> tables) {
        tables.add(this.nodeBeanProp.target().baseTable(this.temporalMode));
        for (SqlTreeNode child : this.children) {
            child.dependentTables(tables);
        }
    }

    SqlJoinType appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        SqlJoinType sqlJoinType = this.appendFromAsJoin(ctx, joinType);
        if (this.inheritInfo != null) {
            this.appendJoinDiscriminator(ctx);
        }
        if (this.desc.isSoftDelete() && this.temporalMode != SpiQuery.TemporalMode.SOFT_DELETED) {
            ctx.append(" and ").append(this.desc.softDeletePredicate(ctx.getTableAlias(this.prefix)));
        }
        return sqlJoinType;
    }

    SqlJoinType appendFromAsJoin(DbSqlContext ctx, SqlJoinType joinType) {
        STreePropertyAssocMany manyProp;
        if (this.nodeBeanProp instanceof STreePropertyAssocMany && (manyProp = (STreePropertyAssocMany)this.nodeBeanProp).hasJoinTable()) {
            String alias = ctx.getTableAlias(this.prefix);
            String[] split = SplitName.split((String)this.prefix);
            String parentAlias = ctx.getTableAlias(split[0]);
            String alias2 = alias + "z_";
            TableJoin manyToManyJoin = manyProp.intersectionTableJoin();
            manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
            if (!manyProp.isExcludedFromHistory()) {
                this.intersectionAsOfTableAlias = true;
            }
            return this.nodeBeanProp.addJoin(joinType, alias2, alias, ctx);
        }
        return this.nodeBeanProp.addJoin(joinType, this.prefix, ctx);
    }

    void appendJoinDiscriminator(DbSqlContext ctx) {
        if (this.inheritInfo.getWhere() == null) {
            return;
        }
        String alias = ctx.getTableAlias(this.prefix);
        ctx.append(" and ").append(alias).append(".").append(this.inheritInfo.getWhere());
    }

    public String toString() {
        return "SqlTreeNodeBean: " + this.desc;
    }

    private boolean isLoadContextBeanNeeded(SpiQuery.Mode queryMode, EntityBean contextBean) {
        if (queryMode.isLoadContextBean()) {
            return true;
        }
        return !contextBean._ebean_getIntercept().isFullyLoadedBean();
    }

    @Override
    public boolean hasMany() {
        for (SqlTreeNode child : this.children) {
            if (!child.hasMany()) continue;
            return true;
        }
        return false;
    }

    class Load {
        final DbReadContext ctx;
        final EntityBean parentBean;
        Object lazyLoadParentId;
        Class<?> localType;
        STreeType localDesc;
        IdBinder localIdBinder;
        EntityBean localBean;
        SpiQuery.Mode queryMode;
        PersistenceContext persistenceContext;
        Object id;
        EntityBean contextBean;
        SqlBeanLoad sqlBeanLoad;
        boolean lazyLoadMany;

        private Load(DbReadContext ctx, EntityBean parentBean) {
            this.ctx = ctx;
            this.parentBean = parentBean;
        }

        private void initLazyParent() throws SQLException {
            if (SqlTreeNodeBean.this.lazyLoadParentIdBinder != null) {
                this.lazyLoadParentId = SqlTreeNodeBean.this.lazyLoadParentIdBinder.read(this.ctx);
            }
        }

        void initBeanType() throws SQLException {
            this.localDesc = SqlTreeNodeBean.this.desc;
            this.localBean = SqlTreeNodeBean.this.desc.createEntityBean();
            this.localIdBinder = SqlTreeNodeBean.this.idBinder;
        }

        private void initPersistenceContext() {
            this.queryMode = this.ctx.getQueryMode();
            this.persistenceContext = !SqlTreeNodeBean.this.readIdNormal ? null : this.ctx.getPersistenceContext();
        }

        private void readId() throws SQLException {
            if (SqlTreeNodeBean.this.readId) {
                this.id = this.localIdBinder.readSet(this.ctx, this.localBean);
                if (this.id == null) {
                    this.readIdNullBean();
                } else if (!SqlTreeNodeBean.this.temporalVersions) {
                    this.readIdBean();
                }
            }
        }

        private void readIdBean() {
            this.contextBean = (EntityBean)this.localDesc.contextPutIfAbsent(this.persistenceContext, this.id, this.localBean);
            if (this.contextBean == null) {
                this.contextBean = this.localBean;
            } else {
                this.localBean = SqlTreeNodeBean.this.isLoadContextBeanNeeded(this.queryMode, this.contextBean) ? this.contextBean : null;
            }
        }

        private void readIdNullBean() {
            this.localBean = null;
            if (this.parentBean != null && SqlTreeNodeBean.this.nodeBeanProp instanceof STreePropertyAssocOne) {
                this.contextBean = ((STreePropertyAssocOne)SqlTreeNodeBean.this.nodeBeanProp).getValueAsEntityBean(this.parentBean);
                if (this.contextBean != null) {
                    SqlTreeNodeBean.this.desc.markAsDeleted(this.contextBean);
                }
            }
        }

        private void initSqlLoadBean() {
            this.ctx.setCurrentPrefix(SqlTreeNodeBean.this.prefix, SqlTreeNodeBean.this.pathMap);
            this.ctx.propagateState(this.localBean);
            this.sqlBeanLoad = new SqlBeanLoad(this.ctx, this.localType, this.localBean, this.queryMode);
        }

        void loadProperties() {
            for (STreeProperty property : SqlTreeNodeBean.this.properties) {
                property.load(this.sqlBeanLoad);
            }
        }

        private void loadChildren() throws SQLException {
            if (this.localBean == null && this.queryMode == SpiQuery.Mode.LAZYLOAD_MANY) {
                this.localBean = this.contextBean;
                this.lazyLoadMany = true;
            }
            for (SqlTreeNode child : SqlTreeNodeBean.this.children) {
                child.load(this.ctx, this.localBean, this.contextBean);
            }
        }

        private boolean isLazyLoadManyRoot() {
            return this.queryMode == SpiQuery.Mode.LAZYLOAD_MANY && SqlTreeNodeBean.this.isRoot();
        }

        private EntityBean getContextBean() {
            return this.contextBean;
        }

        private void postLoad() {
            if (!this.lazyLoadMany && this.localBean != null) {
                this.ctx.setCurrentPrefix(SqlTreeNodeBean.this.prefix, SqlTreeNodeBean.this.pathMap);
                if (SqlTreeNodeBean.this.readIdNormal) {
                    this.createListProxies();
                }
                if (SqlTreeNodeBean.this.temporalMode == SpiQuery.TemporalMode.DRAFT) {
                    this.localDesc.setDraft(this.localBean);
                }
                this.localDesc.postLoad(this.localBean);
                EntityBeanIntercept ebi = this.localBean._ebean_getIntercept();
                ebi.setPersistenceContext(this.persistenceContext);
                if (SpiQuery.Mode.LAZYLOAD_BEAN == this.queryMode) {
                    ebi.setLoadedLazy();
                } else if (SqlTreeNodeBean.this.readId) {
                    ebi.setLoaded();
                }
                if (SqlTreeNodeBean.this.disableLazyLoad) {
                    ebi.setDisableLazyLoad(true);
                } else if (SqlTreeNodeBean.this.partialObject) {
                    if (SqlTreeNodeBean.this.readId) {
                        this.ctx.register(null, ebi);
                    }
                } else {
                    ebi.setFullyLoadedBean(true);
                }
                if (this.ctx.isAutoTuneProfiling() && !SqlTreeNodeBean.this.disableLazyLoad) {
                    this.ctx.profileBean(ebi, SqlTreeNodeBean.this.prefix);
                }
            }
        }

        private void createListProxies() {
            STreePropertyAssocMany fetchedMany = this.ctx.getManyProperty();
            boolean forceNewReference = this.queryMode == SpiQuery.Mode.REFRESH_BEAN;
            for (STreePropertyAssocMany many : this.localDesc.propsMany()) {
                BeanCollection<?> ref;
                if (many == fetchedMany || (ref = many.createReference(this.localBean, forceNewReference)) == null) continue;
                if (SqlTreeNodeBean.this.disableLazyLoad) {
                    ref.setDisableLazyLoad(true);
                }
                if (ref.isRegisteredWithLoadContext()) continue;
                this.ctx.register(many.asMany(), ref);
            }
        }

        private void setBeanToParent() {
            if (this.parentBean != null) {
                SqlTreeNodeBean.this.nodeBeanProp.setValue(this.parentBean, this.contextBean);
            }
        }

        private EntityBean complete() {
            if (!SqlTreeNodeBean.this.readIdNormal) {
                if (this.lazyLoadParentId != null) {
                    this.ctx.setLazyLoadedChildBean(this.localBean, this.lazyLoadParentId);
                }
                return this.localBean;
            }
            if (this.lazyLoadParentId != null) {
                this.ctx.setLazyLoadedChildBean(this.contextBean, this.lazyLoadParentId);
            }
            return this.contextBean;
        }

        private void initialise() throws SQLException {
            this.initLazyParent();
            this.initBeanType();
            this.initPersistenceContext();
            this.readId();
            this.initSqlLoadBean();
            this.loadProperties();
            this.loadChildren();
        }

        final EntityBean perform() throws SQLException {
            this.initialise();
            if (this.isLazyLoadManyRoot()) {
                return this.getContextBean();
            }
            this.postLoad();
            this.setBeanToParent();
            return this.complete();
        }

        final boolean isContextBean() {
            return this.localBean == null;
        }
    }

    private final class LoadInherit
    extends Load {
        private LoadInherit(DbReadContext ctx, EntityBean parentBean) {
            super(ctx, parentBean);
        }

        @Override
        void initBeanType() throws SQLException {
            InheritInfo localInfo;
            InheritInfo inheritInfo = localInfo = SqlTreeNodeBean.this.readId ? SqlTreeNodeBean.this.inheritInfo.readType(this.ctx) : SqlTreeNodeBean.this.desc.inheritInfo();
            if (localInfo == null) {
                this.localIdBinder = SqlTreeNodeBean.this.idBinder;
                this.localDesc = SqlTreeNodeBean.this.desc;
            } else {
                this.localBean = localInfo.createEntityBean();
                this.localType = localInfo.getType();
                this.localIdBinder = localInfo.getIdBinder();
                this.localDesc = localInfo.desc();
            }
        }

        @Override
        void loadProperties() {
            for (STreeProperty property : SqlTreeNodeBean.this.properties) {
                this.localDesc.inheritanceLoad(this.sqlBeanLoad, property, this.ctx);
            }
        }
    }
}

