/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeLong
extends ScalarTypeBase<Long> {
    ScalarTypeLong() {
        super(Long.class, true, -5);
    }

    public void bind(DataBinder binder, Long value) throws SQLException {
        if (value == null) {
            binder.setNull(-5);
        } else {
            binder.setLong(value.longValue());
        }
    }

    public Long read(DataReader reader) throws SQLException {
        return reader.getLong();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toLong(value);
    }

    public Long toBeanType(Object value) {
        return BasicTypeConverter.toLong(value);
    }

    @Override
    public String format(Object value) {
        return String.valueOf(value);
    }

    public String formatValue(Long t) {
        return t.toString();
    }

    public Long parse(String value) {
        return Long.valueOf(value);
    }

    @Override
    public long asVersion(Long value) {
        return value;
    }

    public Long convertFromMillis(long systemTimeMillis) {
        return systemTimeMillis;
    }

    public boolean isDateTimeCapable() {
        return true;
    }

    public Long readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readLong();
    }

    public void writeData(DataOutput dataOutput, Long value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(value);
        }
    }

    public Long jsonRead(JsonParser parser) throws IOException {
        return parser.getLongValue();
    }

    public void jsonWrite(JsonGenerator writer, Long value) throws IOException {
        writer.writeNumber(value.longValue());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.LONG;
    }
}

