/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.InheritInfoVisitor;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.deploy.parse.DeployInheritInfo;
import io.ebeaninternal.server.query.SqlTreeProperties;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

public final class InheritInfo {
    private final String discriminatorStringValue;
    private final Object discriminatorValue;
    private final String discriminatorColumn;
    private final int discriminatorType;
    private final int discriminatorLength;
    private final String columnDefn;
    private final String where;
    private final Class<?> type;
    private final List<InheritInfo> children = new ArrayList<InheritInfo>();
    private final HashMap<String, InheritInfo> discMap;
    private final HashMap<String, InheritInfo> typeMap;
    private final InheritInfo parent;
    private final InheritInfo root;
    private BeanDescriptor<?> descriptor;

    public InheritInfo(InheritInfo r, InheritInfo parent, DeployInheritInfo deploy) {
        this.parent = parent;
        this.type = deploy.getType();
        this.discriminatorColumn = InternString.intern(deploy.getColumnName(parent));
        this.discriminatorValue = deploy.getDiscriminatorObjectValue();
        this.discriminatorStringValue = deploy.getDiscriminatorStringValue();
        this.discriminatorType = deploy.getDiscriminatorType(parent);
        this.discriminatorLength = deploy.getColumnLength(parent);
        this.columnDefn = deploy.getColumnDefn();
        this.where = InternString.intern(deploy.getWhere());
        if (r == null) {
            this.root = this;
            this.discMap = new HashMap();
            this.typeMap = new HashMap();
            this.registerWithRoot(this);
        } else {
            this.root = r;
            this.discMap = null;
            this.typeMap = null;
            this.root.registerWithRoot(this);
        }
    }

    public void visitChildren(InheritInfoVisitor visitor) {
        for (InheritInfo child : this.children) {
            visitor.visit(child);
            child.visitChildren(visitor);
        }
    }

    public void appendCheckConstraintValues(String propertyName, Set<String> checkConstraintValues) {
        this.visitChildren(inheritInfo -> {
            Set<String> values;
            BeanProperty prop = inheritInfo.desc().beanProperty(propertyName);
            if (prop != null && (values = prop.dbCheckConstraintValues()) != null) {
                checkConstraintValues.addAll(values);
            }
        });
    }

    boolean isSaveRecurseSkippable() {
        return this.root.isNodeSaveRecurseSkippable();
    }

    private boolean isNodeSaveRecurseSkippable() {
        if (!this.descriptor.isSaveRecurseSkippable()) {
            return false;
        }
        for (InheritInfo child : this.children) {
            if (child.isNodeSaveRecurseSkippable()) continue;
            return false;
        }
        return true;
    }

    boolean isDeleteRecurseSkippable() {
        return this.root.isNodeDeleteRecurseSkippable();
    }

    private boolean isNodeDeleteRecurseSkippable() {
        if (!this.descriptor.isDeleteRecurseSkippable()) {
            return false;
        }
        for (InheritInfo child : this.children) {
            if (child.isNodeDeleteRecurseSkippable()) continue;
            return false;
        }
        return true;
    }

    public void setDescriptor(BeanDescriptor<?> descriptor) {
        this.descriptor = descriptor;
    }

    public BeanDescriptor<?> desc() {
        return this.descriptor;
    }

    public BeanProperty[] localProperties() {
        return this.descriptor.propertiesLocal();
    }

    public List<InheritInfo> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    BeanProperty findSubTypeProperty(String propertyName) {
        for (InheritInfo childInfo : this.children) {
            BeanProperty prop = childInfo.desc().findProperty(propertyName);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    public void addChildrenProperties(SqlTreeProperties selectProps) {
        for (InheritInfo childInfo : this.children) {
            selectProps.add(childInfo.descriptor.propertiesLocal());
            childInfo.addChildrenProperties(selectProps);
        }
    }

    public InheritInfo readType(DbReadContext ctx) throws SQLException {
        return this.readType(ctx.getDataReader().getString());
    }

    InheritInfo readType(String discValue) {
        if (discValue == null) {
            return null;
        }
        InheritInfo typeInfo = this.root.getType(discValue);
        if (typeInfo == null) {
            throw new PersistenceException("Inheritance type for discriminator value [" + discValue + "] was not found?");
        }
        return typeInfo;
    }

    public InheritInfo readType(Class<?> beanType) {
        InheritInfo typeInfo = this.root.getTypeByClass(beanType);
        if (typeInfo == null) {
            throw new PersistenceException("Inheritance type for bean type [" + beanType.getName() + "] was not found?");
        }
        return typeInfo;
    }

    public EntityBean createEntityBean() {
        return this.descriptor.createEntityBean();
    }

    public IdBinder getIdBinder() {
        return this.descriptor.idBinder();
    }

    public Class<?> getType() {
        return this.type;
    }

    public InheritInfo getRoot() {
        return this.root;
    }

    public InheritInfo getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isConcrete() {
        return !Modifier.isAbstract(this.type.getModifiers());
    }

    public InheritInfo getType(String discValue) {
        return this.discMap.get(discValue);
    }

    private InheritInfo getTypeByClass(Class<?> beanType) {
        return this.typeMap.get(beanType.getName());
    }

    private void registerWithRoot(InheritInfo info) {
        if (info.getDiscriminatorStringValue() != null) {
            String stringDiscValue = info.getDiscriminatorStringValue();
            this.discMap.put(stringDiscValue, info);
        }
        this.typeMap.put(info.getType().getName(), info);
    }

    public void addChild(InheritInfo childInfo) {
        this.children.add(childInfo);
    }

    public String getWhere() {
        return this.where;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public int getDiscriminatorType() {
        return this.discriminatorType;
    }

    public int getColumnLength() {
        return this.discriminatorLength;
    }

    public String getColumnDefn() {
        return this.columnDefn;
    }

    String getDiscriminatorStringValue() {
        return this.discriminatorStringValue;
    }

    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public String toString() {
        return "InheritInfo[" + this.type.getName() + "] disc[" + this.discriminatorStringValue + "]";
    }
}

