/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.id;

import io.ebean.SqlUpdate;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.BeanFkeyProperty;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.IntersectionBuilder;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dmlbind.BindableRequest;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.persistence.PersistenceException;

public final class ImportedIdSimple
implements ImportedId,
Comparable<ImportedIdSimple> {
    private static final EntryComparator COMPARATOR = new EntryComparator();
    final BeanPropertyAssoc<?> owner;
    final String localDbColumn;
    private final String localSqlFormula;
    final BeanProperty foreignProperty;
    private final int position;
    private final boolean insertable;
    private final boolean updateable;

    public ImportedIdSimple(BeanPropertyAssoc<?> owner, String localDbColumn, String localSqlFormula, BeanProperty foreignProperty, int position, boolean insertable, boolean updateable) {
        this.owner = owner;
        this.localDbColumn = InternString.intern(localDbColumn);
        this.localSqlFormula = InternString.intern(localSqlFormula);
        this.foreignProperty = foreignProperty;
        this.position = position;
        this.insertable = insertable;
        this.updateable = updateable;
    }

    public ImportedIdSimple(BeanPropertyAssoc<?> owner, String localDbColumn, String localSqlFormula, BeanProperty foreignProperty, int position) {
        this(owner, localDbColumn, localSqlFormula, foreignProperty, position, true, true);
    }

    public static ImportedIdSimple[] sort(List<ImportedIdSimple> list) {
        ImportedIdSimple[] importedIds = list.toArray(new ImportedIdSimple[0]);
        Arrays.sort(importedIds, COMPARATOR);
        return importedIds;
    }

    boolean isInclude(boolean update) {
        return update ? this.updateable : this.insertable;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int compareTo(ImportedIdSimple other) {
        return Integer.compare(this.position, other.position);
    }

    @Override
    public void addFkeys(String name) {
        BeanFkeyProperty fkey = new BeanFkeyProperty(name + "." + this.foreignProperty.name(), this.localDbColumn, this.owner.deployOrder());
        this.owner.descriptor().add(fkey);
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public String getDbColumn() {
        return this.localDbColumn;
    }

    private Object getIdValue(EntityBean bean) {
        return this.foreignProperty.getValue(bean);
    }

    @Override
    public void buildImport(IntersectionBuilder row) {
        row.addColumn(this.localDbColumn);
    }

    @Override
    public void bindImport(SqlUpdate sql, EntityBean other) {
        Object value = this.getIdValue(other);
        if (value == null) {
            throw new PersistenceException("Foreign Key value null?");
        }
        sql.setParameter(value);
    }

    @Override
    public void buildImport(IntersectionRow row, EntityBean other) {
        Object value = this.getIdValue(other);
        if (value == null) {
            String msg = "Foreign Key value null?";
            throw new PersistenceException(msg);
        }
        row.put(this.localDbColumn, value);
    }

    @Override
    public void sqlAppend(DbSqlContext ctx) {
        if (this.localSqlFormula != null) {
            ctx.appendFormulaSelect(this.localSqlFormula);
        } else {
            ctx.appendColumn(this.localDbColumn);
        }
    }

    @Override
    public void dmlAppend(GenerateDmlRequest request) {
        request.appendColumn(this.localDbColumn);
    }

    @Override
    public String importedIdClause() {
        return this.localDbColumn + " = ?";
    }

    @Override
    public int bind(int position, SqlUpdate update, EntityBean bean) {
        Object value = this.getIdValue(bean);
        update.setParameter(position, value);
        return ++position;
    }

    @Override
    public Object bind(BindableRequest request, EntityBean bean) throws SQLException {
        Object value = null;
        if (bean != null) {
            value = this.getIdValue(bean);
        }
        request.bind(value, this.foreignProperty);
        return value;
    }

    @Override
    public BeanProperty findMatchImport(String matchDbColumn) {
        if (matchDbColumn.equals(this.localDbColumn)) {
            return this.foreignProperty;
        }
        return null;
    }

    private static final class EntryComparator
    implements Comparator<ImportedIdSimple> {
        private EntryComparator() {
        }

        @Override
        public int compare(ImportedIdSimple o1, ImportedIdSimple o2) {
            return o1.compareTo(o2);
        }
    }
}

