/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.grammer;

import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.OrderBy;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.grammer.EqlWhereListener;
import io.ebeaninternal.server.grammer.ParseFetchConfig;
import io.ebeaninternal.server.grammer.antlr.EQLParser;
import io.ebeaninternal.server.util.ArrayStack;
import org.antlr.v4.runtime.tree.ParseTree;

class EqlAdapter<T>
extends EqlWhereListener<T> {
    private static final String DISTINCT = "distinct";
    private static final String NULLS = "nulls";
    private static final String ASC = "asc";
    private final SpiQuery<T> query;
    private final ExpressionFactory expressionFactory;

    EqlAdapter(SpiQuery<T> query) {
        this.query = query;
        this.expressionFactory = query.getExpressionFactory();
    }

    @Override
    ExpressionFactory expressionFactory() {
        return this.expressionFactory;
    }

    @Override
    Object namedParam(String parameterName) {
        return this.query.createNamedParameter(parameterName);
    }

    @Override
    Object positionParam(String paramPosition) {
        return this.query.createNamedParameter(paramPosition);
    }

    @Override
    ExpressionList<T> peekExprList() {
        if (this.textMode) {
            return this._peekText();
        }
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
            this.whereStack.push(this.query.where());
        }
        return (ExpressionList)this.whereStack.peek();
    }

    private ExpressionList<T> _peekText() {
        if (this.textStack == null) {
            this.textStack = new ArrayStack();
            this.textStack.push(this.query.text());
        }
        return (ExpressionList)this.textStack.peek();
    }

    @Override
    public void enterSelect_clause(EQLParser.Select_clauseContext ctx) {
        int childCount = ctx.getChildCount();
        String clause = this.trimParenthesis(this.child(ctx, childCount - 1));
        if (DISTINCT.equals(this.child(ctx, 1))) {
            this.query.setDistinct(true);
        }
        this.query.select(clause);
    }

    @Override
    public void enterFetch_path(EQLParser.Fetch_pathContext ctx) {
        String path;
        int childCount = ctx.getChildCount();
        this.checkChildren(ctx, 2);
        String maybePath = this.child(ctx, 1);
        FetchConfig fetchConfig = ParseFetchConfig.parse(maybePath);
        int propsIndex = 2;
        if (fetchConfig == null) {
            path = this.trimQuotes(maybePath);
        } else {
            propsIndex = 3;
            path = this.trimQuotes(this.child(ctx, 2));
        }
        if (childCount == propsIndex) {
            this.query.fetch(path, fetchConfig);
        } else {
            String properties = this.trimParenthesis(ctx.getChild(propsIndex).getText());
            this.query.fetch(path, properties, fetchConfig);
        }
    }

    private String trimParenthesis(String text) {
        if (text.charAt(0) == '(') {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    private String trimQuotes(String path) {
        if (path.charAt(0) == '\'' || path.charAt(0) == '`') {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    @Override
    public void enterOrderby_property(EQLParser.Orderby_propertyContext ctx) {
        int childCount = ctx.getChildCount();
        String path = this.child(ctx, 0);
        boolean asc = true;
        String nulls = null;
        String nullsFirstLast = null;
        if (childCount == 3) {
            asc = this.child(ctx, 1).startsWith(ASC);
            nullsFirstLast = ctx.getChild(2).getChild(1).getText();
            nulls = NULLS;
        } else if (childCount == 2) {
            String firstChild = this.child(ctx, 1);
            if (firstChild.startsWith(NULLS)) {
                nullsFirstLast = ctx.getChild(1).getChild(1).getText();
                nulls = NULLS;
            } else {
                asc = firstChild.startsWith(ASC);
            }
        }
        this.query.order().add(new OrderBy.Property(path, asc, nulls, nullsFirstLast));
    }

    @Override
    public void enterLimit_clause(EQLParser.Limit_clauseContext ctx) {
        try {
            String limitValue = this.child(ctx, 1);
            this.query.setMaxRows(Integer.parseInt(limitValue));
            int childCount = ctx.getChildCount();
            if (childCount == 3) {
                ParseTree offsetTree = ctx.getChild(2);
                String offsetValue = offsetTree.getChild(1).getText();
                this.query.setFirstRow(Integer.parseInt(offsetValue));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Error parsing limit or offset parameter - not an integer", e);
        }
    }
}

