/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.TransactionManager;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import javax.persistence.PersistenceException;

public class DefaultTransactionScopeManager
extends TransactionScopeManager {
    private final ThreadLocal<SpiTransaction> local = new ThreadLocal();

    @Override
    public void register(TransactionManager manager) {
    }

    @Override
    public final SpiTransaction inScope() {
        return this.local.get();
    }

    @Override
    public SpiTransaction active() {
        SpiTransaction t = this.local.get();
        if (t == null || !t.isActive()) {
            return null;
        }
        return t;
    }

    @Override
    public final void replace(SpiTransaction trans) {
        if (trans == null) {
            throw new IllegalStateException("Setting a null transaction?");
        }
        this.local.set(trans);
    }

    @Override
    public final void set(SpiTransaction trans) {
        if (trans == null) {
            throw new IllegalStateException("Setting a null transaction?");
        }
        this.checkForActiveTransaction();
        this.local.set(trans);
    }

    @Override
    public final void clear() {
        this.checkForActiveTransaction();
        this.local.remove();
    }

    @Override
    public final void clearExternal() {
        this.local.remove();
    }

    private void checkForActiveTransaction() {
        SpiTransaction transaction = this.local.get();
        if (transaction != null && transaction.isActive()) {
            throw new PersistenceException("Invalid state - there is an existing Active transaction " + transaction);
        }
    }
}

