/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.ebean.annotation.MutationDetection;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.type.JacksonTypeHelper;
import io.ebeaninternal.server.type.JsonTrim;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.TypeJsonManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

final class ScalarTypeJsonObjectMapper {
    ScalarTypeJsonObjectMapper() {
    }

    static ScalarType<?> createTypeFor(TypeJsonManager jsonManager, DeployBeanProperty prop, int dbType, DocPropertyType docType) {
        AnnotatedField field = (AnnotatedField)prop.getJacksonField();
        MutationDetection mode = prop.getMutationDetection();
        if (mode == MutationDetection.NONE) {
            return new NoMutationDetection(jsonManager, field, dbType, docType);
        }
        if (mode != MutationDetection.DEFAULT) {
            return new GenericObject(jsonManager, field, dbType, docType);
        }
        MutationDetection defaultMode = jsonManager.mutationDetection();
        prop.setMutationDetection(defaultMode);
        if (MutationDetection.NONE == defaultMode) {
            return new NoMutationDetection(jsonManager, field, dbType, docType);
        }
        return new GenericObject(jsonManager, field, dbType, docType);
    }

    private static abstract class Base<T>
    extends ScalarTypeBase<T> {
        protected final ObjectWriter objectWriter;
        protected final ObjectMapper objectReader;
        protected final JavaType deserType;
        protected final String pgType;
        private final DocPropertyType docType;

        Base(Class<T> cls, TypeJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(cls, false, dbType);
            this.objectReader = jsonManager.objectMapper();
            this.pgType = jsonManager.postgresType(dbType);
            this.docType = docType;
            JacksonTypeHelper helper = new JacksonTypeHelper(field, this.objectReader);
            this.deserType = helper.type();
            this.objectWriter = helper.objectWriter();
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        public T read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return (T)this.objectReader.readValue(json, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, json, (Exception)e);
            }
        }

        public void bind(DataBinder binder, T value) throws SQLException {
            if (this.pgType != null) {
                String rawJson = value == null ? null : this.formatValue(value);
                binder.setObject(PostgresHelper.asObject(this.pgType, rawJson));
            } else if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(this.formatValue(value));
            }
        }

        public final Object toJdbcType(Object value) {
            return value;
        }

        public final T toBeanType(Object value) {
            return (T)value;
        }

        public final String formatValue(T value) {
            try {
                return this.objectWriter.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new PersistenceException("Unable to create JSON", (Throwable)e);
            }
        }

        public final T parse(String value) {
            try {
                return (T)this.objectReader.readValue(value, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, value, (Exception)e);
            }
        }

        public final DocPropertyType getDocType() {
            return this.docType;
        }

        public final boolean isDateTimeCapable() {
            return false;
        }

        public final T convertFromMillis(long dateTime) {
            throw new IllegalStateException("Not supported");
        }

        public final T jsonRead(JsonParser parser) throws IOException {
            return (T)this.objectReader.readValue(parser, this.deserType);
        }

        public final void jsonWrite(JsonGenerator writer, T value) throws IOException {
            this.objectWriter.writeValue(writer, value);
        }

        public final T readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        public final void writeData(DataOutput dataOutput, T value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }

    private static final class GenericObject
    extends Base<Object> {
        private final boolean jsonb;

        GenericObject(TypeJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(Object.class, jsonManager, field, dbType, docType);
            this.jsonb = "jsonb".equals(this.pgType);
        }

        public boolean isJsonMapper() {
            return true;
        }

        @Override
        public Object read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (this.jsonb) {
                json = JsonTrim.trim(json);
            }
            reader.pushJson(json);
            if (json == null || json.isEmpty()) {
                return null;
            }
            try {
                return this.objectReader.readValue(json, this.deserType);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as " + this.deserType, json, (Exception)e);
            }
        }

        @Override
        public void bind(DataBinder binder, Object value) throws SQLException {
            String rawJson = binder.popJson();
            if (rawJson == null && value != null) {
                rawJson = this.formatValue(value);
            }
            if (this.pgType != null) {
                binder.setObject(PostgresHelper.asObject(this.pgType, rawJson));
            } else if (value == null) {
                binder.setNull(12);
            } else {
                binder.setString(rawJson);
            }
        }
    }

    private static final class NoMutationDetection
    extends Base<Object> {
        NoMutationDetection(TypeJsonManager jsonManager, AnnotatedField field, int dbType, DocPropertyType docType) {
            super(Object.class, jsonManager, field, dbType, docType);
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean isDirty(Object value) {
            return false;
        }
    }
}

