/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.BackgroundExecutor;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.cache.TenantAwareKey;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.CountMetric;
import io.ebean.metric.MetricFactory;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerCache
implements ServerCache {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultServerCache.class);
    public static final CompareByLastAccess BY_LAST_ACCESS = new CompareByLastAccess();
    protected final Map<Object, SoftReference<CacheEntry>> map;
    protected final CountMetric hitCount;
    protected final CountMetric missCount;
    protected final CountMetric putCount;
    protected final CountMetric removeCount;
    protected final CountMetric clearCount;
    protected final CountMetric evictCount;
    protected final String name;
    protected final String shortName;
    private final int maxSize;
    private final int trimFrequency;
    private final int maxIdleSecs;
    private final int maxSecsToLive;
    private final TenantAwareKey tenantAwareKey;

    public DefaultServerCache(DefaultServerCacheConfig config) {
        this.name = config.getName();
        this.shortName = config.getShortName();
        this.map = config.getMap();
        this.maxSize = config.getMaxSize();
        this.tenantAwareKey = new TenantAwareKey(config.getTenantProvider());
        this.maxIdleSecs = config.getMaxIdleSecs();
        this.maxSecsToLive = config.getMaxSecsToLive();
        this.trimFrequency = config.determineTrimFrequency();
        MetricFactory factory = MetricFactory.get();
        String prefix = "l2n.";
        this.hitCount = factory.createCountMetric(prefix + this.shortName + ".hit");
        this.missCount = factory.createCountMetric(prefix + this.shortName + ".miss");
        this.putCount = factory.createCountMetric(prefix + this.shortName + ".put");
        this.removeCount = factory.createCountMetric(prefix + this.shortName + ".remove");
        this.clearCount = factory.createCountMetric(prefix + this.shortName + ".clear");
        this.evictCount = factory.createCountMetric(prefix + this.shortName + ".evict");
    }

    public void periodicTrim(BackgroundExecutor executor) {
        EvictionRunnable trim = new EvictionRunnable();
        long trimFreqSecs = this.trimFrequency == 0 ? 60L : (long)this.trimFrequency;
        executor.scheduleWithFixedDelay((Runnable)trim, trimFreqSecs, trimFreqSecs, TimeUnit.SECONDS);
    }

    public void visit(MetricVisitor visitor) {
        this.hitCount.visit(visitor);
        this.missCount.visit(visitor);
        this.putCount.visit(visitor);
        this.removeCount.visit(visitor);
        this.clearCount.visit(visitor);
        this.evictCount.visit(visitor);
    }

    public ServerCacheStatistics getStatistics(boolean reset) {
        ServerCacheStatistics cacheStats = new ServerCacheStatistics();
        cacheStats.setCacheName(this.name);
        cacheStats.setMaxSize(this.maxSize);
        cacheStats.setSize(this.size());
        cacheStats.setHitCount(this.hitCount.get(reset));
        cacheStats.setMissCount(this.missCount.get(reset));
        cacheStats.setPutCount(this.putCount.get(reset));
        cacheStats.setRemoveCount(this.removeCount.get(reset));
        cacheStats.setClearCount(this.clearCount.get(reset));
        cacheStats.setEvictCount(this.evictCount.get(reset));
        return cacheStats;
    }

    public long getHitCount() {
        return this.hitCount.get(false);
    }

    public long getMissCount() {
        return this.missCount.get(false);
    }

    public int getHitRatio() {
        long mc = this.missCount.get(false);
        long hc = this.hitCount.get(false);
        long totalCount = hc + mc;
        if (totalCount == 0L) {
            return 0;
        }
        return (int)(hc * 100L / totalCount);
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void clear() {
        this.clearCount.increment();
        this.map.clear();
    }

    protected Object key(Object id) {
        return this.tenantAwareKey.key(id);
    }

    public Object get(Object id) {
        CacheEntry entry = this.getCacheEntry(id);
        if (entry == null) {
            this.missCount.increment();
            return null;
        }
        this.hitCount.increment();
        return this.unwrapEntry(entry);
    }

    protected Object unwrapEntry(CacheEntry entry) {
        return entry.getValue();
    }

    protected CacheEntry getCacheEntry(Object id) {
        SoftReference<CacheEntry> ref = this.map.get(this.key(id));
        return ref != null ? ref.get() : null;
    }

    public void putAll(Map<Object, Object> keyValues) {
        keyValues.forEach(this::put);
    }

    public void put(Object id, Object value) {
        Object key = this.key(id);
        this.map.put(key, new SoftReference<CacheEntry>(new CacheEntry(key, value)));
        this.putCount.increment();
    }

    public void remove(Object id) {
        SoftReference<CacheEntry> entry = this.map.remove(this.key(id));
        if (entry != null && entry.get() != null) {
            this.removeCount.increment();
        }
    }

    public int size() {
        return this.map.size();
    }

    protected int getTrimSize() {
        return this.maxSize * 90 / 100;
    }

    public void runEviction() {
        long trimForMaxSize = this.maxSize == 0 ? 0L : (long)(this.size() - this.maxSize);
        if (this.maxIdleSecs == 0 && this.maxSecsToLive == 0 && trimForMaxSize < 0L) {
            return;
        }
        long startNanos = System.nanoTime();
        long trimmedByIdle = 0L;
        long trimmedByGC = 0L;
        long trimmedByTTL = 0L;
        long trimmedByLRU = 0L;
        ArrayList<CacheEntry> activeList = new ArrayList<CacheEntry>(this.map.size());
        long idleExpireNano = startNanos - TimeUnit.SECONDS.toNanos(this.maxIdleSecs);
        long ttlExpireNano = startNanos - TimeUnit.SECONDS.toNanos(this.maxSecsToLive);
        Iterator<SoftReference<CacheEntry>> it = this.map.values().iterator();
        while (it.hasNext()) {
            SoftReference<CacheEntry> ref = it.next();
            CacheEntry cacheEntry = ref.get();
            if (cacheEntry == null) {
                it.remove();
                ++trimmedByGC;
                continue;
            }
            if (this.maxIdleSecs > 0 && idleExpireNano > cacheEntry.getLastAccessTime()) {
                it.remove();
                ++trimmedByIdle;
                continue;
            }
            if (this.maxSecsToLive > 0 && ttlExpireNano > cacheEntry.getCreateTime()) {
                it.remove();
                ++trimmedByTTL;
                continue;
            }
            if (trimForMaxSize <= 0L) continue;
            activeList.add(cacheEntry);
        }
        if (trimForMaxSize > 0L && activeList.size() > this.maxSize) {
            int trimSize;
            activeList.sort(BY_LAST_ACCESS);
            for (int i = trimSize = this.getTrimSize(); i < activeList.size(); ++i) {
                if (this.map.remove(((CacheEntry)activeList.get(i)).getKey()) == null) continue;
                ++trimmedByLRU;
            }
        }
        this.evictCount.add(trimmedByIdle);
        this.evictCount.add(trimmedByGC);
        this.evictCount.add(trimmedByTTL);
        this.evictCount.add(trimmedByLRU);
        if (logger.isTraceEnabled()) {
            long exeMicros = TimeUnit.MICROSECONDS.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
            logger.trace("Executed trim of cache {} in [{}]millis idle[{}] timeToLive[{}] accessTime[{}] gc[{}]", new Object[]{this.name, exeMicros, trimmedByIdle, trimmedByTTL, trimmedByLRU, trimmedByGC});
        }
    }

    public static final class CacheEntry {
        private final Object key;
        private final Object value;
        private final long createTime;
        private long lastAccessTime;

        public CacheEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
            this.lastAccessTime = this.createTime = System.nanoTime();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            this.lastAccessTime = System.nanoTime();
            return this.value;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }
    }

    public static final class CompareByLastAccess
    implements Comparator<CacheEntry>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(CacheEntry e1, CacheEntry e2) {
            return Long.compare(e1.getLastAccessTime(), e2.getLastAccessTime());
        }
    }

    public final class EvictionRunnable
    implements Runnable {
        @Override
        public void run() {
            DefaultServerCache.this.runEviction();
        }
    }
}

