/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.changelog;

import io.ebean.annotation.ChangeLog;
import io.ebean.annotation.ChangeLogInsertMode;
import io.ebean.event.BeanPersistRequest;
import io.ebean.event.changelog.ChangeLogFilter;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.util.AnnotationUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DefaultChangeLogRegister
implements ChangeLogRegister {
    private static final BasicFilter INCLUDE_INSERTS = new BasicFilter(true);
    private static final BasicFilter EXCLUDE_INSERTS = new BasicFilter(false);
    private final boolean defaultInsertsInclude;

    public DefaultChangeLogRegister(boolean defaultInsertsInclude) {
        this.defaultInsertsInclude = defaultInsertsInclude;
    }

    public ChangeLogFilter getChangeFilter(Class<?> beanType) {
        ChangeLog changeLog = this.getChangeLog(beanType);
        if (changeLog == null) {
            return null;
        }
        String[] updatesThatInclude = changeLog.updatesThatInclude();
        if (updatesThatInclude.length == 0) {
            return this.insertModeInclude(changeLog.inserts()) ? INCLUDE_INSERTS : EXCLUDE_INSERTS;
        }
        HashSet<String> updateProps = new HashSet<String>();
        Collections.addAll(updateProps, updatesThatInclude);
        return new UpdateFilter(this.insertModeInclude(changeLog.inserts()), updateProps);
    }

    private ChangeLog getChangeLog(Class<?> beanType) {
        return (ChangeLog)AnnotationUtil.typeGet(beanType, ChangeLog.class);
    }

    private boolean insertModeInclude(ChangeLogInsertMode inserts) {
        if (inserts == ChangeLogInsertMode.DEFAULT) {
            return this.defaultInsertsInclude;
        }
        return ChangeLogInsertMode.INCLUDE == inserts;
    }

    protected static class UpdateFilter
    extends BasicFilter {
        final Set<String> updateProperties;

        UpdateFilter(boolean includeInserts, Set<String> updateProperties) {
            super(includeInserts);
            this.updateProperties = updateProperties;
        }

        @Override
        public boolean includeUpdate(BeanPersistRequest<?> updateRequest) {
            return updateRequest.hasDirtyProperty(this.updateProperties);
        }
    }

    protected static class BasicFilter
    implements ChangeLogFilter {
        final boolean includeInserts;

        BasicFilter(boolean includeInserts) {
            this.includeInserts = includeInserts;
        }

        public boolean includeInsert(BeanPersistRequest<?> insertRequest) {
            return this.includeInserts;
        }

        public boolean includeUpdate(BeanPersistRequest<?> updateRequest) {
            return true;
        }

        public boolean includeDelete(BeanPersistRequest<?> deleteRequest) {
            return true;
        }
    }
}

