/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy.generatedproperty;

import io.ebean.Transaction;
import io.ebean.config.ClassLoadConfig;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.IdGenerator;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebeaninternal.server.deploy.generatedproperty.CounterFactory;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedWhoCreated;
import io.ebeaninternal.server.deploy.generatedproperty.GeneratedWhoModified;
import io.ebeaninternal.server.deploy.generatedproperty.InsertTimestampFactory;
import io.ebeaninternal.server.deploy.generatedproperty.UpdateTimestampFactory;
import io.ebeaninternal.server.deploy.generatedproperty.UuidGeneratedProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class GeneratedPropertyFactory {
    private final CounterFactory counterFactory = new CounterFactory();
    private final InsertTimestampFactory insertFactory;
    private final UpdateTimestampFactory updateFactory;
    private final HashSet<String> numberTypes = new HashSet();
    private final UuidGeneratedProperty generatedUuid = new UuidGeneratedProperty();
    private final GeneratedWhoModified generatedWhoModified;
    private final GeneratedWhoCreated generatedWhoCreated;
    private final ClassLoadConfig classLoadConfig;
    private final Map<String, PlatformIdGenerator> idGeneratorMap = new HashMap<String, PlatformIdGenerator>();

    public GeneratedPropertyFactory(boolean offlineMode, DatabaseConfig config, List<IdGenerator> idGenerators) {
        this.classLoadConfig = config.getClassLoadConfig();
        this.insertFactory = new InsertTimestampFactory(this.classLoadConfig);
        this.updateFactory = new UpdateTimestampFactory(this.classLoadConfig);
        CurrentUserProvider currentUserProvider = config.getCurrentUserProvider();
        if (currentUserProvider != null) {
            this.generatedWhoCreated = new GeneratedWhoCreated(currentUserProvider);
            this.generatedWhoModified = new GeneratedWhoModified(currentUserProvider);
        } else if (offlineMode) {
            currentUserProvider = new DummyCurrentUser();
            this.generatedWhoCreated = new GeneratedWhoCreated(currentUserProvider);
            this.generatedWhoModified = new GeneratedWhoModified(currentUserProvider);
        } else {
            this.generatedWhoCreated = null;
            this.generatedWhoModified = null;
        }
        this.numberTypes.add(Integer.class.getName());
        this.numberTypes.add(Integer.TYPE.getName());
        this.numberTypes.add(Long.class.getName());
        this.numberTypes.add(Long.TYPE.getName());
        this.numberTypes.add(Short.class.getName());
        this.numberTypes.add(Short.TYPE.getName());
        this.numberTypes.add(Double.class.getName());
        this.numberTypes.add(Double.TYPE.getName());
        this.numberTypes.add(BigDecimal.class.getName());
        if (idGenerators != null) {
            for (IdGenerator idGenerator : idGenerators) {
                this.idGeneratorMap.put(idGenerator.getName(), new CustomIdGenerator(idGenerator));
            }
        }
    }

    public ClassLoadConfig getClassLoadConfig() {
        return this.classLoadConfig;
    }

    private boolean isNumberType(String typeClassName) {
        return this.numberTypes.contains(typeClassName);
    }

    public void setVersion(DeployBeanProperty property) {
        if (this.isNumberType(property.getPropertyType().getName())) {
            this.setCounter(property);
        } else {
            this.setUpdateTimestamp(property);
        }
    }

    private void setCounter(DeployBeanProperty property) {
        this.counterFactory.setCounter(property);
    }

    public void setInsertTimestamp(DeployBeanProperty property) {
        this.insertFactory.setInsertTimestamp(property);
    }

    public void setUpdateTimestamp(DeployBeanProperty property) {
        this.updateFactory.setUpdateTimestamp(property);
    }

    public void setWhoCreated(DeployBeanProperty property) {
        if (this.generatedWhoCreated == null) {
            throw new IllegalStateException("No CurrentUserProvider has been set so @WhoCreated is not supported");
        }
        property.setGeneratedProperty(this.generatedWhoCreated);
    }

    public void setWhoModified(DeployBeanProperty property) {
        if (this.generatedWhoModified == null) {
            throw new IllegalStateException("No CurrentUserProvider has been set so @WhoModified is not supported");
        }
        property.setGeneratedProperty(this.generatedWhoModified);
    }

    public PlatformIdGenerator getIdGenerator(String generatorName) {
        return this.idGeneratorMap.get(generatorName);
    }

    public void setUuid(DeployBeanProperty prop) {
        prop.setGeneratedProperty(this.generatedUuid);
    }

    private static final class DummyCurrentUser
    implements CurrentUserProvider {
        private DummyCurrentUser() {
        }

        public Object currentUser() {
            throw new RuntimeException("never called");
        }
    }

    private static final class CustomIdGenerator
    implements PlatformIdGenerator {
        private final IdGenerator generator;

        CustomIdGenerator(IdGenerator generator) {
            this.generator = generator;
        }

        public String getName() {
            return this.generator.getName();
        }

        public boolean isDbSequence() {
            return false;
        }

        public Object nextId(Transaction transaction) {
            return this.generator.nextValue();
        }

        public void preAllocateIds(int allocateSize) {
        }
    }
}

