/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.idgen;

import io.ebeaninternal.server.idgen.UuidV1RndIdGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UuidV1IdGenerator
extends UuidV1RndIdGenerator {
    private static final Map<File, UuidV1IdGenerator> INSTANCES = new ConcurrentHashMap<File, UuidV1IdGenerator>();
    private final File stateFile;
    private byte[] nodeId;
    private boolean canSaveState = true;

    public static UuidV1IdGenerator getInstance(String file) {
        return INSTANCES.computeIfAbsent(new File(file), UuidV1IdGenerator::new);
    }

    public static UuidV1IdGenerator getInstance(File file) {
        return INSTANCES.computeIfAbsent(file, UuidV1IdGenerator::new);
    }

    private static byte[] getAlternativeNodeId() {
        try {
            String altNodeId = System.getProperty("ebean.uuid.nodeId");
            if (altNodeId != null) {
                String[] components = altNodeId.split("-");
                if (components.length != 5) {
                    throw new IllegalArgumentException("Invalid nodeId string: " + altNodeId);
                }
                byte[] nodeId = new byte[6];
                for (int i = 0; i < 5; ++i) {
                    nodeId[i] = Byte.decode("0x" + components[i]);
                }
                return nodeId;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static byte[] getHardwareId() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        byte[] fallbackAddr = null;
        while (e.hasMoreElements()) {
            NetworkInterface network = e.nextElement();
            try {
                byte[] addr;
                log.trace("Probing interface {}", (Object)network);
                if (network.isLoopback() || !UuidV1IdGenerator.validAddr(addr = network.getHardwareAddress())) continue;
                if (network.isUp() && !network.isVirtual()) {
                    log.debug("Using interface {}", (Object)network);
                    return addr;
                }
                if (fallbackAddr != null) continue;
                log.debug("Using interface {} as fallback", (Object)network);
                fallbackAddr = addr;
            }
            catch (SocketException ex) {
                log.debug("Skipping {}", (Object)network, (Object)ex);
            }
        }
        return fallbackAddr;
    }

    private static boolean validAddr(byte[] addr) {
        if (addr != null && addr.length >= 6) {
            return addr[0] != 0 && addr[1] != 0 && addr[2] != 0 || addr[0] != 255 && addr[1] != 255 && addr[2] != 255;
        }
        return false;
    }

    private UuidV1IdGenerator(File stateFile) {
        this.stateFile = stateFile;
        try {
            this.nodeId = UuidV1IdGenerator.getAlternativeNodeId();
            if (this.nodeId != null) {
                log.info("Using alternative MAC {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
            } else {
                this.nodeId = UuidV1IdGenerator.getHardwareId();
                log.info("Using MAC {} to generate Type 1 UUIDs", (Object)this.getNodeIdentifier());
            }
            if (this.nodeId == null) {
                this.canSaveState = false;
                this.nodeId = super.getNodeIdBytes();
                log.error("Have to fall back to random node identifier {} (Reason: No suitable network interface found)", (Object)this.getNodeIdentifier());
            } else {
                boolean flag = this.restoreState();
                UUID uuid = this.nextId(null);
                long ts = this.timeStamp.get();
                ts -= 122192928000000000L;
                this.saveState();
                log.debug("RestoreState: {}, ClockSeq {}, Timestamp {}, uuid {}, stateFile: {})", new Object[]{flag, this.clockSeq.get(), new Date(ts /= 10000L), uuid, stateFile});
            }
        }
        catch (IOException e) {
            this.canSaveState = false;
            this.nodeId = super.getNodeIdBytes();
            log.error("Have to fall back to random node identifier {} (Reason: {} )", (Object)this.getNodeIdentifier(), (Object)e.getMessage());
        }
    }

    public String getNodeIdentifier() {
        if (this.nodeId == null) {
            return "none";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nodeId.length; ++i) {
            sb.append(String.format("%02X%s", this.nodeId[i], i < this.nodeId.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    private boolean restoreState() throws IOException {
        Properties prop = new Properties();
        if (this.stateFile.exists()) {
            try (FileInputStream is = new FileInputStream(this.stateFile);){
                prop.load(is);
            }
        }
        if (this.getNodeIdentifier().equals(prop.getProperty("nodeId"))) {
            try {
                Integer seq = Integer.valueOf(prop.getProperty("clockSeq")) & 0x3FFF;
                Long ts = Long.valueOf(prop.getProperty("timeStamp"));
                this.clockSeq.set(seq);
                this.timeStamp.set(ts);
                log.debug("Restored state from '{}'", (Object)this.stateFile);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void saveState() {
        if (!this.canSaveState) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("nodeId", this.getNodeIdentifier());
        prop.setProperty("clockSeq", String.valueOf(this.clockSeq.get()));
        prop.setProperty("timeStamp", String.valueOf(this.timeStamp.get()));
        File dir = this.stateFile.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(this.stateFile);){
            prop.store(os, "ebean uuid state file");
            log.debug("Persisted state to '{}'", (Object)this.stateFile);
        }
        catch (IOException e) {
            log.error("Could not persist uuid state to '{}'", (Object)this.stateFile, (Object)e);
        }
    }

    @Override
    protected byte[] getNodeIdBytes() {
        return this.nodeId;
    }
}

