/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.EncryptKey;
import io.ebean.config.Encryptor;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class SimpleAesEncryptor
implements Encryptor {
    private static final String AES_CIPHER = "AES/CBC/PKCS5Padding";
    private static final String padding = "asldkalsdkadsdfkjsldfjl";

    private String paddKey(EncryptKey encryptKey) {
        String key = encryptKey.getStringValue();
        int addChars = 16 - key.length();
        if (addChars < 0) {
            return key.substring(0, 16);
        }
        if (addChars > 0) {
            return key + padding.substring(0, addChars);
        }
        return key;
    }

    private IvParameterSpec getIvParameterSpec(String initialVector) {
        return new IvParameterSpec(initialVector.getBytes());
    }

    public byte[] decrypt(byte[] data, EncryptKey encryptKey) {
        if (data == null) {
            return null;
        }
        String key = this.paddKey(encryptKey);
        try {
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec iv = this.getIvParameterSpec(key);
            SecretKeySpec sks = new SecretKeySpec(keyBytes, "AES");
            Cipher c = Cipher.getInstance(AES_CIPHER);
            c.init(2, (Key)sks, iv);
            return c.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] data, EncryptKey encryptKey) {
        if (data == null) {
            return null;
        }
        String key = this.paddKey(encryptKey);
        try {
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            IvParameterSpec iv = this.getIvParameterSpec(key);
            SecretKeySpec sks = new SecretKeySpec(keyBytes, "AES");
            Cipher c = Cipher.getInstance(AES_CIPHER);
            c.init(1, (Key)sks, iv);
            return c.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decryptString(byte[] data, EncryptKey key) {
        if (data == null) {
            return null;
        }
        byte[] bytes = this.decrypt(data, key);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] encryptString(String valueFormatValue, EncryptKey key) {
        if (valueFormatValue == null) {
            return null;
        }
        byte[] d = valueFormatValue.getBytes(StandardCharsets.UTF_8);
        return this.encrypt(d, key);
    }
}

