/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarDataReader;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetric;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import io.ebeaninternal.server.query.CQueryPlanStats;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.query.DQueryPlanOutput;
import io.ebeaninternal.server.query.RawSqlQueryPlanKey;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.SqlTreePlan;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataBindCapture;
import io.ebeaninternal.server.type.RsetDataReader;
import io.ebeaninternal.server.util.Md5;
import io.ebeaninternal.server.util.Str;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class CQueryPlan
implements SpiQueryPlan {
    static final String RESULT_SET_BASED_RAW_SQL = "--ResultSetBasedRawSql";
    private final SpiEbeanServer server;
    private final ProfileLocation profileLocation;
    private final String location;
    private final String label;
    private final String name;
    private final CQueryPlanKey planKey;
    private final boolean rawSql;
    private final String sql;
    private final String hash;
    private final String logWhereSql;
    private final SqlTreePlan sqlTree;
    private final STreeProperty[] encryptedProps;
    private final CQueryPlanStats stats;
    private final Class<?> beanType;
    final DataTimeZone dataTimeZone;
    private final int asOfTableCount;
    private volatile String auditQueryHash;
    private final Set<String> dependentTables;
    private final SpiQueryBindCapture bindCapture;

    CQueryPlan(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTreePlan sqlTree, boolean rawSql, String logWhereSql) {
        this.server = request.server();
        this.dataTimeZone = this.server.dataTimeZone();
        this.beanType = request.descriptor().type();
        this.planKey = request.queryPlanKey();
        Query query = request.query();
        this.profileLocation = query.getProfileLocation();
        this.location = this.profileLocation == null ? null : this.profileLocation.location();
        this.label = query.getPlanLabel();
        this.name = this.deriveName(this.label, query.getType(), request.descriptor().simpleName());
        this.asOfTableCount = query.getAsOfTableCount();
        this.sql = sqlRes.getSql();
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
        this.stats = new CQueryPlanStats(this);
        this.dependentTables = sqlTree.dependentTables();
        this.bindCapture = this.initBindCapture((SpiQuery<?>)query);
        this.hash = Md5.hash(this.sql, this.name, this.location);
    }

    CQueryPlan(OrmQueryRequest<?> request, String sql, SqlTreePlan sqlTree, String logWhereSql) {
        this.server = request.server();
        this.dataTimeZone = this.server.dataTimeZone();
        this.beanType = request.descriptor().type();
        Query query = request.query();
        this.profileLocation = query.getProfileLocation();
        this.location = this.profileLocation == null ? null : this.profileLocation.location();
        this.label = query.getPlanLabel();
        this.name = this.deriveName(this.label, query.getType(), request.descriptor().simpleName());
        this.planKey = this.buildPlanKey(sql, logWhereSql);
        this.asOfTableCount = 0;
        this.sql = sql;
        this.sqlTree = sqlTree;
        this.rawSql = false;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
        this.stats = new CQueryPlanStats(this);
        this.dependentTables = sqlTree.dependentTables();
        this.bindCapture = this.initBindCaptureRaw(sql, (SpiQuery<?>)query);
        this.hash = Md5.hash(sql, this.name, this.location);
    }

    private String deriveName(String label, SpiQuery.Type type, String simpleName) {
        if (label == null) {
            return Str.add("orm.", simpleName, ".", type.label());
        }
        int pos = simpleName.indexOf(46);
        if (pos > 1) {
            return Str.add("orm.", simpleName.substring(0, pos), "_", label);
        }
        if (label.startsWith(simpleName)) {
            return Str.add("orm.", label);
        }
        return Str.add("orm.", simpleName, "_", label);
    }

    private SpiQueryBindCapture initBindCapture(SpiQuery<?> query) {
        return query.getType().isUpdate() ? SpiQueryBindCapture.NOOP : this.server.createQueryBindCapture(this);
    }

    private SpiQueryBindCapture initBindCaptureRaw(String sql, SpiQuery<?> query) {
        return sql.equals(RESULT_SET_BASED_RAW_SQL) || query.getType().isUpdate() ? SpiQueryBindCapture.NOOP : this.server.createQueryBindCapture(this);
    }

    private CQueryPlanKey buildPlanKey(String sql, String logWhereSql) {
        return new RawSqlQueryPlanKey(sql, false, logWhereSql);
    }

    public String toString() {
        return this.beanType + " hash:" + this.planKey;
    }

    @Override
    public final Class<?> getBeanType() {
        return this.beanType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getHash() {
        return this.hash;
    }

    @Override
    public final String getSql() {
        return this.sql;
    }

    @Override
    public final ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    public final String getLabel() {
        return this.label;
    }

    public final Set<String> getDependentTables() {
        return this.dependentTables;
    }

    public final String getLocation() {
        return this.location;
    }

    @Override
    public final void queryPlanInit(long thresholdMicros) {
        this.bindCapture.queryPlanInit(thresholdMicros);
    }

    @Override
    public final DQueryPlanOutput createMeta(String bind, String planString) {
        return new DQueryPlanOutput(this.getBeanType(), this.name, this.hash, this.sql, this.profileLocation, bind, planString);
    }

    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReader(this.dataTimeZone, rset);
    }

    final DataBind bindEncryptedProperties(PreparedStatement stmt, Connection conn) throws SQLException {
        DataBind dataBind = new DataBind(this.dataTimeZone, stmt, conn);
        if (this.encryptedProps != null) {
            for (STreeProperty encryptedProp : this.encryptedProps) {
                dataBind.setString(encryptedProp.encryptKeyAsString());
            }
        }
        return dataBind;
    }

    private DataBindCapture bindCapture() throws SQLException {
        DataBindCapture dataBind = DataBindCapture.of(this.dataTimeZone);
        if (this.encryptedProps != null) {
            for (STreeProperty encryptedProp : this.encryptedProps) {
                dataBind.setString(encryptedProp.encryptKeyAsString());
            }
        }
        return dataBind;
    }

    final int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    final String getAuditQueryKey() {
        if (this.auditQueryHash == null) {
            this.auditQueryHash = this.calcAuditQueryKey();
        }
        return this.auditQueryHash;
    }

    private String calcAuditQueryKey() {
        return this.rawSql ? this.planKey.getPartialKey() + "_" + this.hash : this.planKey.getPartialKey();
    }

    final SqlTreePlan getSqlTree() {
        return this.sqlTree;
    }

    public final boolean isRawSql() {
        return this.rawSql;
    }

    final String getLogWhereSql() {
        return this.logWhereSql;
    }

    public final void resetStatistics() {
        this.stats.reset();
    }

    final boolean executionTime(long timeMicros) {
        this.stats.add(timeMicros);
        return this.bindCapture != null && this.bindCapture.collectFor(timeMicros);
    }

    public final CQueryPlanStats.Snapshot getSnapshot(boolean reset) {
        return this.stats.getSnapshot(reset);
    }

    public final long getLastQueryTime() {
        return this.stats.getLastQueryTime();
    }

    final ScalarDataReader<?> getSingleAttributeScalarType() {
        return this.sqlTree.getRootNode().getSingleAttributeReader();
    }

    public final boolean isEmptyStats() {
        return this.stats.isEmpty();
    }

    final TimedMetric createTimedMetric() {
        return MetricFactory.get().createTimedMetric(this.label);
    }

    final void captureBindForQueryPlan(CQueryPredicates predicates, long executionTimeMicros) {
        long startNanos = System.nanoTime();
        try {
            DataBindCapture capture = this.bindCapture();
            predicates.bind(capture);
            this.bindCapture.setBind(capture.bindCapture(), executionTimeMicros, startNanos);
        }
        catch (SQLException e) {
            CoreLog.log.error("Error capturing bind values", (Throwable)e);
        }
    }
}

