/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.avaje.lang.NonNullApi;
import io.ebean.CacheMode;
import io.ebean.CountDistinctOrder;
import io.ebean.Database;
import io.ebean.DtoQuery;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.OrderBy;
import io.ebean.PagedList;
import io.ebean.PersistenceContextScope;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.QueryType;
import io.ebean.RawSql;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.bean.CallOrigin;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.ObjectGraphOrigin;
import io.ebean.bean.PersistenceContext;
import io.ebean.event.BeanQueryRequest;
import io.ebean.event.readaudit.ReadEvent;
import io.ebean.plugin.BeanType;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.CacheIdLookup;
import io.ebeaninternal.api.CacheIdLookupMany;
import io.ebeaninternal.api.CacheIdLookupSingle;
import io.ebeaninternal.api.HashQuery;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.api.SpiNamedParam;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanNaturalKey;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.expression.DefaultExpressionList;
import io.ebeaninternal.server.expression.IdInExpression;
import io.ebeaninternal.server.expression.InExpression;
import io.ebeaninternal.server.expression.SimpleExpression;
import io.ebeaninternal.server.query.NativeSqlQueryPlanKey;
import io.ebeaninternal.server.querydefn.AbstractQuery;
import io.ebeaninternal.server.querydefn.DefaultUpdateQuery;
import io.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import io.ebeaninternal.server.querydefn.ONamedParam;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryPlanKey;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.server.querydefn.OrmQuerySecondary;
import io.ebeaninternal.server.querydefn.OrmUpdateProperties;
import io.ebeaninternal.server.querydefn.SpiFetchGroup;
import io.ebeaninternal.server.rawsql.SpiRawSql;
import io.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.persistence.PersistenceException;

@NonNullApi
public final class DefaultOrmQuery<T>
extends AbstractQuery
implements SpiQuery<T> {
    private static final String DEFAULT_QUERY_NAME = "default";
    private static final FetchConfig FETCH_CACHE = FetchConfig.ofCache();
    private static final FetchConfig FETCH_QUERY = FetchConfig.ofQuery();
    private static final FetchConfig FETCH_LAZY = FetchConfig.ofLazy();
    private final Class<T> beanType;
    private final ExpressionFactory expressionFactory;
    private final BeanDescriptor<T> rootBeanDescriptor;
    private BeanDescriptor<T> beanDescriptor;
    private SpiEbeanServer server;
    private SpiTransaction transaction;
    private TableJoin m2mIncludeJoin;
    private ProfilingListener profilingListener;
    private SpiQuery.Type type;
    private String label;
    private SpiQuery.Mode mode = SpiQuery.Mode.NORMAL;
    private Object tenantId;
    private OrmQueryDetail detail;
    private int maxRows;
    private int firstRow;
    private boolean disableLazyLoading;
    private int lazyLoadBatchSize;
    private OrderBy<T> orderBy;
    private String loadMode;
    private String loadDescription;
    private String generatedSql;
    private String lazyLoadProperty;
    private String lazyLoadManyPath;
    private boolean allowLoadErrors;
    private boolean manualId;
    private boolean distinct;
    private boolean futureFetch;
    private ReadEvent futureFetchAudit;
    private int timeout;
    private String mapKey;
    private Object id;
    private Map<String, ONamedParam> namedParams;
    private BindParams bindParams;
    private DefaultExpressionList<T> textExpressions;
    private DefaultExpressionList<T> whereExpressions;
    private DefaultExpressionList<T> havingExpressions;
    private boolean asOfBaseTable;
    private int asOfTableCount;
    private Timestamp asOf;
    private SpiQuery.TemporalMode temporalMode = SpiQuery.TemporalMode.CURRENT;
    private Timestamp versionsStart;
    private Timestamp versionsEnd;
    private List<String> softDeletePredicates;
    private boolean disableReadAudit;
    private int bufferFetchSizeHint;
    private boolean usageProfiling = true;
    private CacheMode useBeanCache = CacheMode.AUTO;
    private CacheMode useQueryCache = CacheMode.OFF;
    private Boolean readOnly;
    private PersistenceContextScope persistenceContextScope;
    private Boolean autoTune;
    private Query.LockWait forUpdate;
    private Query.LockType lockType;
    private boolean singleAttribute;
    private CountDistinctOrder countDistinctOrder;
    private boolean autoTuned;
    private String rootTableAlias;
    private String baseTable;
    private ObjectGraphNode parentNode;
    private BeanPropertyAssocMany<?> lazyLoadForParentsProperty;
    private CQueryPlanKey queryPlanKey;
    private PersistenceContext persistenceContext;
    private ManyWhereJoins manyWhereJoins;
    private SpiRawSql rawSql;
    private boolean useDocStore;
    private String docIndexName;
    private OrmUpdateProperties updateProperties;
    private String nativeSql;
    private boolean orderById;
    private ProfileLocation profileLocation;

    public DefaultOrmQuery(BeanDescriptor<T> desc, SpiEbeanServer server, ExpressionFactory expressionFactory) {
        this.beanDescriptor = desc;
        this.rootBeanDescriptor = desc;
        this.beanType = desc.type();
        this.server = server;
        this.orderById = server.config().isDefaultOrderById();
        this.disableLazyLoading = server.config().isDisableLazyLoading();
        this.expressionFactory = expressionFactory;
        this.detail = new OrmQueryDetail();
    }

    public void setNativeSql(String nativeSql) {
        this.nativeSql = nativeSql;
    }

    public <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.server.findDto(dtoClass, this);
    }

    public UpdateQuery<T> asUpdate() {
        return new DefaultUpdateQuery(this);
    }

    @Override
    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public boolean isFindAll() {
        return this.whereExpressions == null && this.nativeSql == null && this.rawSql == null;
    }

    @Override
    public boolean isFindById() {
        if (this.id == null && this.whereExpressions != null) {
            this.id = this.whereExpressions.idEqualTo(this.beanDescriptor.idName());
            if (this.id != null) {
                this.whereExpressions = null;
            }
        }
        return this.id != null;
    }

    @Override
    public String profileEventId() {
        switch (this.mode) {
            case LAZYLOAD_BEAN: {
                return "lo";
            }
            case LAZYLOAD_MANY: {
                return "lm";
            }
        }
        return this.type.profileEventId();
    }

    @Override
    public String getProfileId() {
        return this.getPlanLabel();
    }

    public Query<T> setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        return this;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getPlanLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.profileLocation != null) {
            return this.profileLocation.label();
        }
        return null;
    }

    @Override
    public void setProfilePath(String label, String relativePath, ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        this.label = (profileLocation == null ? label : profileLocation.label()) + "_" + relativePath;
    }

    public Query<T> setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public boolean isAutoTunable() {
        return this.nativeSql == null && this.beanDescriptor.isAutoTunable();
    }

    public Query<T> setUseDocStore(boolean useDocStore) {
        this.useDocStore = useDocStore;
        return this;
    }

    @Override
    public boolean isUseDocStore() {
        return this.useDocStore;
    }

    public Query<T> apply(FetchPath fetchPath) {
        fetchPath.apply((Query)this);
        return this;
    }

    @Override
    public void addSoftDeletePredicate(String softDeletePredicate) {
        if (this.softDeletePredicates == null) {
            this.softDeletePredicates = new ArrayList<String>();
        }
        this.softDeletePredicates.add(softDeletePredicate);
    }

    @Override
    public List<String> getSoftDeletePredicates() {
        return this.softDeletePredicates;
    }

    @Override
    public boolean isAsOfBaseTable() {
        return this.asOfBaseTable;
    }

    @Override
    public void setAsOfBaseTable() {
        this.asOfBaseTable = true;
    }

    public Query<T> setAllowLoadErrors() {
        this.allowLoadErrors = true;
        return this;
    }

    @Override
    public void incrementAsOfTableCount() {
        ++this.asOfTableCount;
    }

    @Override
    public int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    @Override
    public Timestamp getAsOf() {
        return this.asOf;
    }

    public Query<T> asOf(Timestamp asOfDateTime) {
        this.temporalMode = asOfDateTime != null ? SpiQuery.TemporalMode.AS_OF : SpiQuery.TemporalMode.CURRENT;
        this.asOf = asOfDateTime;
        return this;
    }

    public Query<T> asDraft() {
        this.temporalMode = SpiQuery.TemporalMode.DRAFT;
        this.useBeanCache = CacheMode.OFF;
        return this;
    }

    public Query<T> setIncludeSoftDeletes() {
        this.temporalMode = SpiQuery.TemporalMode.SOFT_DELETED;
        return this;
    }

    public Query<T> setDocIndexName(String indexName) {
        this.docIndexName = indexName;
        this.useDocStore = true;
        return this;
    }

    @Override
    public String getDocIndexName() {
        return this.docIndexName;
    }

    @Override
    public SpiRawSql getRawSql() {
        return this.rawSql;
    }

    public Query<T> setRawSql(RawSql rawSql) {
        this.rawSql = (SpiRawSql)rawSql;
        return this;
    }

    @Override
    public String getOriginKey() {
        if (this.parentNode == null || this.parentNode.getOriginQueryPoint() == null) {
            return null;
        }
        return this.parentNode.getOriginQueryPoint().getKey();
    }

    @Override
    public int getLazyLoadBatchSize() {
        return this.lazyLoadBatchSize;
    }

    public Query<T> setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.lazyLoadBatchSize = lazyLoadBatchSize;
        return this;
    }

    @Override
    public String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    @Override
    public void setLazyLoadProperty(String lazyLoadProperty) {
        this.lazyLoadProperty = lazyLoadProperty;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    private void createExtraJoinsToSupportManyWhereClause() {
        this.manyWhereJoins = new ManyWhereJoins();
        if (this.whereExpressions != null) {
            this.whereExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.containsMany(this.beanDescriptor, this.manyWhereJoins);
        }
        if (this.orderBy != null) {
            for (OrderBy.Property orderProperty : this.orderBy.getProperties()) {
                ElPropertyDeploy elProp = this.beanDescriptor.elPropertyDeploy(orderProperty.getProperty());
                if (elProp == null || !elProp.containsFormulaWithJoin()) continue;
                this.manyWhereJoins.addFormulaWithJoin(elProp.elPrefix(), elProp.name());
            }
        }
    }

    @Override
    public ManyWhereJoins getManyWhereJoins() {
        return this.manyWhereJoins;
    }

    @Override
    public boolean selectAllForLazyLoadProperty() {
        if (this.lazyLoadProperty != null && !this.detail.containsProperty(this.lazyLoadProperty)) {
            this.detail.select("*");
            return true;
        }
        return false;
    }

    private List<OrmQueryProperties> removeQueryJoins() {
        List<OrmQueryProperties> queryJoins = this.detail.removeSecondaryQueries();
        if (queryJoins != null && this.orderBy != null) {
            for (OrmQueryProperties joinPath : queryJoins) {
                List properties = this.orderBy.getProperties();
                Iterator it = properties.iterator();
                while (it.hasNext()) {
                    OrderBy.Property property = (OrderBy.Property)it.next();
                    if (!property.getProperty().startsWith(joinPath.getPath())) continue;
                    it.remove();
                    joinPath.addSecJoinOrderProperty(property);
                }
            }
        }
        return queryJoins;
    }

    private List<OrmQueryProperties> removeLazyJoins() {
        return this.detail.removeSecondaryLazyQueries();
    }

    @Override
    public void setLazyLoadManyPath(String lazyLoadManyPath) {
        this.lazyLoadManyPath = lazyLoadManyPath;
    }

    @Override
    public SpiQuerySecondary convertJoins() {
        if (!this.useDocStore) {
            this.createExtraJoinsToSupportManyWhereClause();
        }
        this.markQueryJoins();
        return new OrmQuerySecondary(this.removeQueryJoins(), this.removeLazyJoins());
    }

    private void markQueryJoins() {
        this.detail.markQueryJoins(this.beanDescriptor, this.lazyLoadManyPath, this.isAllowOneManyFetch(), this.type.defaultSelect());
    }

    private boolean isAllowOneManyFetch() {
        if (SpiQuery.Mode.LAZYLOAD_MANY == this.mode) {
            return false;
        }
        return !this.hasMaxRowsOrFirstRow() || this.isRawSql();
    }

    @Override
    public void setDefaultSelectClause() {
        if (this.type.defaultSelect()) {
            this.detail.setDefaultSelectClause(this.beanDescriptor);
        } else if (!this.detail.hasSelectClause()) {
            this.detail.setEmptyBase();
        }
    }

    @Override
    public void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setDetail(OrmQueryDetail detail) {
        this.detail = detail;
    }

    @Override
    public boolean tuneFetchProperties(OrmQueryDetail tunedDetail) {
        return this.detail.tuneFetchProperties(tunedDetail);
    }

    @Override
    public OrmQueryDetail getDetail() {
        return this.detail;
    }

    public ExpressionList<T> filterMany(String prop) {
        OrmQueryProperties chunk = this.detail.getChunk(prop, true);
        return chunk.filterMany(this);
    }

    @Override
    public void setFilterMany(String prop, ExpressionList<?> filterMany) {
        if (filterMany != null) {
            OrmQueryProperties chunk = this.detail.getChunk(prop, true);
            chunk.setFilterMany((SpiExpressionList)filterMany);
        }
    }

    @Override
    public void prepareDocNested() {
        if (this.textExpressions != null) {
            this.textExpressions.prepareDocNested(this.beanDescriptor);
        }
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareDocNested(this.beanDescriptor);
        }
    }

    @Override
    public void setupForDeleteOrUpdate() {
        this.forUpdate = null;
        this.rootTableAlias = "${RTA}";
        this.setSelectId();
    }

    @Override
    public CQueryPlanKey setDeleteByIdsPlan() {
        this.queryPlanKey = this.queryPlanKey.withDeleteByIds();
        return this.queryPlanKey;
    }

    @Override
    public void setSelectId() {
        this.detail.clear();
        this.select(this.beanDescriptor.idSelect());
    }

    @Override
    public void setSingleAttribute() {
        this.singleAttribute = true;
    }

    @Override
    public boolean isSingleAttribute() {
        return this.singleAttribute;
    }

    @Override
    public CountDistinctOrder getCountDistinctOrder() {
        return this.countDistinctOrder;
    }

    @Override
    public boolean isWithId() {
        return !this.manualId && !this.distinct && !this.singleAttribute;
    }

    @Override
    public CacheIdLookup<T> cacheIdLookup() {
        if (this.whereExpressions == null) {
            return null;
        }
        List<SpiExpression> underlyingList = this.whereExpressions.getUnderlyingList();
        if (underlyingList.isEmpty()) {
            if (this.id != null) {
                return new CacheIdLookupSingle(this.id);
            }
        } else if (underlyingList.size() == 1) {
            InExpression in;
            SpiExpression singleExpression = underlyingList.get(0);
            if (singleExpression instanceof IdInExpression) {
                return new CacheIdLookupMany((IdInExpression)singleExpression);
            }
            if (singleExpression instanceof InExpression && (in = (InExpression)singleExpression).property().equals(this.beanDescriptor.idName())) {
                return new CacheIdLookupMany(in);
            }
        }
        return null;
    }

    @Override
    public NaturalKeyQueryData<T> naturalKey() {
        if (this.whereExpressions == null) {
            return null;
        }
        BeanNaturalKey naturalKey = this.beanDescriptor.naturalKey();
        if (naturalKey == null) {
            return null;
        }
        NaturalKeyQueryData data = new NaturalKeyQueryData(naturalKey);
        for (SpiExpression expression : this.whereExpressions.getUnderlyingList()) {
            if (expression.naturalKey(data)) continue;
            return null;
        }
        return data;
    }

    @Override
    public NaturalKeyBindParam getNaturalKeyBindParam() {
        NaturalKeyBindParam namedBind = null;
        if (this.bindParams != null && (namedBind = this.bindParams.getNaturalKeyBindParam()) == null) {
            return null;
        }
        if (this.whereExpressions != null) {
            SimpleExpression e;
            List<SpiExpression> exprList = this.whereExpressions.internalList();
            if (exprList.size() > 1) {
                return null;
            }
            if (exprList.isEmpty()) {
                return namedBind;
            }
            if (namedBind != null) {
                return null;
            }
            SpiExpression se = exprList.get(0);
            if (se instanceof SimpleExpression && (e = (SimpleExpression)se).isOpEquals()) {
                return new NaturalKeyBindParam(e.getPropName(), e.getValue());
            }
        }
        return null;
    }

    @Override
    public SpiQuery<T> copy() {
        return this.copy(this.server);
    }

    @Override
    public SpiQuery<T> copy(SpiEbeanServer server) {
        DefaultOrmQuery<T> copy = new DefaultOrmQuery<T>(this.beanDescriptor, server, this.expressionFactory);
        copy.transaction = this.transaction;
        copy.m2mIncludeJoin = this.m2mIncludeJoin;
        copy.profilingListener = this.profilingListener;
        copy.profileLocation = this.profileLocation;
        copy.baseTable = this.baseTable;
        copy.rootTableAlias = this.rootTableAlias;
        copy.distinct = this.distinct;
        copy.allowLoadErrors = this.allowLoadErrors;
        copy.timeout = this.timeout;
        copy.mapKey = this.mapKey;
        copy.id = this.id;
        copy.label = this.label;
        copy.nativeSql = this.nativeSql;
        copy.useBeanCache = this.useBeanCache;
        copy.useQueryCache = this.useQueryCache;
        copy.readOnly = this.readOnly;
        if (this.detail != null) {
            copy.detail = this.detail.copy();
        }
        copy.temporalMode = this.temporalMode;
        copy.firstRow = this.firstRow;
        copy.maxRows = this.maxRows;
        if (this.orderBy != null) {
            copy.orderBy = this.orderBy.copy();
        }
        copy.orderById = this.orderById;
        if (this.bindParams != null) {
            copy.bindParams = this.bindParams.copy();
        }
        if (this.whereExpressions != null) {
            copy.whereExpressions = this.whereExpressions.copy(copy);
        }
        if (this.havingExpressions != null) {
            copy.havingExpressions = this.havingExpressions.copy(copy);
        }
        copy.persistenceContextScope = this.persistenceContextScope;
        copy.usageProfiling = this.usageProfiling;
        copy.autoTune = this.autoTune;
        copy.parentNode = this.parentNode;
        copy.forUpdate = this.forUpdate;
        copy.rawSql = this.rawSql;
        this.setCancelableQuery(copy);
        return copy;
    }

    public Query<T> setPersistenceContextScope(PersistenceContextScope scope) {
        this.persistenceContextScope = scope;
        return this;
    }

    @Override
    public PersistenceContextScope getPersistenceContextScope() {
        return this.persistenceContextScope;
    }

    @Override
    public SpiQuery.Type getType() {
        return this.type;
    }

    @Override
    public void setType(SpiQuery.Type type) {
        this.type = type;
    }

    @Override
    public String getLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public String getLoadMode() {
        return this.loadMode;
    }

    @Override
    public void setLoadDescription(String loadMode, String loadDescription) {
        this.loadMode = loadMode;
        this.loadDescription = loadDescription;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public void setLazyLoadForParents(BeanPropertyAssocMany<?> many) {
        this.lazyLoadForParentsProperty = many;
    }

    @Override
    public BeanPropertyAssocMany<?> getLazyLoadMany() {
        return this.lazyLoadForParentsProperty;
    }

    @Override
    public boolean isDetailEmpty() {
        return this.detail.isEmpty();
    }

    public boolean isAutoTuned() {
        return this.autoTuned;
    }

    @Override
    public void setAutoTuned(boolean autoTuned) {
        this.autoTuned = autoTuned;
    }

    @Override
    public Boolean isAutoTune() {
        return this.autoTune;
    }

    @Override
    public void setDefaultRawSqlIfRequired() {
        if (this.beanDescriptor.isRawSqlBased() && this.rawSql == null) {
            this.rawSql = this.beanDescriptor.namedRawSql(DEFAULT_QUERY_NAME);
        }
    }

    public Query<T> setAutoTune(boolean autoTune) {
        this.autoTune = autoTune;
        return this;
    }

    public Query<T> withLock(Query.LockType lockType) {
        return this.setForUpdateWithMode(Query.LockWait.WAIT, lockType);
    }

    public Query<T> withLock(Query.LockType lockType, Query.LockWait lockWait) {
        return this.setForUpdateWithMode(lockWait, lockType);
    }

    public Query<T> forUpdate() {
        return this.setForUpdateWithMode(Query.LockWait.WAIT, Query.LockType.DEFAULT);
    }

    public Query<T> forUpdateNoWait() {
        return this.setForUpdateWithMode(Query.LockWait.NOWAIT, Query.LockType.DEFAULT);
    }

    public Query<T> forUpdateSkipLocked() {
        return this.setForUpdateWithMode(Query.LockWait.SKIPLOCKED, Query.LockType.DEFAULT);
    }

    private Query<T> setForUpdateWithMode(Query.LockWait mode, Query.LockType lockType) {
        this.forUpdate = mode;
        this.lockType = lockType;
        this.useBeanCache = CacheMode.OFF;
        return this;
    }

    public boolean isForUpdate() {
        return this.forUpdate != null;
    }

    @Override
    public Query.LockWait getForUpdateLockWait() {
        return this.forUpdate;
    }

    public Query.LockType getForUpdateLockType() {
        return this.lockType;
    }

    @Override
    public ProfilingListener getProfilingListener() {
        return this.profilingListener;
    }

    @Override
    public void setProfilingListener(ProfilingListener profilingListener) {
        this.profilingListener = profilingListener;
    }

    public QueryType getQueryType() {
        if (this.type != null) {
            switch (this.type) {
                case DELETE: {
                    return QueryType.DELETE;
                }
                case UPDATE: {
                    return QueryType.UPDATE;
                }
            }
        }
        return QueryType.FIND;
    }

    @Override
    public SpiQuery.Mode getMode() {
        return this.mode;
    }

    @Override
    public SpiQuery.TemporalMode getTemporalMode() {
        return this.temporalMode;
    }

    @Override
    public boolean isAsOfQuery() {
        return this.asOf != null;
    }

    @Override
    public boolean isAsDraft() {
        return SpiQuery.TemporalMode.DRAFT == this.temporalMode;
    }

    @Override
    public boolean isIncludeSoftDeletes() {
        return SpiQuery.TemporalMode.SOFT_DELETED == this.temporalMode;
    }

    @Override
    public void setMode(SpiQuery.Mode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isUsageProfiling() {
        return this.usageProfiling;
    }

    @Override
    public void setUsageProfiling(boolean usageProfiling) {
        this.usageProfiling = usageProfiling;
    }

    @Override
    public void setParentNode(ObjectGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public ObjectGraphNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public ObjectGraphNode setOrigin(CallOrigin callOrigin) {
        ObjectGraphOrigin o = new ObjectGraphOrigin(this.calculateOriginQueryHash(), callOrigin, this.beanType.getName());
        this.parentNode = new ObjectGraphNode(o, null);
        return this.parentNode;
    }

    private int calculateOriginQueryHash() {
        int hc = this.beanType.getName().hashCode();
        hc = hc * 92821 + (this.type == null ? 0 : this.type.ordinal());
        return hc;
    }

    CQueryPlanKey createQueryPlanKey() {
        if (this.isNativeSql()) {
            String bindHash = this.bindParams == null ? "" : this.bindParams.calcQueryPlanHash();
            this.queryPlanKey = new NativeSqlQueryPlanKey(this.type.ordinal() + this.nativeSql + "-" + this.firstRow + "-" + this.maxRows + "-" + bindHash);
        } else {
            this.queryPlanKey = new OrmQueryPlanKey(this.planDescription(), this.maxRows, this.firstRow, this.rawSql);
        }
        return this.queryPlanKey;
    }

    private String planDescription() {
        StringBuilder sb = new StringBuilder(300);
        if (this.type != null) {
            sb.append(this.type.ordinal());
        }
        if (this.useDocStore) {
            sb.append("/ds");
        }
        if (this.beanDescriptor.discValue() != null) {
            sb.append("/dv").append(this.beanDescriptor.discValue());
        }
        if (this.temporalMode != SpiQuery.TemporalMode.CURRENT) {
            sb.append("/tm").append(this.temporalMode.ordinal());
            if (this.versionsStart != null) {
                sb.append("v");
            }
        }
        if (this.forUpdate != null) {
            sb.append("/fu").append(this.forUpdate.ordinal());
            if (this.lockType != null) {
                sb.append("t").append(this.lockType.ordinal());
            }
        }
        if (this.id != null) {
            sb.append("/id");
        }
        if (this.manualId) {
            sb.append("/md");
        }
        if (this.distinct) {
            sb.append("/dt");
        }
        if (this.allowLoadErrors) {
            sb.append("/ae");
        }
        if (this.disableLazyLoading) {
            sb.append("/dl");
        }
        if (this.baseTable != null) {
            sb.append("/bt").append(this.baseTable);
        }
        if (this.rootTableAlias != null) {
            sb.append("/ra").append(this.rootTableAlias);
        }
        if (this.orderBy != null) {
            sb.append("/ob").append(this.orderBy.toStringFormat());
        }
        if (this.m2mIncludeJoin != null) {
            sb.append("/m2").append(this.m2mIncludeJoin.getTable());
        }
        if (this.mapKey != null) {
            sb.append("/mk").append(this.mapKey);
        }
        if (this.countDistinctOrder != null) {
            sb.append("/cd").append(this.countDistinctOrder.name());
        }
        if (this.detail != null) {
            sb.append("/d[");
            this.detail.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.bindParams != null) {
            sb.append("/b[");
            this.bindParams.buildQueryPlanHash(sb);
            sb.append("]");
        }
        if (this.whereExpressions != null) {
            sb.append("/w[");
            this.whereExpressions.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.havingExpressions != null) {
            sb.append("/h[");
            this.havingExpressions.queryPlanHash(sb);
            sb.append("]");
        }
        if (this.updateProperties != null) {
            sb.append("/u[");
            this.updateProperties.buildQueryPlanHash(sb);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public boolean isNativeSql() {
        return this.nativeSql != null;
    }

    @Override
    public String getNativeSql() {
        return this.nativeSql;
    }

    @Override
    public Object getQueryPlanKey() {
        return this.queryPlanKey;
    }

    @Override
    public CQueryPlanKey prepare(SpiOrmQueryRequest<T> request) {
        this.prepareExpressions(request);
        this.prepareForPaging();
        this.queryPlanKey = this.createQueryPlanKey();
        return this.queryPlanKey;
    }

    private void prepareExpressions(BeanQueryRequest<?> request) {
        this.detail.prepareExpressions(request);
        if (this.whereExpressions != null) {
            this.whereExpressions.prepareExpression(request);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.prepareExpression(request);
        }
    }

    private void prepareForPaging() {
        if (this.orderByIsEmpty() && this.rawSql != null && this.rawSql.getSql() != null) {
            this.order(this.rawSql.getSql().getOrderBy());
        }
        if (this.checkPagingOrderBy()) {
            this.beanDescriptor.appendOrderById(this);
        }
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.id);
        if (this.whereExpressions != null) {
            this.whereExpressions.queryBindKey(key);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.queryBindKey(key);
        }
        if (this.bindParams != null) {
            this.bindParams.queryBindHash(key);
        }
        key.add(this.asOf).add(this.versionsStart).add(this.versionsEnd);
    }

    @Override
    public HashQuery queryHash() {
        BindValuesKey bindKey = new BindValuesKey();
        this.queryBindKey(bindKey);
        return new HashQuery(this.queryPlanKey, bindKey);
    }

    @Override
    public boolean isRawSql() {
        return this.rawSql != null;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean hasMaxRowsOrFirstRow() {
        return this.maxRows > 0 || this.firstRow > 0;
    }

    @Override
    public boolean isVersionsBetween() {
        return this.versionsStart != null;
    }

    @Override
    public Timestamp getVersionStart() {
        return this.versionsStart;
    }

    @Override
    public Timestamp getVersionEnd() {
        return this.versionsEnd;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public Query<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public boolean isBeanCachePut() {
        return this.useBeanCache.isPut() && this.beanDescriptor.isBeanCaching();
    }

    @Override
    public boolean isBeanCacheGet() {
        return this.useBeanCache.isGet() && this.beanDescriptor.isBeanCaching();
    }

    @Override
    public boolean isForceHitDatabase() {
        return this.forUpdate != null || CacheMode.PUT == this.useBeanCache;
    }

    @Override
    public void resetBeanCacheAutoMode(boolean findOne) {
        if (this.useBeanCache == CacheMode.AUTO && this.useQueryCache != CacheMode.OFF) {
            this.useBeanCache = CacheMode.OFF;
        }
    }

    @Override
    public CacheMode getUseBeanCache() {
        return this.useBeanCache;
    }

    @Override
    public CacheMode getUseQueryCache() {
        return this.useQueryCache;
    }

    public Query<T> setBeanCacheMode(CacheMode beanCacheMode) {
        this.useBeanCache = beanCacheMode;
        return this;
    }

    public Query<T> setUseQueryCache(CacheMode useQueryCache) {
        this.useQueryCache = useQueryCache;
        return this;
    }

    public Query<T> setLoadBeanCache(boolean loadBeanCache) {
        this.useBeanCache = CacheMode.PUT;
        return this;
    }

    public Query<T> setTimeout(int secs) {
        this.timeout = secs;
        return this;
    }

    @Override
    public void selectProperties(Set<String> props) {
        this.detail.selectProperties(props);
    }

    @Override
    public void fetchProperties(String property, Set<String> columns, FetchConfig config) {
        this.detail.fetchProperties(property, columns, config);
    }

    @Override
    public void selectProperties(OrmQueryProperties properties) {
        this.detail.selectProperties(properties);
    }

    @Override
    public void fetchProperties(String path, OrmQueryProperties other) {
        this.detail.fetchProperties(path, other);
    }

    @Override
    public void addNested(String name, OrmQueryDetail nestedDetail, FetchConfig config) {
        this.detail.addNested(name, nestedDetail, config);
    }

    public Query<T> select(String columns) {
        this.detail.select(columns);
        return this;
    }

    public Query<T> select(FetchGroup<T> fetchGroup) {
        this.detail = ((SpiFetchGroup)fetchGroup).detail();
        return this;
    }

    public Query<T> fetch(String path) {
        return this.fetch(path, null, null);
    }

    public Query<T> fetch(String path, FetchConfig joinConfig) {
        return this.fetch(path, null, joinConfig);
    }

    public Query<T> fetch(String path, String properties) {
        return this.fetch(path, properties, null);
    }

    public Query<T> fetch(String path, String properties, FetchConfig config) {
        if (this.nativeSql != null && (config == null || config.isJoin())) {
            config = FETCH_QUERY;
        }
        return this.fetchInternal(path, properties, config);
    }

    public Query<T> fetchQuery(String path) {
        return this.fetchInternal(path, null, FETCH_QUERY);
    }

    public Query<T> fetchCache(String path) {
        return this.fetchInternal(path, null, FETCH_CACHE);
    }

    public Query<T> fetchLazy(String path) {
        return this.fetchInternal(path, null, FETCH_LAZY);
    }

    public Query<T> fetchQuery(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_QUERY);
    }

    public Query<T> fetchCache(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_CACHE);
    }

    public Query<T> fetchLazy(String path, String properties) {
        return this.fetchInternal(path, properties, FETCH_LAZY);
    }

    private Query<T> fetchInternal(String path, String properties, FetchConfig config) {
        this.detail.fetch(path, properties, config);
        return this;
    }

    public Query<T> usingTransaction(Transaction transaction) {
        this.transaction = (SpiTransaction)transaction;
        return this;
    }

    public Query<T> usingConnection(Connection connection) {
        this.transaction = new ExternalJdbcTransaction(connection);
        return this;
    }

    public Query<T> usingDatabase(Database database) {
        this.server = (SpiEbeanServer)database;
        return this;
    }

    public int delete() {
        return this.server.delete(this, this.transaction);
    }

    public int delete(Transaction transaction) {
        return this.server.delete(this, transaction);
    }

    public int update() {
        return this.server.update(this, this.transaction);
    }

    public int update(Transaction transaction) {
        return this.server.update(this, transaction);
    }

    public <A> List<A> findIds() {
        return this.server.findIds(this, this.transaction);
    }

    public boolean exists() {
        return this.server.exists(this, this.transaction);
    }

    public int findCount() {
        return this.server.findCount(this, this.transaction);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.server.findEachWhile(this, consumer, this.transaction);
    }

    public void findEach(Consumer<T> consumer) {
        this.server.findEach(this, consumer, this.transaction);
    }

    public void findEach(int batch, Consumer<List<T>> consumer) {
        this.server.findEach(this, batch, consumer, this.transaction);
    }

    public QueryIterator<T> findIterate() {
        return this.server.findIterate(this, this.transaction);
    }

    public Stream<T> findStream() {
        return this.server.findStream(this, this.transaction);
    }

    public Stream<T> findLargeStream() {
        return this.server.findLargeStream(this, this.transaction);
    }

    public List<Version<T>> findVersions() {
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        return this.server.findVersions(this, this.transaction);
    }

    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("start and end must not be null");
        }
        this.temporalMode = SpiQuery.TemporalMode.VERSIONS;
        this.versionsStart = start;
        this.versionsEnd = end;
        return this.server.findVersions(this, this.transaction);
    }

    public List<T> findList() {
        return this.server.findList(this, this.transaction);
    }

    public Set<T> findSet() {
        return this.server.findSet(this, this.transaction);
    }

    public <K> Map<K, T> findMap() {
        return this.server.findMap(this, this.transaction);
    }

    public <A> List<A> findSingleAttributeList() {
        return this.server.findSingleAttributeList(this, this.transaction);
    }

    public <A> A findSingleAttribute() {
        List<A> list = this.findSingleAttributeList();
        return !list.isEmpty() ? (A)list.get(0) : null;
    }

    public T findOne() {
        return (T)this.server.findOne(this, this.transaction);
    }

    public Optional<T> findOneOrEmpty() {
        return this.server.findOneOrEmpty(this, this.transaction);
    }

    public FutureIds<T> findFutureIds() {
        return this.server.findFutureIds(this, this.transaction);
    }

    public FutureList<T> findFutureList() {
        return this.server.findFutureList(this, this.transaction);
    }

    public FutureRowCount<T> findFutureCount() {
        return this.server.findFutureCount(this, this.transaction);
    }

    public PagedList<T> findPagedList() {
        return this.server.findPagedList(this, this.transaction);
    }

    public Query<T> setParameter(Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setNextParameter(value);
        return this;
    }

    public Query<T> setParameters(Object ... values) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setNextParameters(values);
        return this;
    }

    public Query<T> setParameter(int position, Object value) {
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(position, value);
        return this;
    }

    public Query<T> setParameter(String name, Object value) {
        ONamedParam param;
        if (this.namedParams != null && (param = this.namedParams.get(name)) != null) {
            param.setValue(value);
            return this;
        }
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setParameter(name, value);
        return this;
    }

    @Override
    public void setArrayParameter(String name, Collection<?> values) {
        if (this.namedParams != null) {
            throw new IllegalStateException("setArrayParameter() not supported when EQL parsed query");
        }
        if (this.bindParams == null) {
            this.bindParams = new BindParams();
        }
        this.bindParams.setArrayParameter(name, values);
    }

    @Override
    public boolean checkPagingOrderBy() {
        return this.orderById && !this.useDocStore;
    }

    @Override
    public boolean orderByIsEmpty() {
        return this.orderBy == null || this.orderBy.isEmpty();
    }

    @Override
    public OrderBy<T> getOrderBy() {
        return this.orderBy;
    }

    @Deprecated
    public OrderBy<T> orderBy() {
        return this.order();
    }

    public OrderBy<T> order() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy((Query)this, null);
        }
        return this.orderBy;
    }

    @Deprecated
    public Query<T> orderBy(String orderByClause) {
        return this.order(orderByClause);
    }

    public Query<T> order(String orderByClause) {
        this.orderBy = orderByClause == null || orderByClause.trim().isEmpty() ? null : new OrderBy((Query)this, orderByClause);
        return this;
    }

    @Deprecated
    public Query<T> setOrderBy(OrderBy<T> orderBy) {
        return this.setOrder(orderBy);
    }

    public Query<T> setOrder(OrderBy<T> orderBy) {
        this.orderBy = orderBy;
        if (orderBy != null) {
            orderBy.setQuery((Query)this);
        }
        return this;
    }

    @Override
    public boolean isManualId() {
        return this.manualId;
    }

    @Override
    public void setManualId() {
        if (this.detail != null && this.detail.hasSelectClause()) {
            this.manualId = true;
        }
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    public Query<T> setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Query<T> setCountDistinct(CountDistinctOrder countDistinctOrder) {
        this.countDistinctOrder = countDistinctOrder;
        return this;
    }

    public boolean isCountDistinct() {
        return this.countDistinctOrder != null;
    }

    public Class<T> getBeanType() {
        return this.beanType;
    }

    public Class<? extends T> getInheritType() {
        return this.beanDescriptor.type();
    }

    public Query<T> setInheritType(Class<? extends T> type) {
        if (type == this.beanType) {
            return this;
        }
        InheritInfo inheritInfo = this.rootBeanDescriptor.inheritInfo();
        InheritInfo inheritInfo2 = inheritInfo = inheritInfo == null ? null : inheritInfo.readType(type);
        if (inheritInfo == null) {
            throw new IllegalArgumentException("Given type " + type + " is not a subtype of " + this.beanType);
        }
        this.beanDescriptor = this.rootBeanDescriptor.descriptor(type);
        return this;
    }

    public String toString() {
        return "Query [" + this.whereExpressions + "]";
    }

    @Override
    public TableJoin getM2mIncludeJoin() {
        return this.m2mIncludeJoin;
    }

    @Override
    public void setM2MIncludeJoin(TableJoin m2mIncludeJoin) {
        this.m2mIncludeJoin = m2mIncludeJoin;
    }

    public Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        this.disableLazyLoading = disableLazyLoading;
        return this;
    }

    @Override
    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public int getFirstRow() {
        return this.firstRow;
    }

    public Query<T> setFirstRow(int firstRow) {
        this.firstRow = firstRow;
        return this;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    public Query<T> setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    public Query<T> setMapKey(String mapKey) {
        this.mapKey = mapKey;
        return this;
    }

    public Object getId() {
        return this.id;
    }

    public Query<T> setId(Object id) {
        if (id == null) {
            throw new NullPointerException("The id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public BindParams getBindParams() {
        return this.bindParams;
    }

    public Query<T> where(Expression expression) {
        this.where().add(expression);
        return this;
    }

    public ExpressionList<T> text() {
        if (this.textExpressions == null) {
            this.useDocStore = true;
            this.textExpressions = new DefaultExpressionList(this);
        }
        return this.textExpressions;
    }

    public ExpressionList<T> where() {
        if (this.whereExpressions == null) {
            this.whereExpressions = new DefaultExpressionList(this, null);
        }
        return this.whereExpressions;
    }

    @Override
    public void simplifyExpressions() {
        if (this.whereExpressions != null) {
            this.whereExpressions.simplify();
        }
    }

    public Query<T> having(Expression expression) {
        this.having().add(expression);
        return this;
    }

    public ExpressionList<T> having() {
        if (this.havingExpressions == null) {
            this.havingExpressions = new DefaultExpressionList(this, null);
        }
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getHavingExpressions() {
        return this.havingExpressions;
    }

    @Override
    public SpiExpressionList<T> getWhereExpressions() {
        return this.whereExpressions;
    }

    @Override
    public SpiExpressionList<T> getTextExpression() {
        return this.textExpressions;
    }

    public String getGeneratedSql() {
        return this.generatedSql;
    }

    @Override
    public void setGeneratedSql(String generatedSql) {
        this.generatedSql = generatedSql;
    }

    @Override
    public void checkNamedParameters() {
        if (this.namedParams != null) {
            for (ONamedParam value : this.namedParams.values()) {
                value.checkValueSet();
            }
        }
    }

    @Override
    public SpiNamedParam createNamedParameter(String name) {
        if (this.namedParams == null) {
            this.namedParams = new HashMap<String, ONamedParam>();
        }
        return this.namedParams.computeIfAbsent(name, ONamedParam::new);
    }

    @Override
    public void setDefaultFetchBuffer(int fetchSize) {
        if (this.bufferFetchSizeHint == 0) {
            this.bufferFetchSizeHint = fetchSize;
        }
    }

    public Query<T> setBufferFetchSizeHint(int bufferFetchSizeHint) {
        this.bufferFetchSizeHint = bufferFetchSizeHint;
        return this;
    }

    @Override
    public int getBufferFetchSizeHint() {
        return this.bufferFetchSizeHint;
    }

    public Query<T> setDisableReadAuditing() {
        this.disableReadAudit = true;
        return this;
    }

    @Override
    public boolean isDisableReadAudit() {
        return this.disableReadAudit;
    }

    @Override
    public boolean isFutureFetch() {
        return this.futureFetch;
    }

    @Override
    public void setFutureFetch(boolean backgroundFetch) {
        this.futureFetch = backgroundFetch;
    }

    @Override
    public void setFutureFetchAudit(ReadEvent event) {
        this.futureFetchAudit = event;
    }

    @Override
    public ReadEvent getFutureFetchAudit() {
        return this.futureFetchAudit;
    }

    public Query<T> setBaseTable(String baseTable) {
        this.baseTable = baseTable;
        return this;
    }

    @Override
    public String getBaseTable() {
        return this.baseTable;
    }

    public Query<T> alias(String alias) {
        this.rootTableAlias = alias;
        return this;
    }

    @Override
    public String getAlias() {
        return this.rootTableAlias;
    }

    @Override
    public String getAlias(String defaultAlias) {
        return this.rootTableAlias != null ? this.rootTableAlias : defaultAlias;
    }

    public Set<String> validate() {
        return this.server.validateQuery(this);
    }

    @Override
    public Set<String> validate(BeanType<T> desc) {
        SpiExpressionValidation validation = new SpiExpressionValidation(desc);
        if (this.whereExpressions != null) {
            this.whereExpressions.validate(validation);
        }
        if (this.havingExpressions != null) {
            this.havingExpressions.validate(validation);
        }
        if (this.orderBy != null) {
            for (OrderBy.Property property : this.orderBy.getProperties()) {
                validation.validate(property.getProperty());
            }
        }
        return validation.getUnknownProperties();
    }

    void setUpdateProperties(OrmUpdateProperties updateProperties) {
        this.updateProperties = updateProperties;
    }

    @Override
    public OrmUpdateProperties getUpdateProperties() {
        return this.updateProperties;
    }

    @Override
    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    @Override
    public void handleLoadError(String fullName, Exception e) {
        if (!this.allowLoadErrors) {
            throw new PersistenceException("Error loading on " + fullName, (Throwable)e);
        }
    }

    public Query<T> orderById(boolean orderById) {
        this.orderById = orderById;
        return this;
    }
}

