/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.config.DatabaseConfig;
import io.ebean.datasource.DataSourceAlertFactory;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.datasource.DataSourceFactory;
import io.ebean.datasource.DataSourcePoolListener;
import io.ebeaninternal.server.core.JndiDataSourceLookup;
import io.ebeaninternal.server.core.ServiceUtil;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;

final class InitDataSource {
    private final JndiDataSourceLookup jndiDataSourceFactory = new JndiDataSourceLookup();
    private final DatabaseConfig config;

    static void init(DatabaseConfig config) {
        new InitDataSource(config).initialise();
    }

    InitDataSource(DatabaseConfig config) {
        this.config = config;
    }

    private void initialise() {
        if (this.config.getDataSource() == null) {
            this.config.setDataSource(this.initDataSource());
        }
        if (this.config.getReadOnlyDataSource() == null) {
            this.config.setReadOnlyDataSource(this.initReadOnlyDataSource());
        }
    }

    private DataSource initDataSource() {
        String jndiName = this.config.getDataSourceJndiName();
        if (jndiName != null) {
            return this.jndiDataSource(jndiName);
        }
        return this.createFromConfig(this.config.getDataSourceConfig(), false);
    }

    private DataSource jndiDataSource(String jndiName) {
        DataSource ds = this.jndiDataSourceFactory.lookup(jndiName);
        if (ds == null) {
            throw new PersistenceException("JNDI lookup for DataSource " + jndiName + " returned null.");
        }
        return ds;
    }

    private DataSource initReadOnlyDataSource() {
        DataSourceConfig roConfig = this.readOnlyConfig();
        return roConfig == null ? null : this.createFromConfig(roConfig, true);
    }

    DataSourceConfig readOnlyConfig() {
        DataSourceConfig roConfig = this.config.getReadOnlyDataSourceConfig();
        if (roConfig == null) {
            return null;
        }
        if (this.urlSet(roConfig.getUrl())) {
            return roConfig;
        }
        String readOnlyUrl = this.config.getDataSourceConfig().getReadOnlyUrl();
        if (this.urlSet(readOnlyUrl)) {
            roConfig.setUrl(readOnlyUrl);
            return roConfig;
        }
        if (this.config.isAutoReadOnlyDataSource()) {
            roConfig.setUrl(null);
            return roConfig;
        }
        return null;
    }

    private boolean urlSet(String url) {
        return url != null && !"none".equalsIgnoreCase(url) && !url.trim().isEmpty();
    }

    private DataSource createFromConfig(DataSourceConfig dsConfig, boolean readOnly) {
        if (dsConfig == null) {
            throw new PersistenceException("No DataSourceConfig defined for " + this.config.getName());
        }
        if (dsConfig.isOffline() && this.config.getDatabasePlatformName() == null) {
            throw new PersistenceException("You MUST specify a DatabasePlatformName on DatabaseConfig when offline");
        }
        this.attachAlert(dsConfig);
        this.attachListener(dsConfig);
        if (readOnly) {
            dsConfig.setAutoCommit(true);
            dsConfig.setReadOnly(true);
            dsConfig.setDefaults(this.config.getDataSourceConfig());
            dsConfig.setIsolationLevel(this.config.getDataSourceConfig().getIsolationLevel());
        }
        return this.create(dsConfig, readOnly);
    }

    private DataSource create(DataSourceConfig dsConfig, boolean readOnly) {
        String poolName = this.config.getName() + (readOnly ? "-ro" : "");
        return DataSourceFactory.create((String)poolName, (DataSourceConfig)dsConfig);
    }

    private void attachAlert(DataSourceConfig dsConfig) {
        DataSourceAlertFactory alertFactory = ServiceUtil.service(DataSourceAlertFactory.class);
        if (alertFactory != null) {
            dsConfig.setAlert(alertFactory.createAlert());
        }
    }

    private void attachListener(DataSourceConfig dsConfig) {
        String poolListener;
        if (dsConfig.getListener() == null && (poolListener = dsConfig.getPoolListener()) != null) {
            dsConfig.setListener((DataSourcePoolListener)this.config.getClassLoadConfig().newInstance(poolListener));
        }
    }
}

