/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPersistController;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;

final class PersistControllerManager {
    private final List<BeanPersistController> list;

    PersistControllerManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPersistControllers();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addPersistControllers(DeployBeanDescriptor<?> deployDesc) {
        for (BeanPersistController c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            CoreLog.log.debug("BeanPersistController on[{}] {}", (Object)deployDesc.getFullName(), (Object)c.getClass().getName());
            deployDesc.addPersistController(c);
        }
    }
}

