/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.core.BindPadding;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.expression.DefaultExpressionRequest;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.IdInCommon;
import io.ebeaninternal.server.expression.NonPrepareExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class IdInExpression
extends NonPrepareExpression
implements IdInCommon {
    private final List<Object> idCollection;
    private boolean multiValueIdSupported;

    public IdInExpression(Collection<?> idCollection) {
        this.idCollection = new ArrayList(idCollection);
    }

    public Collection<Object> idValues() {
        return this.idCollection;
    }

    @Override
    public int removeIds(Set<Object> hitIds) {
        this.idCollection.removeAll(hitIds);
        return this.idCollection.size();
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.multiValueIdSupported = request.isMultiValueIdSupported();
        if (!this.multiValueIdSupported && !this.idCollection.isEmpty() && request.isPadInExpression()) {
            BindPadding.padIds(this.idCollection);
        }
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeIds(this.idCollection);
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.idCollection.isEmpty()) {
            return;
        }
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        BeanDescriptor<?> descriptor = r.getBeanDescriptor();
        IdBinder idBinder = descriptor.idBinder();
        idBinder.addIdInBindValues(request, this.idCollection);
    }

    public void addSqlNoAlias(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        BeanDescriptor<?> descriptor = r.getBeanDescriptor();
        IdBinder idBinder = descriptor.idBinder();
        if (this.idCollection.isEmpty()) {
            request.append("1=0");
        } else {
            request.append(descriptor.idBinder().getBindIdInSql(null));
            String inClause = idBinder.getIdInValueExpr(false, this.idCollection.size());
            request.append(inClause);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        BeanDescriptor<?> descriptor = request.getBeanDescriptor();
        IdBinder idBinder = descriptor.idBinder();
        if (this.idCollection.isEmpty()) {
            request.append("1=0");
        } else if (idBinder.isComplexId()) {
            request.append(descriptor.idBinderInLHSSql());
            request.append(idBinder.getIdInValueExpr(false, this.idCollection.size()));
        } else {
            request.append(idBinder.getBeanProperty().name());
            request.appendInExpression(false, this.idCollection);
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("IdIn[?");
        if (!this.multiValueIdSupported || this.idCollection.isEmpty()) {
            builder.append(this.idCollection.size());
        }
        builder.append("]");
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.idCollection.size());
        for (Object elem : this.idCollection) {
            key.add(elem);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        IdInExpression that = (IdInExpression)other;
        if (this.idCollection.size() != that.idCollection.size()) {
            return false;
        }
        Iterator<Object> it = that.idCollection.iterator();
        for (Object id1 : this.idCollection) {
            Object id2;
            if (id1.equals(id2 = it.next())) continue;
            return false;
        }
        return true;
    }
}

