/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class SqlTreeProperties {
    private final List<STreeProperty> propsList = new ArrayList<STreeProperty>();
    private final LinkedHashSet<String> propNames = new LinkedHashSet();
    private boolean allProperties;
    private boolean aggregationManyToOne;
    private boolean aggregation;
    private String aggregationPath;

    SqlTreeProperties() {
    }

    boolean containsProperty(String propName) {
        return this.propNames.contains(propName);
    }

    public void add(STreeProperty[] props) {
        this.propsList.addAll(Arrays.asList(props));
    }

    public void addExtra(STreePropertyAssocOne prop) {
        if (!this.propsList.contains(prop)) {
            this.add(prop);
        }
    }

    public void add(STreeProperty prop) {
        this.propsList.add(prop);
        this.propNames.add(prop.name());
        if (prop.isAggregation()) {
            if (!this.aggregation) {
                this.aggregation = true;
                this.aggregationPath = prop.elPrefix();
            }
            if (prop.isAggregationManyToOne()) {
                this.aggregationManyToOne = true;
            }
        }
    }

    public STreeProperty[] getProps() {
        return this.propsList.toArray(new STreeProperty[0]);
    }

    boolean isPartialObject() {
        return !this.allProperties;
    }

    void setAllProperties() {
        this.allProperties = true;
    }

    boolean requireSqlDistinct(ManyWhereJoins manyWhereJoins) {
        String joinProperty = this.aggregationJoin();
        if (joinProperty != null) {
            manyWhereJoins.addAggregationJoin(joinProperty);
            return false;
        }
        return manyWhereJoins.requireSqlDistinct();
    }

    boolean isAggregationManyToOne() {
        return this.aggregationManyToOne;
    }

    public boolean isAggregation() {
        return this.aggregation;
    }

    private String aggregationJoin() {
        return this.aggregationPath;
    }

    boolean isAggregationRoot() {
        return this.aggregation && this.aggregationPath == null;
    }
}

