/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.MutationDetection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.MutableValueInfo;
import io.ebean.bean.MutableValueNext;
import io.ebean.bean.PersistenceContext;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyJsonBasic;
import io.ebeaninternal.server.deploy.BeanPropertyOverride;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.util.Checksum;
import java.sql.SQLException;
import java.util.Objects;
import javax.persistence.PersistenceException;

public final class BeanPropertyJsonMapper
extends BeanPropertyJsonBasic {
    private final boolean sourceDetection;

    public BeanPropertyJsonMapper(BeanDescriptor<?> desc, DeployBeanProperty deployProp) {
        super(desc, deployProp);
        this.sourceDetection = deployProp.getMutationDetection() == MutationDetection.SOURCE;
    }

    private BeanPropertyJsonMapper(BeanPropertyJsonMapper source, BeanPropertyOverride override) {
        super(source, override);
        this.sourceDetection = source.sourceDetection;
    }

    @Override
    public BeanProperty override(BeanPropertyOverride override) {
        return new BeanPropertyJsonMapper(this, override);
    }

    @Override
    public MutableValueInfo createMutableInfo(String json) {
        if (this.sourceDetection) {
            return new SourceMutableValue(this.scalarType, json);
        }
        return new ChecksumMutableValue(this.scalarType, json);
    }

    private MutableValueNext next(String json) {
        if (this.sourceDetection) {
            return new SourceMutableValue(this.scalarType, json);
        }
        return new NextPair(json, new ChecksumMutableValue(this.scalarType, json));
    }

    @Override
    boolean checkMutable(Object value, boolean alreadyDirty, EntityBeanIntercept ebi) {
        String json = this.scalarType.format(value);
        MutableValueInfo oldHash = ebi.mutableInfo(this.propertyIndex);
        if (oldHash == null) {
            if (value == null) {
                return false;
            }
            ebi.mutableNext(this.propertyIndex, this.next(json));
            return true;
        }
        MutableValueNext next = oldHash.nextDirty(json);
        if (next != null) {
            ebi.mutableNext(this.propertyIndex, next);
            return true;
        }
        return false;
    }

    @Override
    public Object readSet(DataReader reader, EntityBean bean) throws SQLException {
        try {
            Object value = this.scalarType.read(reader);
            if (value == null) {
                value = this.checkForEmpty(bean);
            }
            if (bean != null) {
                this.setValue(bean, value);
                String json = reader.popJson();
                if (json != null) {
                    MutableValueInfo hash = this.createMutableInfo(json);
                    bean._ebean_getIntercept().mutableInfo(this.propertyIndex, hash);
                }
            }
            return value;
        }
        catch (TextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException("Error readSet on " + this.descriptor + "." + this.name, (Throwable)e);
        }
    }

    @Override
    public void setCacheDataValue(EntityBean bean, Object cacheData, PersistenceContext context) {
        if (cacheData instanceof String) {
            String jsonContent = (String)cacheData;
            MutableValueInfo hash = this.createMutableInfo(jsonContent);
            bean._ebean_getIntercept().mutableInfo(this.propertyIndex, hash);
            cacheData = this.scalarType.parse(jsonContent);
        }
        this.setValue(bean, cacheData);
    }

    private static final class SourceMutableValue
    implements MutableValueInfo,
    MutableValueNext {
        private final String originalJson;
        private final ScalarType<?> parent;

        SourceMutableValue(ScalarType<?> parent, String json) {
            this.parent = parent;
            this.originalJson = json;
        }

        public MutableValueNext nextDirty(String json) {
            return Objects.equals(this.originalJson, json) ? null : new SourceMutableValue(this.parent, json);
        }

        public boolean isEqualToObject(Object obj) {
            return Objects.equals(this.originalJson, this.parent.format(obj));
        }

        public Object get() {
            return this.parent.parse(this.originalJson);
        }

        public String content() {
            return this.originalJson;
        }

        public MutableValueInfo info() {
            return this;
        }
    }

    private static final class ChecksumMutableValue
    implements MutableValueInfo {
        private final ScalarType<?> parent;
        private final long checksum;

        ChecksumMutableValue(ScalarType<?> parent, String json) {
            this.parent = parent;
            this.checksum = Checksum.checksum(json);
        }

        ChecksumMutableValue(ScalarType<?> parent, long checksum) {
            this.parent = parent;
            this.checksum = checksum;
        }

        public MutableValueNext nextDirty(String json) {
            long nextChecksum = Checksum.checksum(json);
            return nextChecksum == this.checksum ? null : new NextPair(json, new ChecksumMutableValue(this.parent, nextChecksum));
        }

        public boolean isEqualToObject(Object obj) {
            return Checksum.checksum(this.parent.format(obj)) == this.checksum;
        }

        public Object get() {
            return null;
        }
    }

    private static final class NextPair
    implements MutableValueNext {
        private final String json;
        private final MutableValueInfo next;

        NextPair(String json, MutableValueInfo next) {
            this.json = json;
            this.next = next;
        }

        public String content() {
            return this.json;
        }

        public MutableValueInfo info() {
            return this.next;
        }
    }
}

