/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.el;

public final class CharMatch {
    private final char[] upperChars;
    private final int maxLength;

    public CharMatch(String s) {
        this.upperChars = s.toUpperCase().toCharArray();
        this.maxLength = this.upperChars.length;
    }

    public boolean startsWith(String other) {
        if (other == null || other.length() < this.maxLength) {
            return false;
        }
        char[] ta = other.toCharArray();
        int pos = -1;
        while (++pos < this.maxLength) {
            char c1 = this.upperChars[pos];
            char c2 = Character.toUpperCase(ta[pos]);
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String other) {
        if (other == null || other.length() < this.maxLength) {
            return false;
        }
        char[] ta = other.toCharArray();
        int offset = ta.length - this.maxLength;
        int pos = this.maxLength;
        while (--pos >= 0) {
            char c1 = this.upperChars[pos];
            char c2 = Character.toUpperCase(ta[offset + pos]);
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }
}

