/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.text.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.ebean.FetchPath;
import io.ebean.bean.EntityBean;
import io.ebean.config.JsonConfig;
import io.ebean.plugin.BeanType;
import io.ebean.text.json.EJson;
import io.ebean.text.json.JsonIOException;
import io.ebean.text.json.JsonReadOptions;
import io.ebean.text.json.JsonWriteOptions;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiJsonContext;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.text.json.DJsonBeanReader;
import io.ebeaninternal.server.text.json.DJsonScalar;
import io.ebeaninternal.server.text.json.ReadJson;
import io.ebeaninternal.server.text.json.WriteJson;
import io.ebeaninternal.server.type.TypeManager;
import io.ebeaninternal.util.ParamTypeHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DJsonContext
implements SpiJsonContext {
    private static final PrettyPrinter PRETTY_PRINTER = new Pretty();
    private final SpiEbeanServer server;
    private final JsonFactory jsonFactory;
    private final Object defaultObjectMapper;
    private final JsonConfig.Include defaultInclude;
    private final DJsonScalar jsonScalar;

    public DJsonContext(SpiEbeanServer server, JsonFactory jsonFactory, TypeManager typeManager) {
        this.server = server;
        this.jsonFactory = jsonFactory != null ? jsonFactory : new JsonFactory();
        this.defaultObjectMapper = this.server.config().getObjectMapper();
        this.defaultInclude = this.server.config().getJsonInclude();
        this.jsonScalar = new DJsonScalar(typeManager);
    }

    public void writeScalar(JsonGenerator generator, Object scalarValue) throws IOException {
        this.jsonScalar.write(generator, scalarValue);
    }

    public boolean isSupportedType(Type genericType) {
        return this.server.isSupportedType(genericType);
    }

    public JsonGenerator createGenerator(Writer writer) throws JsonIOException {
        try {
            return this.jsonFactory.createGenerator(writer);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public JsonParser createParser(Reader reader) throws JsonIOException {
        try {
            return this.jsonFactory.createParser(reader);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public <T> T toBean(Class<T> cls, String json) throws JsonIOException {
        return this.toBean(cls, (Reader)new StringReader(json));
    }

    public <T> T toBean(Class<T> cls, String json, JsonReadOptions options) throws JsonIOException {
        return this.toBean(cls, (Reader)new StringReader(json), options);
    }

    public <T> T toBean(Class<T> cls, Reader jsonReader) throws JsonIOException {
        return this.toBean(cls, this.createParser(jsonReader));
    }

    public <T> T toBean(Class<T> cls, Reader jsonReader, JsonReadOptions options) throws JsonIOException {
        return this.toBean(cls, this.createParser(jsonReader), options);
    }

    public <T> T toBean(Class<T> cls, JsonParser parser) throws JsonIOException {
        return this.toBean(cls, parser, (JsonReadOptions)null);
    }

    public <T> T toBean(Class<T> cls, JsonParser parser, JsonReadOptions options) throws JsonIOException {
        BeanDescriptor<Object> desc = this.getDescriptor(cls);
        try {
            return desc.jsonRead(new ReadJson(desc, parser, options, this.determineObjectMapper(options)), null, null);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public <T> void toBean(T target, String json) throws JsonIOException {
        this.toBean(target, (Reader)new StringReader(json));
    }

    public <T> void toBean(T target, String json, JsonReadOptions options) throws JsonIOException {
        this.toBean(target, (Reader)new StringReader(json), options);
    }

    public <T> void toBean(T target, Reader jsonReader) throws JsonIOException {
        this.toBean(target, this.createParser(jsonReader));
    }

    public <T> void toBean(T target, Reader jsonReader, JsonReadOptions options) throws JsonIOException {
        this.toBean(target, this.createParser(jsonReader), options);
    }

    public <T> void toBean(T target, JsonParser parser) throws JsonIOException {
        this.toBean(target, parser, null);
    }

    public <T> void toBean(T target, JsonParser parser, JsonReadOptions options) throws JsonIOException {
        BeanDescriptor<?> desc = this.getDescriptor(target.getClass());
        try {
            desc.jsonRead(new ReadJson(desc, parser, options, this.determineObjectMapper(options)), null, target);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public <T> DJsonBeanReader<T> createBeanReader(Class<T> cls, JsonParser parser, JsonReadOptions options) throws JsonIOException {
        BeanDescriptor<T> desc = this.getDescriptor(cls);
        return new DJsonBeanReader<T>(desc, new ReadJson(desc, parser, options, this.determineObjectMapper(options)));
    }

    public <T> DJsonBeanReader<T> createBeanReader(BeanType<T> beanType, JsonParser parser, JsonReadOptions options) throws JsonIOException {
        BeanDescriptor desc = (BeanDescriptor)beanType;
        ReadJson readJson = new ReadJson(desc, parser, options, this.determineObjectMapper(options));
        return new DJsonBeanReader(desc, readJson);
    }

    public <T> List<T> toList(Class<T> cls, String json) throws JsonIOException {
        return this.toList(cls, new StringReader(json));
    }

    public <T> List<T> toList(Class<T> cls, String json, JsonReadOptions options) throws JsonIOException {
        return this.toList(cls, new StringReader(json), options);
    }

    public <T> List<T> toList(Class<T> cls, Reader jsonReader) throws JsonIOException {
        return this.toList(cls, this.createParser(jsonReader));
    }

    public <T> List<T> toList(Class<T> cls, Reader jsonReader, JsonReadOptions options) throws JsonIOException {
        return this.toList(cls, this.createParser(jsonReader), options);
    }

    public <T> List<T> toList(Class<T> cls, JsonParser src) throws JsonIOException {
        return this.toList(cls, src, null);
    }

    public <T> List<T> toList(Class<T> cls, JsonParser src, JsonReadOptions options) throws JsonIOException {
        BeanDescriptor<Object> desc = this.getDescriptor(cls);
        ReadJson readJson = new ReadJson(desc, src, options, this.determineObjectMapper(options));
        try {
            Object bean;
            JsonToken event;
            JsonToken currentToken = src.getCurrentToken();
            if (currentToken != JsonToken.START_ARRAY && (event = src.nextToken()) != JsonToken.START_ARRAY) {
                throw new JsonParseException(src, "Expecting start_array event but got " + event);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            while ((bean = desc.jsonRead(readJson, null, null)) != null) {
                list.add(bean);
            }
            return list;
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public Object toObject(Type genericType, String json) throws JsonIOException {
        return this.toObject(genericType, this.createParser(new StringReader(json)));
    }

    public Object toObject(Type genericType, Reader json) throws JsonIOException {
        return this.toObject(genericType, this.createParser(json));
    }

    public Object toObject(Type genericType, JsonParser jsonParser) throws JsonIOException {
        ParamTypeHelper.TypeInfo info = ParamTypeHelper.getTypeInfo(genericType);
        ParamTypeHelper.ManyType manyType = info.getManyType();
        switch (manyType) {
            case NONE: {
                return this.toBean(info.getBeanType(), jsonParser);
            }
            case LIST: {
                return this.toList(info.getBeanType(), jsonParser);
            }
        }
        throw new JsonIOException("Type " + (Object)((Object)manyType) + " not supported");
    }

    public void toJson(Object value, JsonGenerator generator) throws JsonIOException {
        this.toJsonNoClose(value, generator, null);
    }

    public void toJson(Object value, JsonGenerator generator, FetchPath fetchPath) throws JsonIOException {
        this.toJsonNoClose(value, generator, JsonWriteOptions.pathProperties((FetchPath)fetchPath));
    }

    public void toJson(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        this.toJsonNoClose(o, generator, options);
    }

    public void toJson(Object o, Writer writer) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), null);
    }

    public String toJson(Object value, FetchPath fetchPath) throws JsonIOException {
        return this.toJson(value, JsonWriteOptions.pathProperties((FetchPath)fetchPath));
    }

    public void toJson(Object o, Writer writer, FetchPath fetchPath) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), JsonWriteOptions.pathProperties((FetchPath)fetchPath));
    }

    public void toJson(Object o, Writer writer, JsonWriteOptions options) throws JsonIOException {
        this.toJsonWithClose(o, this.createGenerator(writer), options);
    }

    private void toJsonWithClose(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        try {
            this.toJsonInternal(o, generator, options);
            generator.close();
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private void toJsonNoClose(Object o, JsonGenerator generator, JsonWriteOptions options) throws JsonIOException {
        try {
            this.toJsonInternal(o, generator, options);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public String toJsonPretty(Object value) throws JsonIOException {
        return this.toJsonString(value, null, true);
    }

    public String toJson(Object o) throws JsonIOException {
        return this.toJsonString(o, null, false);
    }

    public String toJson(Object o, JsonWriteOptions options) throws JsonIOException {
        return this.toJsonString(o, options, false);
    }

    private String toJsonString(Object value, JsonWriteOptions options, boolean pretty) throws JsonIOException {
        StringWriter writer = new StringWriter(500);
        try (JsonGenerator gen = this.createGenerator(writer);){
            if (pretty) {
                gen.setPrettyPrinter(PRETTY_PRINTER);
            }
            this.toJsonInternal(value, gen, options);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        return writer.toString();
    }

    private void toJsonInternal(Object value, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else if (value instanceof Number) {
            gen.writeNumber(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            gen.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            gen.writeString((String)value);
        } else if (value instanceof Map) {
            this.toJsonFromMap((Map)value, gen, options);
        } else if (value instanceof Collection) {
            this.toJsonFromCollection((Collection)value, null, gen, options);
        } else if (value instanceof EntityBean) {
            BeanDescriptor<?> d = this.getDescriptor(value.getClass());
            WriteJson writeJson = this.createWriteJson(gen, options);
            d.jsonWrite(writeJson, (EntityBean)value, null);
        } else {
            this.jsonScalar.write(gen, value);
        }
    }

    @Override
    public SpiJsonReader createJsonRead(BeanType<?> beanType, String json) {
        BeanDescriptor desc = (BeanDescriptor)beanType;
        JsonParser parser = this.createParser(new StringReader(json));
        return new ReadJson(desc, parser, null, this.defaultObjectMapper);
    }

    @Override
    public SpiJsonWriter createJsonWriter(Writer writer) {
        return this.createJsonWriter(this.createGenerator(writer), null);
    }

    @Override
    public SpiJsonWriter createJsonWriter(JsonGenerator gen, JsonWriteOptions options) {
        return this.createWriteJson(gen, options);
    }

    private WriteJson createWriteJson(JsonGenerator gen, JsonWriteOptions options) {
        FetchPath pathProps = options == null ? null : options.getPathProperties();
        Map visitors = options == null ? null : options.getVisitorMap();
        return new WriteJson(this.server, gen, pathProps, visitors, this.determineObjectMapper(options), this.determineInclude(options));
    }

    private <T> void toJsonFromCollection(Collection<T> collection, String key, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        if (key != null) {
            gen.writeFieldName(key);
        }
        gen.writeStartArray();
        WriteJson writeJson = this.createWriteJson(gen, options);
        for (T bean : collection) {
            BeanDescriptor<?> d = this.getDescriptor(bean.getClass());
            d.jsonWrite(writeJson, (EntityBean)bean, null);
        }
        gen.writeEndArray();
    }

    private void toJsonFromMap(Map<Object, Object> map, JsonGenerator gen, JsonWriteOptions options) throws IOException {
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        Iterator<Map.Entry<Object, Object>> it = entrySet.iterator();
        WriteJson writeJson = this.createWriteJson(gen, options);
        gen.writeStartObject();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) {
                gen.writeNullField(key);
                continue;
            }
            if (value instanceof Collection) {
                this.toJsonFromCollection((Collection)value, key, gen, options);
                continue;
            }
            if (value instanceof EntityBean) {
                BeanDescriptor<?> d = this.getDescriptor(value.getClass());
                d.jsonWrite(writeJson, (EntityBean)value, key);
                continue;
            }
            EJson.write(entry, (JsonGenerator)gen);
        }
        gen.writeEndObject();
    }

    private <T> BeanDescriptor<T> getDescriptor(Class<T> beanType) {
        BeanDescriptor<T> d = this.server.descriptor(beanType);
        if (d == null) {
            throw new RuntimeException("No BeanDescriptor found for " + beanType);
        }
        return d;
    }

    private Object determineObjectMapper(JsonReadOptions options) {
        if (options == null) {
            return this.defaultObjectMapper;
        }
        Object mapper = options.getObjectMapper();
        return mapper != null ? mapper : this.defaultObjectMapper;
    }

    private Object determineObjectMapper(JsonWriteOptions options) {
        if (options == null) {
            return this.defaultObjectMapper;
        }
        Object mapper = options.getObjectMapper();
        return mapper != null ? mapper : this.defaultObjectMapper;
    }

    private JsonConfig.Include determineInclude(JsonWriteOptions options) {
        if (options == null) {
            return this.defaultInclude;
        }
        JsonConfig.Include include = options.getInclude();
        return include != null ? include : this.defaultInclude;
    }

    private static class Pretty
    extends DefaultPrettyPrinter {
        Pretty() {
            this._objectFieldValueSeparatorWithSpaces = ": ";
        }
    }
}

