/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.event.BulkTableEvent;
import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.BinaryWritable;
import io.ebeaninternal.api.BinaryWriteContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class TransactionEventTable
implements Serializable,
BinaryWritable {
    private static final long serialVersionUID = 2236555729767483264L;
    private final Map<String, TableIUD> map = new HashMap<String, TableIUD>();

    public String toString() {
        return "TransactionEventTable " + this.map.values();
    }

    @Override
    public void writeBinary(BinaryWriteContext out) throws IOException {
        for (TableIUD tableIud : this.map.values()) {
            tableIud.writeBinary(out);
        }
    }

    public void add(TransactionEventTable table) {
        for (TableIUD iud : table.values()) {
            this.add(iud);
        }
    }

    public void add(String table, boolean insert, boolean update, boolean delete) {
        table = table.toUpperCase();
        this.add(new TableIUD(table, insert, update, delete));
    }

    public void add(TableIUD newTableIUD) {
        TableIUD existingTableIUD = this.map.put(newTableIUD.getTableName(), newTableIUD);
        if (existingTableIUD != null) {
            newTableIUD.add(existingTableIUD);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection<TableIUD> values() {
        return this.map.values();
    }

    public static class TableIUD
    implements Serializable,
    BulkTableEvent,
    BinaryWritable {
        private static final long serialVersionUID = -1958317571064162089L;
        private final String table;
        private boolean insert;
        private boolean update;
        private boolean delete;

        public TableIUD(String table, boolean insert, boolean update, boolean delete) {
            this.table = table;
            this.insert = insert;
            this.update = update;
            this.delete = delete;
        }

        public static TableIUD readBinaryMessage(BinaryReadContext dataInput) throws IOException {
            String table = dataInput.readUTF();
            boolean insert = dataInput.readBoolean();
            boolean update = dataInput.readBoolean();
            boolean delete = dataInput.readBoolean();
            return new TableIUD(table, insert, update, delete);
        }

        @Override
        public void writeBinary(BinaryWriteContext out) throws IOException {
            DataOutputStream os = out.start(2);
            os.writeUTF(this.table);
            os.writeBoolean(this.insert);
            os.writeBoolean(this.update);
            os.writeBoolean(this.delete);
        }

        public String toString() {
            return "TableIUD " + this.table + " i:" + this.insert + " u:" + this.update + " d:" + this.delete;
        }

        private void add(TableIUD other) {
            if (other.insert) {
                this.insert = true;
            }
            if (other.update) {
                this.update = true;
            }
            if (other.delete) {
                this.delete = true;
            }
        }

        public String getTableName() {
            return this.table;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isDelete() {
            return this.delete;
        }

        public boolean isUpdateOrDelete() {
            return this.update || this.delete;
        }
    }
}

