/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.json;

import io.ebeaninternal.json.ModifyAwareFlag;
import io.ebeaninternal.json.ModifyAwareOwner;
import io.ebeaninternal.json.ModifyAwareSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModifyAwareMap<K, V>
implements Map<K, V>,
ModifyAwareOwner {
    private static final long serialVersionUID = 1L;
    final ModifyAwareOwner owner;
    final Map<K, V> map;

    public ModifyAwareMap(Map<K, V> underlying) {
        this.map = underlying;
        this.owner = new ModifyAwareFlag();
    }

    public ModifyAwareMap(ModifyAwareOwner owner, Map<K, V> underlying) {
        this.owner = owner;
        this.map = underlying;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModifyAwareMap) {
            ModifyAwareMap that = (ModifyAwareMap)o;
            return Objects.equals(this.map, that.map);
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return Objects.equals(this.map, that);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isMarkedDirty() {
        return this.owner.isMarkedDirty();
    }

    @Override
    public void markAsModified() {
        this.owner.markAsModified();
    }

    @Override
    public void resetMarkedDirty() {
        this.owner.resetMarkedDirty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.markAsModified();
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = this.map.remove(key);
        if (value != null) {
            this.markAsModified();
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.markAsModified();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        if (!this.map.isEmpty()) {
            this.markAsModified();
        }
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return new ModifyAwareSet<K>(this, this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return new ModifyAwareSet<V>(this, new LinkedHashSet<V>(this.map.values()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ModifyAwareSet<Map.Entry<K, V>>(this, this.map.entrySet());
    }
}

