/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.EbeanServer;
import io.ebean.Transaction;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlBinding;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.lib.Str;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.TrimLogSql;
import io.ebeaninternal.server.util.BindParamsParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractSqlQueryRequest {
    protected final SpiSqlBinding query;
    protected final SpiEbeanServer server;
    protected SpiTransaction trans;
    private boolean createdTransaction;
    protected String sql;
    protected ResultSet resultSet;
    protected String bindLog = "";
    protected PreparedStatement pstmt;
    protected long startNano;

    AbstractSqlQueryRequest(SpiEbeanServer server, SpiSqlBinding query, Transaction t) {
        this.server = server;
        this.query = query;
        this.trans = (SpiTransaction)t;
    }

    public void initTransIfRequired() {
        if (this.trans == null) {
            this.trans = this.server.currentServerTransaction();
            if (this.trans == null || !this.trans.isActive()) {
                this.trans = this.server.createReadOnlyTransaction(null);
                this.createdTransaction = true;
            }
        }
    }

    public void endTransIfRequired() {
        if (this.createdTransaction) {
            this.trans.commit();
        }
    }

    public EbeanServer getServer() {
        return this.server;
    }

    public SpiTransaction getTransaction() {
        return this.trans;
    }

    public boolean isLogSql() {
        return this.trans.isLogSql();
    }

    abstract void setResultSet(ResultSet var1, Object var2) throws SQLException;

    public String getBindLog() {
        return this.bindLog;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    protected abstract void requestComplete();

    public void close() {
        this.requestComplete();
        JdbcClose.close((ResultSet)this.resultSet);
        JdbcClose.close((Statement)this.pstmt);
    }

    private void prepareSql() {
        String sql = this.query.getQuery();
        BindParams bindParams = this.query.getBindParams();
        if (!bindParams.isEmpty()) {
            sql = BindParamsParser.parse(bindParams, sql);
        }
        this.sql = this.limitOffset(sql);
    }

    private String limitOffset(String sql) {
        int firstRow = this.query.getFirstRow();
        int maxRows = this.query.getMaxRows();
        if (firstRow > 0 || maxRows > 0) {
            return this.server.getDatabasePlatform().getBasicSqlLimiter().limit(sql, firstRow, maxRows);
        }
        return sql;
    }

    public void executeSql(Binder binder, SpiQuery.Type type) throws SQLException {
        this.startNano = System.nanoTime();
        this.executeAsSql(binder);
    }

    protected void executeAsSql(Binder binder) throws SQLException {
        BindParams bindParams;
        this.prepareSql();
        Connection conn = this.trans.getInternalConnection();
        this.pstmt = conn.prepareStatement(this.sql);
        if (this.query.getTimeout() > 0) {
            this.pstmt.setQueryTimeout(this.query.getTimeout());
        }
        if (this.query.getBufferFetchSizeHint() > 0) {
            this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
        }
        if (!(bindParams = this.query.getBindParams()).isEmpty()) {
            this.bindLog = binder.bind(bindParams, this.pstmt, conn);
        }
        if (this.isLogSql()) {
            this.trans.logSql(Str.add(TrimLogSql.trim(this.sql), "; --bind(", this.bindLog, ")"));
        }
        this.setResultSet(this.pstmt.executeQuery(), null);
    }

    public String getSql() {
        return this.sql;
    }
}

