/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.bean.EntityBean;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.type.DataReader;
import java.sql.SQLException;

abstract class AssocOneHelp {
    final BeanPropertyAssocOne<?> property;
    private final BeanDescriptor<?> target;
    private final String path;

    AssocOneHelp(BeanPropertyAssocOne<?> property) {
        this(property, null);
    }

    AssocOneHelp(BeanPropertyAssocOne<?> property, String embeddedPrefix) {
        this.property = property;
        this.target = property.targetDescriptor;
        this.path = embeddedPrefix == null ? property.name : embeddedPrefix + "." + property.name;
    }

    void loadIgnore(DbReadContext ctx) {
        this.property.targetIdBinder.loadIgnore(ctx);
    }

    Object read(DataReader reader) throws SQLException {
        return this.property.read(reader);
    }

    Object readSet(DataReader reader, EntityBean bean) throws SQLException {
        Object val = this.read(reader);
        if (bean != null) {
            this.property.setValue(bean, val);
        }
        return val;
    }

    Object read(DbReadContext ctx) throws SQLException {
        Object id = this.property.targetIdBinder.read(ctx);
        if (id == null) {
            return null;
        }
        PersistenceContext pc = ctx.getPersistenceContext();
        Object existing = this.target.contextGet(pc, id);
        if (existing != null) {
            return existing;
        }
        boolean disableLazyLoading = ctx.isDisableLazyLoading();
        Object ref = this.target.contextRef(pc, ctx.isReadOnly(), disableLazyLoading, id);
        if (!disableLazyLoading) {
            ctx.register(this.path, ((EntityBean)ref)._ebean_getIntercept());
        }
        return ref;
    }

    Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        Object val = this.read(ctx);
        if (bean != null) {
            this.property.setValue(bean, val);
            ctx.propagateState(val);
        }
        return val;
    }

    abstract void appendSelect(DbSqlContext var1, boolean var2);

    void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
    }
}

