/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.PersistenceIOException;
import io.ebean.bean.BeanDiffVisitor;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.util.ArrayStack;
import java.io.IOException;
import java.io.StringWriter;

class BeanChangeJson
implements BeanDiffVisitor {
    private final StringWriter newData;
    private final StringWriter oldData;
    private final SpiJsonWriter newJson;
    private final SpiJsonWriter oldJson;
    private final ArrayStack<BeanDescriptor<?>> stack = new ArrayStack();
    private BeanDescriptor<?> descriptor;

    BeanChangeJson(BeanDescriptor<?> descriptor, boolean statelessUpdate) {
        this.descriptor = descriptor;
        this.newData = new StringWriter(200);
        this.newJson = descriptor.createJsonWriter(this.newData);
        this.newJson.writeStartObject();
        if (statelessUpdate) {
            this.oldJson = null;
            this.oldData = null;
        } else {
            this.oldData = new StringWriter(200);
            this.oldJson = descriptor.createJsonWriter(this.oldData);
            this.oldJson.writeStartObject();
        }
    }

    public void visit(int position, Object newVal, Object oldVal) {
        try {
            BeanProperty prop = this.descriptor.propertiesIndex[position];
            if (prop.isDbUpdatable()) {
                prop.jsonWriteValue(this.newJson, newVal);
                if (this.oldJson != null) {
                    prop.jsonWriteValue(this.oldJson, oldVal);
                }
            }
        }
        catch (IOException e) {
            throw new PersistenceIOException((Exception)e);
        }
    }

    public void visitPush(int position) {
        this.stack.push(this.descriptor);
        BeanPropertyAssocOne embedded = (BeanPropertyAssocOne)this.descriptor.propertiesIndex[position];
        this.descriptor = embedded.getTargetDescriptor();
        this.newJson.writeStartObject(embedded.getName());
        if (this.oldJson != null) {
            this.oldJson.writeStartObject(embedded.getName());
        }
    }

    public void visitPop() {
        this.newJson.writeEndObject();
        if (this.oldJson != null) {
            this.oldJson.writeEndObject();
        }
        this.descriptor = this.stack.pop();
    }

    void flush() {
        try {
            this.newJson.writeEndObject();
            this.newJson.flush();
            if (this.oldJson != null) {
                this.oldJson.writeEndObject();
                this.oldJson.flush();
            }
        }
        catch (IOException e) {
            throw new PersistenceIOException((Exception)e);
        }
    }

    String newJson() {
        return this.newData.toString();
    }

    String oldJson() {
        return this.oldData == null ? null : this.oldData.toString();
    }
}

