/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import java.util.ArrayList;

final class BeanDescriptorDraftHelp<T> {
    private final BeanDescriptor<T> desc;
    private final BeanProperty draftDirty;
    private final BeanProperty[] resetProperties;

    BeanDescriptorDraftHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.draftDirty = desc.getDraftDirty();
        this.resetProperties = this.resetProperties();
    }

    private BeanProperty[] resetProperties() {
        BeanProperty[] props;
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (BeanProperty prop : props = this.desc.propertiesNonMany()) {
            if (!prop.isDraftReset()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanProperty[0]);
    }

    boolean draftReset(T draftBean) {
        EntityBean draftEntityBean = (EntityBean)draftBean;
        if (this.draftDirty != null) {
            this.draftDirty.setValueIntercept(draftEntityBean, false);
        }
        for (BeanProperty resetProperty : this.resetProperties) {
            resetProperty.setValueIntercept(draftEntityBean, null);
        }
        return draftEntityBean._ebean_getIntercept().isDirty();
    }

    public T publish(T draftBean, T liveBean) {
        BeanPropertyAssocMany<?>[] many;
        BeanProperty[] props;
        if (liveBean == null) {
            liveBean = this.desc.createEntityBean();
        }
        EntityBean draft = (EntityBean)draftBean;
        EntityBean live = (EntityBean)liveBean;
        BeanProperty idProperty = this.desc.getIdProperty();
        if (idProperty != null) {
            idProperty.publish(draft, live);
        }
        for (BeanProperty prop : props = this.desc.propertiesNonMany()) {
            prop.publish(draft, live);
        }
        for (BeanPropertyAssocMany<?> aMany : many = this.desc.propertiesMany()) {
            if (!aMany.getTargetDescriptor().isDraftable()) continue;
            aMany.publishMany(draft, live);
        }
        return liveBean;
    }

    void draftQueryOptimise(Query<T> query) {
        BeanPropertyAssocMany<?>[] many;
        BeanPropertyAssocOne<?>[] one;
        for (BeanPropertyAssocOne<?> anOne : one = this.desc.propertiesOne()) {
            if (!anOne.getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(anOne.getName());
        }
        for (BeanPropertyAssocMany<?> aMany : many = this.desc.propertiesMany()) {
            if (!aMany.getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(aMany.getName());
        }
    }
}

