/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.PostSoftDelete;
import io.ebean.annotation.PreSoftDelete;
import io.ebean.config.DatabaseConfig;
import io.ebean.event.BeanPersistAdapter;
import io.ebean.event.BeanPersistController;
import io.ebean.event.BeanPersistRequest;
import io.ebean.event.BeanPostConstructListener;
import io.ebean.event.BeanPostLoad;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;

class BeanLifecycleAdapterFactory {
    private final boolean postConstructPresent;

    BeanLifecycleAdapterFactory(DatabaseConfig config) {
        this.postConstructPresent = config.getClassLoadConfig().isJavaxPostConstructPresent();
    }

    void addLifecycleMethods(DeployBeanDescriptor<?> deployDesc) {
        Method[] methods = deployDesc.getBeanType().getMethods();
        MethodsHolder methodHolder = new MethodsHolder();
        for (Method m : methods) {
            methodHolder.checkMethod(m, this.postConstructPresent);
        }
        if (methodHolder.hasPersistMethods()) {
            deployDesc.addPersistController((BeanPersistController)new PersistAdapter(new PersistMethodsHolder(methodHolder)));
        }
        if (!methodHolder.postLoads.isEmpty()) {
            deployDesc.addPostLoad(new PostLoadAdapter(methodHolder.postLoads));
        }
        if (!methodHolder.postConstructs.isEmpty()) {
            deployDesc.addPostConstructListener(new PostConstructAdapter(methodHolder.postConstructs));
        }
    }

    private static Method[] toArray(List<Method> methodList) {
        return methodList.toArray(new Method[0]);
    }

    private static RuntimeException unwrapException(ReflectiveOperationException e) {
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            if (targetException instanceof RuntimeException) {
                return (RuntimeException)targetException;
            }
            return new PersistenceException("Error invoking lifecycle method", targetException);
        }
        return new PersistenceException("Error invoking lifecycle method", (Throwable)e);
    }

    private static class PostConstructAdapter
    implements BeanPostConstructListener {
        private final Method[] postConstructMethods;

        private PostConstructAdapter(List<Method> postConstructMethods) {
            this.postConstructMethods = BeanLifecycleAdapterFactory.toArray(postConstructMethods);
        }

        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw BeanLifecycleAdapterFactory.unwrapException(e);
            }
        }

        public void postConstruct(Object bean) {
            for (Method postConstructMethod : this.postConstructMethods) {
                this.invoke(postConstructMethod, bean);
            }
        }

        public void autowire(Object bean) {
        }

        public void postCreate(Object bean) {
        }
    }

    private static class PostLoadAdapter
    implements BeanPostLoad {
        private final Method[] postLoadMethods;

        private PostLoadAdapter(List<Method> postLoadMethods) {
            this.postLoadMethods = BeanLifecycleAdapterFactory.toArray(postLoadMethods);
        }

        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw BeanLifecycleAdapterFactory.unwrapException(e);
            }
        }

        public void postLoad(Object bean) {
            for (Method postLoadMethod : this.postLoadMethods) {
                this.invoke(postLoadMethod, bean);
            }
        }
    }

    private static class PersistAdapter
    extends BeanPersistAdapter {
        private final PersistMethodsHolder methodHolder;

        private PersistAdapter(PersistMethodsHolder methodHolder) {
            this.methodHolder = methodHolder;
        }

        public boolean isRegisterFor(Class<?> cls) {
            return false;
        }

        private void invoke(Method method, Object bean) {
            try {
                method.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw BeanLifecycleAdapterFactory.unwrapException(e);
            }
        }

        private void invoke(Method[] methods, BeanPersistRequest<?> request) {
            for (Method method : methods) {
                this.invoke(method, request.getBean());
            }
        }

        public boolean preDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preDeletes, request);
            return true;
        }

        public boolean preSoftDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preSoftDeletes, request);
            return true;
        }

        public boolean preInsert(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preInserts, request);
            return true;
        }

        public boolean preUpdate(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.preUpdates, request);
            return true;
        }

        public void postDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postDeletes, request);
        }

        public void postSoftDelete(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postSoftDeletes, request);
        }

        public void postInsert(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postInserts, request);
        }

        public void postUpdate(BeanPersistRequest<?> request) {
            this.invoke(this.methodHolder.postUpdates, request);
        }
    }

    private static class PersistMethodsHolder {
        private final Method[] preInserts;
        private final Method[] postInserts;
        private final Method[] preUpdates;
        private final Method[] postUpdates;
        private final Method[] preDeletes;
        private final Method[] postDeletes;
        private final Method[] preSoftDeletes;
        private final Method[] postSoftDeletes;

        PersistMethodsHolder(MethodsHolder methodsHolder) {
            this.preInserts = BeanLifecycleAdapterFactory.toArray(methodsHolder.preInserts);
            this.preUpdates = BeanLifecycleAdapterFactory.toArray(methodsHolder.preUpdates);
            this.preDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.preDeletes);
            this.preSoftDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.preSoftDeletes);
            this.postInserts = BeanLifecycleAdapterFactory.toArray(methodsHolder.postInserts);
            this.postUpdates = BeanLifecycleAdapterFactory.toArray(methodsHolder.postUpdates);
            this.postDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.postDeletes);
            this.postSoftDeletes = BeanLifecycleAdapterFactory.toArray(methodsHolder.postSoftDeletes);
        }
    }

    private static class MethodsHolder {
        private boolean hasPersistMethods;
        private final List<Method> preInserts = new ArrayList<Method>();
        private final List<Method> postInserts = new ArrayList<Method>();
        private final List<Method> preUpdates = new ArrayList<Method>();
        private final List<Method> postUpdates = new ArrayList<Method>();
        private final List<Method> preDeletes = new ArrayList<Method>();
        private final List<Method> postDeletes = new ArrayList<Method>();
        private final List<Method> preSoftDeletes = new ArrayList<Method>();
        private final List<Method> postSoftDeletes = new ArrayList<Method>();
        private final List<Method> postLoads = new ArrayList<Method>();
        private final List<Method> postConstructs = new ArrayList<Method>();

        private MethodsHolder() {
        }

        private boolean hasPersistMethods() {
            return this.hasPersistMethods;
        }

        private void checkMethod(Method method, boolean postConstructPresent) {
            if (method.isAnnotationPresent(PrePersist.class)) {
                this.preInserts.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostPersist.class)) {
                this.postInserts.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PreUpdate.class)) {
                this.preUpdates.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostUpdate.class)) {
                this.postUpdates.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PreRemove.class)) {
                this.preDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostRemove.class)) {
                this.postDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PreSoftDelete.class)) {
                this.preSoftDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostSoftDelete.class)) {
                this.postSoftDeletes.add(method);
                this.hasPersistMethods = true;
            }
            if (method.isAnnotationPresent(PostLoad.class)) {
                this.postLoads.add(method);
            }
            if (postConstructPresent && method.isAnnotationPresent(PostConstruct.class)) {
                this.postConstructs.add(method);
            }
        }
    }
}

