/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.DocCode;
import io.ebean.annotation.DocProperty;
import io.ebean.annotation.DocSortable;
import io.ebeanservice.docstore.api.mapping.DocPropertyOptions;

public class DeployDocPropertyOptions {
    private static final DocPropertyOptions EMPTY = new DocPropertyOptions();
    private DocPropertyOptions mapping;

    private void createOptions() {
        if (this.mapping == null) {
            this.mapping = new DocPropertyOptions();
        }
    }

    public void setDocProperty(DocProperty doc) {
        this.createOptions();
        this.mapping.apply(doc);
    }

    public void setDocSortable(DocSortable doc) {
        this.createOptions();
        this.mapping.setSortable(true);
        this.setStore(doc.store());
        this.setBoost(doc.boost());
        this.setNullValue(doc.nullValue());
    }

    public void setDocCode(DocCode doc) {
        this.createOptions();
        this.mapping.setCode(true);
        this.setStore(doc.store());
        this.setBoost(doc.boost());
        this.setNullValue(doc.nullValue());
    }

    private void setNullValue(String value) {
        if (!value.isEmpty()) {
            this.mapping.setNullValue(value);
        }
    }

    private void setBoost(float boost) {
        if (Float.compare(boost, 1.0f) != 0) {
            this.mapping.setBoost(Float.valueOf(boost));
        }
    }

    private void setStore(boolean store) {
        if (store) {
            this.mapping.setStore(true);
        }
    }

    public DocPropertyOptions create() {
        return this.mapping == null ? EMPTY : this.mapping;
    }
}

