/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import java.util.HashSet;
import java.util.Set;

public final class DeployPropertyParser
extends DeployParser {
    private static final String JOIN = "join";
    private static final String FROM = "from";
    private final BeanDescriptor<?> beanDescriptor;
    private final Set<String> includes = new HashSet<String>();
    private boolean catchFirst;
    private ElPropertyDeploy firstProp;

    DeployPropertyParser(BeanDescriptor<?> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    public DeployPropertyParser setCatchFirst(boolean catchFirst) {
        this.catchFirst = catchFirst;
        return this;
    }

    public ElPropertyDeploy getFirstProp() {
        return this.firstProp;
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    protected boolean skipWordConvert() {
        return FROM.equalsIgnoreCase(this.priorWord) || JOIN.equalsIgnoreCase(this.priorWord);
    }

    @Override
    public String getDeployWord(String expression) {
        ElPropertyDeploy elProp = this.beanDescriptor.getElPropertyDeploy(expression);
        if (elProp == null) {
            return null;
        }
        if (this.catchFirst && this.firstProp == null) {
            this.firstProp = elProp;
        }
        this.addIncludes(elProp.getElPrefix());
        return elProp.getElPlaceholder(this.encrypted);
    }

    @Override
    public String convertWord() {
        String r = this.getDeployWord(this.word);
        return r == null ? this.word : r;
    }

    private void addIncludes(String prefix) {
        if (prefix != null) {
            this.includes.add(prefix);
        }
    }
}

