/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPostLoad;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PostLoadManager {
    private static final Logger logger = LoggerFactory.getLogger(PostLoadManager.class);
    private final List<BeanPostLoad> list;

    PostLoadManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPostLoaders();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addPostLoad(DeployBeanDescriptor<?> deployDesc) {
        for (BeanPostLoad c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            logger.debug("BeanPostLoad on[{}] {}", (Object)deployDesc.getFullName(), (Object)c.getClass().getName());
            deployDesc.addPostLoad(c);
        }
    }
}

