/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.ExampleExpression;
import io.ebean.LikeType;
import io.ebean.bean.EntityBean;
import io.ebean.event.BeanQueryRequest;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.LikeExpression;
import io.ebeaninternal.server.expression.Op;
import io.ebeaninternal.server.expression.SimpleExpression;
import java.io.IOException;
import java.util.ArrayList;

public class DefaultExampleExpression
implements SpiExpression,
ExampleExpression {
    private final EntityBean entity;
    private boolean caseInsensitive;
    private LikeType likeType;
    private boolean includeZeros;
    private ArrayList<SpiExpression> list;

    public DefaultExampleExpression(EntityBean entity, boolean caseInsensitive, LikeType likeType) {
        this.entity = entity;
        this.caseInsensitive = caseInsensitive;
        this.likeType = likeType;
    }

    DefaultExampleExpression(ArrayList<SpiExpression> source) {
        this.entity = null;
        this.list = new ArrayList(source.size());
        for (SpiExpression expression : source) {
            this.list.add(expression.copyForPlanKey());
        }
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (!this.list.isEmpty()) {
            context.startBoolMust();
            for (SpiExpression expr : this.list) {
                expr.writeDocQuery(context);
            }
            context.endBool();
        }
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return new DefaultExampleExpression(this.list);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins whereManyJoins) {
        this.list = this.buildExpressions(desc);
        if (this.list != null) {
            for (SpiExpression aList : this.list) {
                aList.containsMany(desc, whereManyJoins);
            }
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
    }

    public ExampleExpression includeZeros() {
        this.includeZeros = true;
        return this;
    }

    public ExampleExpression caseInsensitive() {
        this.caseInsensitive = true;
        return this;
    }

    public ExampleExpression useStartsWith() {
        this.likeType = LikeType.STARTS_WITH;
        return this;
    }

    public ExampleExpression useContains() {
        this.likeType = LikeType.CONTAINS;
        return this;
    }

    public ExampleExpression useEndsWith() {
        this.likeType = LikeType.ENDS_WITH;
        return this;
    }

    public ExampleExpression useEqualTo() {
        this.likeType = LikeType.EQUAL_TO;
        return this;
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (SpiExpression aList : this.list) {
            aList.validate(validation);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (SpiExpression item : this.list) {
            item.addBindValues(request);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.list.isEmpty()) {
            request.append("1=1");
        } else {
            request.append("(");
            for (int i = 0; i < this.list.size(); ++i) {
                SpiExpression item = this.list.get(i);
                if (i > 0) {
                    request.append(" and ");
                }
                item.addSql(request);
            }
            request.append(")");
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Example[");
        for (SpiExpression aList : this.list) {
            aList.queryPlanHash(builder);
            builder.append(",");
        }
        builder.append("]");
    }

    @Override
    public int queryBindHash() {
        int hc = DefaultExampleExpression.class.getName().hashCode();
        for (SpiExpression aList : this.list) {
            hc = hc * 92821 + aList.queryBindHash();
        }
        return hc;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        DefaultExampleExpression that = (DefaultExampleExpression)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).isSameByBind(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    private ArrayList<SpiExpression> buildExpressions(BeanDescriptor<?> beanDescriptor) {
        ArrayList<SpiExpression> list = new ArrayList<SpiExpression>();
        this.addExpressions(list, beanDescriptor, this.entity, null);
        return list;
    }

    private void addExpressions(ArrayList<SpiExpression> list, BeanDescriptor<?> beanDescriptor, EntityBean bean, String prefix) {
        for (BeanProperty beanProperty : beanDescriptor.propertiesAll()) {
            Object value;
            if (beanProperty.isTransient() || (value = beanProperty.getValue(bean)) == null) continue;
            String propName = SplitName.add((String)prefix, (String)beanProperty.getName());
            if (beanProperty.isScalar()) {
                if (value instanceof String) {
                    list.add(new LikeExpression(propName, value, this.caseInsensitive, this.likeType));
                    continue;
                }
                if (!this.includeZeros && this.isZero(value)) continue;
                list.add(new SimpleExpression(propName, Op.EQ, value));
                continue;
            }
            if (!(beanProperty instanceof BeanPropertyAssocOne) || !(value instanceof EntityBean)) continue;
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)beanProperty;
            BeanDescriptor targetDescriptor = assocOne.getTargetDescriptor();
            this.addExpressions(list, targetDescriptor, (EntityBean)value, propName);
        }
    }

    private boolean isZero(Object value) {
        return value instanceof Number && ((Number)value).doubleValue() == 0.0;
    }
}

