/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.QueryPlanMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DQueryPlanMeta;
import io.ebeaninternal.server.profile.DTimeMetricStats;
import io.ebeaninternal.server.profile.DTimedMetric;

class DQueryPlanMetric
implements QueryPlanMetric {
    private final DQueryPlanMeta meta;
    private final DTimedMetric metric;
    private boolean collected;

    DQueryPlanMetric(DQueryPlanMeta meta, DTimedMetric metric) {
        this.meta = meta;
        this.metric = metric;
    }

    public void visit(MetricVisitor visitor) {
        DTimeMetricStats stats = this.metric.collect(visitor.isReset());
        if (stats != null) {
            visitor.visitQuery((MetaQueryMetric)new Stats(this.meta, stats, this.collected));
            this.collected = true;
        }
    }

    public TimedMetric getMetric() {
        return this.metric;
    }

    private static class Stats
    implements MetaQueryMetric {
        private final DQueryPlanMeta meta;
        private final TimedMetricStats stats;
        private final boolean collected;

        private Stats(DQueryPlanMeta meta, TimedMetricStats stats, boolean collected) {
            this.meta = meta;
            this.stats = stats;
            this.collected = collected;
        }

        public String toString() {
            return this.meta + " " + this.stats + " sql:" + this.getSql();
        }

        public Class<?> getType() {
            return this.meta.getType();
        }

        public boolean initialCollection() {
            return !this.collected;
        }

        public String getHash() {
            return this.meta.getHash();
        }

        public String getLabel() {
            return this.meta.getLabel();
        }

        public String getSql() {
            return this.meta.getSql();
        }

        public String getName() {
            return this.meta.getName();
        }

        public String getLocation() {
            return this.meta.getLocation();
        }

        public long getCount() {
            return this.stats.getCount();
        }

        public long getTotal() {
            return this.stats.getTotal();
        }

        public long getMax() {
            return this.stats.getMax();
        }

        public long getMean() {
            return this.stats.getMean();
        }
    }
}

