/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.QueryPlanRequest;
import io.ebeaninternal.server.query.CQueryBindCapture;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CQueryPlanRequest {
    private final List<MetaQueryPlan> plans = new ArrayList<MetaQueryPlan>();
    private final Connection connection;
    private final long since;
    private final int maxCount;
    private final long maxTime;
    private Iterator<CQueryBindCapture> iterator;

    CQueryPlanRequest(Connection connection, QueryPlanRequest req, Iterator<CQueryBindCapture> iterator) {
        this.connection = connection;
        this.iterator = iterator;
        this.maxCount = req.getMaxCount();
        long reqSince = req.getSince();
        this.since = reqSince == 0L ? Long.MAX_VALUE : reqSince;
        long maxTimeMillis = req.getMaxTimeMillis();
        this.maxTime = maxTimeMillis > 0L ? System.currentTimeMillis() + maxTimeMillis : 0L;
    }

    Connection getConnection() {
        return this.connection;
    }

    void add(MetaQueryPlan dbQueryPlan) {
        this.plans.add(dbQueryPlan);
    }

    long getSince() {
        return this.since;
    }

    List<MetaQueryPlan> getPlans() {
        return this.plans;
    }

    boolean hasNext() {
        return this.moreByCount() && this.moreByTime() && this.iterator.hasNext();
    }

    void nextCapture() {
        CQueryBindCapture next = this.iterator.next();
        if (next.collectQueryPlan(this)) {
            this.iterator.remove();
        }
    }

    private boolean moreByCount() {
        return this.maxCount == 0 || this.maxCount > this.plans.size();
    }

    private boolean moreByTime() {
        return this.maxTime == 0L || this.maxTime > System.currentTimeMillis();
    }
}

