/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebean.config.ProfilingConfig;
import io.ebean.plugin.Plugin;
import io.ebean.plugin.SpiServer;
import io.ebeaninternal.api.SpiProfileHandler;
import io.ebeaninternal.server.transaction.DefaultProfileStream;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TransactionProfile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileHandler
implements SpiProfileHandler,
Plugin {
    private static final Logger log = LoggerFactory.getLogger(DefaultProfileHandler.class);
    private static final DateTimeFormatter DTF = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('-').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('-').appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    private final Queue<TransactionProfile> queue = new ConcurrentLinkedQueue<TransactionProfile>();
    private final ExecutorService executor;
    private final File dir;
    private final long minMicros;
    private final long profilesPerFile;
    private final boolean verbose;
    private volatile boolean shutdown;
    private long profileCounter;
    private int sleepBackoff;
    private Writer out;

    public DefaultProfileHandler(ProfilingConfig config) {
        this.verbose = config.isVerbose();
        this.minMicros = config.getMinimumMicros();
        this.profilesPerFile = config.getProfilesPerFile();
        this.executor = Executors.newSingleThreadExecutor();
        this.dir = new File(config.getDirectory());
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            log.error("failed to mkdirs " + this.dir.getAbsolutePath());
        }
        this.incrementFile();
    }

    @Override
    public void collectTransactionProfile(TransactionProfile transactionProfile) {
        this.queue.add(transactionProfile);
    }

    @Override
    public ProfileStream createProfileStream(ProfileLocation location) {
        return new DefaultProfileStream(location, this.verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCurrentFile() {
        DefaultProfileHandler defaultProfileHandler = this;
        synchronized (defaultProfileHandler) {
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (IOException e) {
                    log.error("Failed to flush and close transaction profiling file ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementFile() {
        DefaultProfileHandler defaultProfileHandler = this;
        synchronized (defaultProfileHandler) {
            this.flushCurrentFile();
            try {
                String now = DTF.format(LocalDateTime.now());
                File file = new File(this.dir, "txprofile-" + now + ".tprofile");
                this.out = new BufferedWriter(new FileWriter(file));
            }
            catch (IOException e) {
                log.error("Not expected", (Throwable)e);
            }
        }
    }

    private void collect() {
        try {
            while (!this.shutdown) {
                TransactionProfile profile = this.queue.poll();
                if (profile == null) {
                    this.sleep();
                    continue;
                }
                if (!this.include(profile)) continue;
                this.write(profile);
            }
            this.flushCurrentFile();
        }
        catch (Exception e) {
            log.warn("Error on collect", (Throwable)e);
        }
    }

    private void write(TransactionProfile profile) {
        try {
            this.sleepBackoff = 0;
            ++this.profileCounter;
            StringBuilder sb = new StringBuilder(80);
            sb.append(profile.getStartTime()).append(' ').append(profile.getLabel()).append(' ').append(profile.getTotalMicros()).append(' ');
            this.appendSummary(profile, sb);
            this.out.write(sb.toString());
            if (this.verbose) {
                this.out.write(32);
                this.out.write(profile.getData());
            }
            this.out.write(10);
            if (this.profileCounter % this.profilesPerFile == 0L) {
                this.incrementFile();
                log.debug("profiled {} transactions", (Object)this.profileCounter);
            }
        }
        catch (IOException e) {
            log.warn("Error writing transaction profiling", (Throwable)e);
        }
    }

    private void appendSummary(TransactionProfile profile, StringBuilder sb) {
        TransactionProfile.Summary summary = profile.getSummary();
        sb.append("z:").append(this.rate(profile.getTotalMicros(), summary.persistCount + summary.queryCount)).append(' ');
        sb.append("p:").append(this.rate(summary.persistMicros, summary.persistBeans)).append(' ');
        sb.append("q:").append(this.rate(summary.queryMicros, summary.queryCount)).append(' ');
        sb.append("qm:").append(summary.queryMax).append(' ');
        sb.append("qt:").append(summary.queryMicros).append(' ');
        sb.append("qc:").append(summary.queryCount).append(' ');
        sb.append("qb:").append(summary.queryBeans).append(' ');
        sb.append("pt:").append(summary.persistMicros).append(' ');
        sb.append("pc:").append(summary.persistCount).append(' ');
        sb.append("pb:").append(summary.persistBeans).append(' ');
        sb.append("po:").append(summary.persistOneCount).append(' ');
        sb.append("pz:").append(this.rate(summary.persistBeans, summary.persistCount));
    }

    private int rate(long micros, long count) {
        return count < 1L ? 0 : (int)(micros / count);
    }

    private boolean include(TransactionProfile profile) {
        return profile.getTotalMicros() >= this.minMicros;
    }

    private void sleep() {
        try {
            int sleepFor = Math.min(++this.sleepBackoff, 250);
            Thread.sleep(sleepFor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void configure(SpiServer server) {
    }

    public void online(boolean online) {
        if (online) {
            this.executor.submit(this::collect);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        log.trace("shutting down");
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(4L, TimeUnit.SECONDS)) {
                log.info("Shut down timeout exceeded. Terminating profiling consumer thread.");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupt on shutdown", (Throwable)e);
        }
        this.flushCurrentFile();
    }
}

