/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeDuration;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Duration;

public class ScalarTypeDurationWithNanos
extends ScalarTypeDuration {
    public ScalarTypeDurationWithNanos() {
        super(3);
    }

    @Override
    public void bind(DataBind bind, Duration value) throws SQLException {
        if (value == null) {
            bind.setNull(3);
        } else {
            bind.setBigDecimal(this.convertToBigDecimal(value));
        }
    }

    @Override
    public Duration read(DataReader dataReader) throws SQLException {
        return this.convertFromBigDecimal(dataReader.getBigDecimal());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof BigDecimal) {
            return value;
        }
        return this.convertToBigDecimal((Duration)value);
    }

    @Override
    public Duration toBeanType(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value == null) {
            return null;
        }
        return this.convertFromBigDecimal(BasicTypeConverter.toBigDecimal(value));
    }
}

