/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EnumType;

public class ScalarTypeEnumStandard {

    public static abstract class EnumBase
    extends ScalarTypeBase {
        protected final Class enumType;

        public EnumBase(Class<?> type, boolean jdbcNative, int jdbcType) {
            super(type, jdbcNative, jdbcType);
            this.enumType = type;
        }

        @Override
        public String format(Object value) {
            return ((Enum)value).name();
        }

        @Override
        public String formatValue(Object value) {
            return ((Enum)value).name();
        }

        @Override
        public Object parse(String value) {
            return Enum.valueOf(this.enumType, value);
        }

        @Override
        public Object convertFromMillis(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public Object jsonRead(JsonParser parser) throws IOException {
            if (parser.getCodec() != null) {
                return parser.readValueAs(this.enumType);
            }
            return this.parse(parser.getValueAsString());
        }

        @Override
        public void jsonWrite(JsonGenerator writer, Object value) throws IOException {
            if (writer.getCodec() != null) {
                writer.writeObject(value);
            } else {
                writer.writeString(this.formatValue(value));
            }
        }

        @Override
        public DocPropertyType getDocType() {
            return DocPropertyType.ENUM;
        }

        @Override
        public Object readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return this.parse(dataInput.readUTF());
        }

        @Override
        public void writeData(DataOutput dataOutput, Object value) throws IOException {
            if (value == null) {
                dataOutput.writeBoolean(false);
            } else {
                ScalarHelp.writeUTF(dataOutput, this.format(value));
            }
        }
    }

    public static class OrdinalEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final Object[] enumArray;

        public OrdinalEnum(Class enumType) {
            super((Class<?>)enumType, false, 4);
            this.enumArray = EnumSet.allOf(enumType).toArray();
        }

        @Override
        public boolean isCompatible(EnumType enumType) {
            return EnumType.ORDINAL == enumType;
        }

        @Override
        public Set<String> getDbCheckConstraintValues() {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (Object anEnumArray : this.enumArray) {
                Enum e = (Enum)anEnumArray;
                values.add(Integer.toString(e.ordinal()));
            }
            return values;
        }

        @Override
        public void bind(DataBind b, Object value) throws SQLException {
            if (value == null) {
                b.setNull(4);
            } else {
                b.setInt(((Enum)value).ordinal());
            }
        }

        @Override
        public Object read(DataReader dataReader) throws SQLException {
            Integer ordinal = dataReader.getInt();
            if (ordinal == null) {
                return null;
            }
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }

        @Override
        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return ((Enum)beanValue).ordinal();
        }

        @Override
        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            int ordinal = (Integer)dbValue;
            if (ordinal < 0 || ordinal >= this.enumArray.length) {
                String m = "Unexpected ordinal [" + ordinal + "] out of range [" + this.enumArray.length + "]";
                throw new IllegalStateException(m);
            }
            return this.enumArray[ordinal];
        }
    }

    public static class StringEnum
    extends EnumBase
    implements ScalarTypeEnum {
        private final int length;

        public StringEnum(Class enumType) {
            super((Class<?>)enumType, false, 12);
            this.length = this.maxValueLength(enumType);
        }

        @Override
        public boolean isCompatible(EnumType enumType) {
            return EnumType.STRING == enumType;
        }

        @Override
        public Set<String> getDbCheckConstraintValues() {
            T[] ea;
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            for (Object anEa : ea = this.enumType.getEnumConstants()) {
                Enum e = (Enum)anEa;
                values.add("'" + e.name() + "'");
            }
            return values;
        }

        private int maxValueLength(Class<?> enumType) {
            ?[] ea;
            int maxLen = 0;
            for (Object anEa : ea = enumType.getEnumConstants()) {
                Enum e = (Enum)anEa;
                maxLen = Math.max(maxLen, e.name().length());
            }
            return maxLen;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void bind(DataBind b, Object value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else {
                b.setString(this.format(value));
            }
        }

        @Override
        public Object read(DataReader dataReader) throws SQLException {
            String string = dataReader.getString();
            if (string == null) {
                return null;
            }
            return this.parse(string);
        }

        @Override
        public Object toJdbcType(Object beanValue) {
            if (beanValue == null) {
                return null;
            }
            return this.format(beanValue);
        }

        @Override
        public Object toBeanType(Object dbValue) {
            if (dbValue == null || dbValue instanceof Enum) {
                return dbValue;
            }
            return Enum.valueOf(this.enumType, (String)dbValue);
        }
    }
}

