/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;

public class ScalarTypeJodaLocalTime
extends ScalarTypeBase<LocalTime> {
    public ScalarTypeJodaLocalTime() {
        super(LocalTime.class, false, 92);
    }

    @Override
    public void bind(DataBind b, LocalTime value) throws SQLException {
        if (value == null) {
            b.setNull(92);
        } else {
            b.setTime(new Time(value.toDateTimeToday().getMillis()));
        }
    }

    @Override
    public LocalTime read(DataReader dataReader) throws SQLException {
        Time sqlTime = dataReader.getTime();
        if (sqlTime == null) {
            return null;
        }
        return new LocalTime((Object)sqlTime, DateTimeZone.getDefault());
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof LocalTime) {
            LocalTime lt = (LocalTime)value;
            return new Time(lt.toDateTimeToday().getMillis());
        }
        return BasicTypeConverter.toTime(value);
    }

    @Override
    public LocalTime toBeanType(Object value) {
        if (value instanceof Date) {
            return new LocalTime(value, DateTimeZone.getDefault());
        }
        return (LocalTime)value;
    }

    @Override
    public String formatValue(LocalTime v) {
        return v.toString();
    }

    @Override
    public LocalTime parse(String value) {
        return new LocalTime((Object)value);
    }

    @Override
    public LocalTime convertFromMillis(long systemTimeMillis) {
        return new LocalTime(systemTimeMillis, DateTimeZone.getDefault());
    }

    @Override
    public boolean isDateTimeCapable() {
        return true;
    }

    @Override
    public LocalTime readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        String val = dataInput.readUTF();
        return this.parse(val);
    }

    @Override
    public void writeData(DataOutput dataOutput, LocalTime value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.format(value));
        }
    }

    @Override
    public void jsonWrite(JsonGenerator writer, LocalTime value) throws IOException {
        writer.writeString(value.toString());
    }

    @Override
    public LocalTime jsonRead(JsonParser parser) throws IOException {
        if (JsonToken.VALUE_NUMBER_INT == parser.getCurrentToken()) {
            return this.convertFromMillis(parser.getLongValue());
        }
        return this.parse(parser.getValueAsString());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.KEYWORD;
    }
}

