/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeLocalTime;
import java.sql.SQLException;
import java.time.LocalTime;

public class ScalarTypeLocalTimeWithNanos
extends ScalarTypeLocalTime {
    public ScalarTypeLocalTimeWithNanos() {
        super(-5);
    }

    @Override
    public void bind(DataBind bind, LocalTime value) throws SQLException {
        if (value == null) {
            bind.setNull(-5);
        } else {
            bind.setLong(value.toNanoOfDay());
        }
    }

    @Override
    public LocalTime read(DataReader dataReader) throws SQLException {
        Long value = dataReader.getLong();
        return value == null ? null : LocalTime.ofNanoOfDay(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Long) {
            return value;
        }
        return ((LocalTime)value).toNanoOfDay();
    }

    @Override
    public LocalTime toBeanType(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value == null) {
            return null;
        }
        return LocalTime.ofNanoOfDay(BasicTypeConverter.toLong(value));
    }
}

