/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.server.lib.DaemonExecutorService;
import io.ebeaninternal.server.lib.DaemonScheduleThreadPool;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public class DefaultBackgroundExecutor
implements SpiBackgroundExecutor {
    private final DaemonScheduleThreadPool schedulePool;
    private final DaemonExecutorService pool;

    public DefaultBackgroundExecutor(int schedulePoolSize, int shutdownWaitSeconds, String namePrefix) {
        this.pool = new DaemonExecutorService(shutdownWaitSeconds, namePrefix);
        this.schedulePool = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix + "-periodic-");
    }

    public void execute(Runnable r) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            this.pool.execute(r);
        } else {
            this.pool.execute(() -> {
                MDC.setContextMap((Map)map);
                try {
                    r.run();
                }
                finally {
                    MDC.clear();
                }
            });
        }
    }

    public void executePeriodically(Runnable r, long delay, TimeUnit unit) {
        this.executePeriodically(r, delay, delay, unit);
    }

    public void executePeriodically(Runnable r, long initialDelay, long delay, TimeUnit unit) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            this.schedulePool.scheduleWithFixedDelay(r, initialDelay, delay, unit);
        } else {
            this.schedulePool.scheduleWithFixedDelay(() -> {
                MDC.setContextMap((Map)map);
                try {
                    r.run();
                }
                finally {
                    MDC.clear();
                }
            }, initialDelay, delay, unit);
        }
    }

    public ScheduledFuture<?> schedule(Runnable r, long delay, TimeUnit unit) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return this.schedulePool.schedule(r, delay, unit);
        }
        return this.schedulePool.schedule(() -> {
            MDC.setContextMap((Map)map);
            try {
                r.run();
            }
            finally {
                MDC.clear();
            }
        }, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> c, long delay, TimeUnit unit) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return this.schedulePool.schedule(c, delay, unit);
        }
        return this.schedulePool.schedule(() -> {
            MDC.setContextMap((Map)map);
            try {
                Object v = c.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        }, delay, unit);
    }

    @Override
    public void shutdown() {
        this.pool.shutdown();
        this.schedulePool.shutdown();
    }
}

