/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.BackgroundExecutor;
import io.ebean.Model;
import io.ebean.RawSqlBuilder;
import io.ebean.annotation.ConstraintMode;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.config.BeanNotEnhancedException;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.EncryptKey;
import io.ebean.config.EncryptKeyManager;
import io.ebean.config.NamingConvention;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbHistorySupport;
import io.ebean.config.dbplatform.DbIdentity;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.core.type.ScalarType;
import io.ebean.event.changelog.ChangeLogFilter;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeLogRegister;
import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.MetricVisitor;
import io.ebean.meta.QueryPlanInit;
import io.ebean.plugin.BeanType;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cache.SpiCacheManager;
import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.core.InternalConfiguration;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorElementEmbedded;
import io.ebeaninternal.server.deploy.BeanDescriptorElementEmbeddedMap;
import io.ebeaninternal.server.deploy.BeanDescriptorElementScalar;
import io.ebeaninternal.server.deploy.BeanDescriptorElementScalarMap;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanDescriptorMap;
import io.ebeaninternal.server.deploy.BeanFinderManager;
import io.ebeaninternal.server.deploy.BeanLifecycleAdapterFactory;
import io.ebeaninternal.server.deploy.BeanManager;
import io.ebeaninternal.server.deploy.BeanManagerFactory;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanQueryAdapterManager;
import io.ebeaninternal.server.deploy.BeanTable;
import io.ebeaninternal.server.deploy.DetermineAggPath;
import io.ebeaninternal.server.deploy.ElementHelp;
import io.ebeaninternal.server.deploy.ElementHelpList;
import io.ebeaninternal.server.deploy.ElementHelpMap;
import io.ebeaninternal.server.deploy.ElementHelpSet;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.ManyType;
import io.ebeaninternal.server.deploy.PersistControllerManager;
import io.ebeaninternal.server.deploy.PersistListenerManager;
import io.ebeaninternal.server.deploy.PostConstructManager;
import io.ebeaninternal.server.deploy.PostLoadManager;
import io.ebeaninternal.server.deploy.PropertyForeignKey;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.deploy.id.IdBinderEmbedded;
import io.ebeaninternal.server.deploy.id.IdBinderFactory;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssoc;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.meta.DeployBeanTable;
import io.ebeaninternal.server.deploy.meta.DeployIdentityMode;
import io.ebeaninternal.server.deploy.meta.DeployOrderColumn;
import io.ebeaninternal.server.deploy.meta.DeployTableJoin;
import io.ebeaninternal.server.deploy.parse.DeployBeanInfo;
import io.ebeaninternal.server.deploy.parse.DeployCreateProperties;
import io.ebeaninternal.server.deploy.parse.DeployInherit;
import io.ebeaninternal.server.deploy.parse.DeployUtil;
import io.ebeaninternal.server.deploy.parse.ReadAnnotations;
import io.ebeaninternal.server.deploy.parse.TransientProperties;
import io.ebeaninternal.server.persist.platform.MultiValueBind;
import io.ebeaninternal.server.properties.BeanPropertiesReader;
import io.ebeaninternal.server.properties.BeanPropertyAccess;
import io.ebeaninternal.server.properties.EnhanceBeanPropertyAccess;
import io.ebeaninternal.server.type.ScalarTypeInteger;
import io.ebeaninternal.server.type.TypeManager;
import io.ebeaninternal.xmapping.api.XmapEbean;
import io.ebeaninternal.xmapping.api.XmapEntity;
import io.ebeaninternal.xmapping.api.XmapNamedQuery;
import io.ebeaninternal.xmapping.api.XmapRawSql;
import io.ebeanservice.docstore.api.DocStoreBeanAdapter;
import io.ebeanservice.docstore.api.DocStoreFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptorManager
implements BeanDescriptorMap {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptorManager.class);
    private static final BeanDescComparator beanDescComparator = new BeanDescComparator();
    private final ReadAnnotations readAnnotations;
    private final TransientProperties transientProperties;
    private final DeployInherit deplyInherit;
    private final BeanPropertyAccess beanPropertyAccess = new EnhanceBeanPropertyAccess();
    private final DeployUtil deployUtil;
    private final PersistControllerManager persistControllerManager;
    private final PostLoadManager postLoadManager;
    private final PostConstructManager postConstructManager;
    private final BeanFinderManager beanFinderManager;
    private final PersistListenerManager persistListenerManager;
    private final BeanQueryAdapterManager beanQueryAdapterManager;
    private final NamingConvention namingConvention;
    private final DeployCreateProperties createProperties;
    private final BeanManagerFactory beanManagerFactory;
    private final DatabaseConfig config;
    private final ChangeLogListener changeLogListener;
    private final ChangeLogRegister changeLogRegister;
    private final ChangeLogPrepare changeLogPrepare;
    private final DocStoreFactory docStoreFactory;
    private final MultiValueBind multiValueBind;
    private final TypeManager typeManager;
    private final BootupClasses bootupClasses;
    private final String serverName;
    private final Map<Class<?>, BeanTable> beanTableMap = new HashMap();
    private final Map<String, BeanDescriptor<?>> descMap = new HashMap();
    private final Map<String, BeanDescriptor<?>> descQueueMap = new HashMap();
    private final Map<String, BeanManager<?>> beanManagerMap = new HashMap();
    private final Map<String, List<BeanDescriptor<?>>> tableToDescMap = new HashMap();
    private final Map<String, List<BeanDescriptor<?>>> tableToViewDescMap = new HashMap();
    private final DbIdentity dbIdentity;
    private final DataSource dataSource;
    private final DatabasePlatform databasePlatform;
    private final SpiCacheManager cacheManager;
    private final BackgroundExecutor backgroundExecutor;
    private final EncryptKeyManager encryptKeyManager;
    private final IdBinderFactory idBinderFactory;
    private final BeanLifecycleAdapterFactory beanLifecycleAdapterFactory;
    private final String asOfViewSuffix;
    private final boolean jacksonCorePresent;
    private final int queryPlanTTLSeconds;
    private int entityBeanCount;
    private List<BeanDescriptor<?>> immutableDescriptorList;
    private final Map<String, String> asOfTableMap = new HashMap<String, String>();
    private final Map<String, String> draftTableMap = new HashMap<String, String>();
    private Map<Class<?>, DeployBeanInfo<?>> deployInfoMap = new HashMap();
    private Set<Class<?>> embeddedIdTypes = new HashSet();
    private List<DeployBeanInfo<?>> embeddedBeans = new ArrayList();

    public BeanDescriptorManager(InternalConfiguration config) {
        this.config = config.getConfig();
        this.serverName = InternString.intern(this.config.getName());
        this.cacheManager = config.getCacheManager();
        this.docStoreFactory = config.getDocStoreFactory();
        this.backgroundExecutor = config.getBackgroundExecutor();
        this.dataSource = this.config.getDataSource();
        this.encryptKeyManager = this.config.getEncryptKeyManager();
        this.databasePlatform = this.config.getDatabasePlatform();
        this.multiValueBind = config.getMultiValueBind();
        this.idBinderFactory = new IdBinderFactory(this.databasePlatform.isIdInExpandedForm(), this.multiValueBind);
        this.queryPlanTTLSeconds = this.config.getQueryPlanTTLSeconds();
        this.asOfViewSuffix = this.getAsOfViewSuffix(this.databasePlatform, this.config);
        String versionsBetweenSuffix = this.getVersionsBetweenSuffix(this.databasePlatform, this.config);
        this.readAnnotations = new ReadAnnotations(config.getGeneratedPropertyFactory(), this.asOfViewSuffix, versionsBetweenSuffix, this.config);
        this.bootupClasses = config.getBootupClasses();
        this.createProperties = config.getDeployCreateProperties();
        this.namingConvention = this.config.getNamingConvention();
        this.dbIdentity = config.getDatabasePlatform().getDbIdentity();
        this.deplyInherit = config.getDeployInherit();
        this.deployUtil = config.getDeployUtil();
        this.typeManager = this.deployUtil.getTypeManager();
        this.beanManagerFactory = new BeanManagerFactory(config.getDatabasePlatform());
        this.beanLifecycleAdapterFactory = new BeanLifecycleAdapterFactory(this.config);
        this.persistControllerManager = new PersistControllerManager(this.bootupClasses);
        this.postLoadManager = new PostLoadManager(this.bootupClasses);
        this.postConstructManager = new PostConstructManager(this.bootupClasses);
        this.persistListenerManager = new PersistListenerManager(this.bootupClasses);
        this.beanQueryAdapterManager = new BeanQueryAdapterManager(this.bootupClasses);
        this.beanFinderManager = new BeanFinderManager(this.bootupClasses);
        this.transientProperties = new TransientProperties();
        this.changeLogPrepare = config.changeLogPrepare(this.bootupClasses.getChangeLogPrepare());
        this.changeLogListener = config.changeLogListener(this.bootupClasses.getChangeLogListener());
        this.changeLogRegister = config.changeLogRegister(this.bootupClasses.getChangeLogRegister());
        this.jacksonCorePresent = config.isJacksonCorePresent();
    }

    @Override
    public boolean isJacksonCorePresent() {
        return this.jacksonCorePresent;
    }

    public void scheduleBackgroundTrim() {
        this.backgroundExecutor.executePeriodically(this::trimQueryPlans, 117L, 60L, TimeUnit.SECONDS);
    }

    private void trimQueryPlans() {
        long lastUsed = System.currentTimeMillis() - (long)this.queryPlanTTLSeconds * 1000L;
        for (BeanDescriptor<?> descriptor : this.immutableDescriptorList) {
            if (descriptor.isEmbedded()) continue;
            descriptor.trimQueryPlans(lastUsed);
        }
    }

    @Override
    public ScalarType<?> getScalarType(String cast) {
        return this.typeManager.getScalarType(cast);
    }

    @Override
    public ScalarType<?> getScalarType(int jdbcType) {
        return this.typeManager.getScalarType(jdbcType);
    }

    private String getAsOfViewSuffix(DatabasePlatform databasePlatform, DatabaseConfig serverConfig) {
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        return historySupport == null ? serverConfig.getAsOfViewSuffix() : historySupport.getAsOfViewSuffix(serverConfig.getAsOfViewSuffix());
    }

    private String getVersionsBetweenSuffix(DatabasePlatform databasePlatform, DatabaseConfig serverConfig) {
        DbHistorySupport historySupport = databasePlatform.getHistorySupport();
        return historySupport == null ? serverConfig.getAsOfViewSuffix() : historySupport.getVersionsBetweenSuffix(serverConfig.getAsOfViewSuffix());
    }

    @Override
    public boolean isMultiValueSupported() {
        return this.multiValueBind.isSupported();
    }

    @Override
    public DatabaseConfig getConfig() {
        return this.config;
    }

    @Override
    public <T> DocStoreBeanAdapter<T> createDocStoreBeanAdapter(BeanDescriptor<T> descriptor, DeployBeanDescriptor<T> deploy) {
        return this.docStoreFactory.createAdapter(descriptor, deploy);
    }

    public BeanDescriptor<?> getBeanDescriptorByQueueId(String queueId) {
        return this.descQueueMap.get(queueId);
    }

    @Override
    public <T> BeanDescriptor<T> getBeanDescriptor(Class<T> entityType) {
        return this.descMap.get(entityType.getName());
    }

    public <T> BeanDescriptor<T> getBeanDescriptorByClassName(String entityClassName) {
        return this.descMap.get(entityClassName);
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public SpiCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setEbeanServer(SpiEbeanServer internalEbean) {
        for (BeanDescriptor<?> desc : this.immutableDescriptorList) {
            desc.setEbeanServer(internalEbean);
        }
    }

    @Override
    public IdBinder createIdBinder(BeanProperty idProperty) {
        return this.idBinderFactory.createIdBinder(idProperty);
    }

    public Map<String, String> getDraftTableMap() {
        return this.draftTableMap;
    }

    public Map<String, String> deploy(List<XmapEbean> mappings) {
        try {
            this.createListeners();
            this.readEntityDeploymentInitial();
            this.readXmlMapping(mappings);
            this.readEntityBeanTable();
            this.readEntityDeploymentAssociations();
            this.readInheritedIdGenerators();
            this.readEntityRelationships();
            ArrayList list = new ArrayList(this.descMap.values());
            list.sort(beanDescComparator);
            this.immutableDescriptorList = Collections.unmodifiableList(list);
            this.initialiseAll();
            this.readForeignKeys();
            this.readTableToDescriptor();
            this.logStatus();
            this.embeddedIdTypes = null;
            this.embeddedBeans = null;
            this.deployInfoMap = null;
            return this.asOfTableMap;
        }
        catch (BeanNotEnhancedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("Error in deployment", (Throwable)e);
            throw e;
        }
    }

    private void readXmlMapping(List<XmapEbean> mappings) {
        if (mappings != null) {
            ClassLoader classLoader = this.config.getClassLoadConfig().getClassLoader();
            for (XmapEbean mapping : mappings) {
                List entityDeploy = mapping.getEntity();
                for (XmapEntity deploy : entityDeploy) {
                    this.readEntityMapping(classLoader, deploy);
                }
            }
        }
    }

    private void readEntityMapping(ClassLoader classLoader, XmapEntity entityDeploy) {
        Class<?> entityClass;
        String entityClassName = entityDeploy.getClazz();
        try {
            entityClass = Class.forName(entityClassName, false, classLoader);
        }
        catch (Exception e) {
            logger.error("Could not load entity bean class " + entityClassName + " for ebean.xml entry");
            return;
        }
        DeployBeanInfo<?> info = this.deployInfoMap.get(entityClass);
        if (info == null) {
            logger.error("No entity bean for ebean.xml entry " + entityClassName);
        } else {
            for (XmapRawSql sql : entityDeploy.getRawSql()) {
                RawSqlBuilder builder;
                try {
                    builder = RawSqlBuilder.parse((String)sql.getQuery());
                }
                catch (RuntimeException e) {
                    builder = RawSqlBuilder.unparsed((String)sql.getQuery());
                }
                for (Map.Entry columnMapping : sql.getColumnMapping().entrySet()) {
                    builder.columnMapping((String)columnMapping.getKey(), (String)columnMapping.getValue());
                }
                for (Map.Entry aliasMapping : sql.getAliasMapping().entrySet()) {
                    builder.tableAliasMapping((String)aliasMapping.getKey(), (String)aliasMapping.getValue());
                }
                info.addRawSql(sql.getName(), builder.create());
            }
            for (XmapNamedQuery namedQuery : entityDeploy.getNamedQuery()) {
                info.addNamedQuery(namedQuery.getName(), namedQuery.getQuery());
            }
        }
    }

    @Override
    public EncryptKey getEncryptKey(String tableName, String columnName) {
        return this.encryptKeyManager.getEncryptKey(tableName, columnName);
    }

    public void cacheNotify(TransactionEventTable.TableIUD tableIUD, CacheChangeSet changeSet) {
        List<BeanDescriptor<?>> viewBeans;
        String tableName = tableIUD.getTableName().toLowerCase();
        List<BeanDescriptor<?>> normalBeanTypes = this.tableToDescMap.get(tableName);
        if (normalBeanTypes != null) {
            for (BeanDescriptor<?> normalBeanType : normalBeanTypes) {
                normalBeanType.cachePersistTableIUD(tableIUD, changeSet);
            }
        }
        if ((viewBeans = this.tableToViewDescMap.get(tableName)) != null) {
            for (BeanDescriptor<?> viewBean : viewBeans) {
                viewBean.cachePersistTableIUD(tableIUD, changeSet);
            }
        }
    }

    public List<BeanDescriptor<?>> getBeanDescriptors(String tableName) {
        return this.tableToDescMap.get(tableName.toLowerCase());
    }

    public List<? extends BeanType<?>> getBeanTypes(String tableName) {
        return this.tableToDescMap.get(tableName.toLowerCase());
    }

    public void processViewInvalidation(Set<String> viewInvalidation) {
        for (String depTable : viewInvalidation) {
            List<BeanDescriptor<?>> list = this.tableToViewDescMap.get(depTable.toLowerCase());
            if (list == null) continue;
            for (BeanDescriptor<?> desc : list) {
                desc.clearQueryCache();
            }
        }
    }

    private void readTableToDescriptor() {
        for (BeanDescriptor<?> desc : this.descMap.values()) {
            String[] dependentTables;
            String baseTable = desc.getBaseTable();
            if (baseTable != null) {
                baseTable = baseTable.toLowerCase();
                List list = this.tableToDescMap.computeIfAbsent(baseTable, k -> new ArrayList(1));
                list.add(desc);
            }
            if (desc.getEntityType() != BeanDescriptor.EntityType.VIEW || !desc.isQueryCaching() || (dependentTables = desc.getDependentTables()) == null || dependentTables.length <= 0) continue;
            for (String depTable : dependentTables) {
                depTable = depTable.toLowerCase();
                List list = this.tableToViewDescMap.computeIfAbsent(depTable, k -> new ArrayList(1));
                list.add(desc);
            }
        }
    }

    private void readForeignKeys() {
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseFkeys();
        }
    }

    private void initialiseAll() {
        BeanDescriptorInitContext initContext = new BeanDescriptorInitContext(this.asOfTableMap, this.draftTableMap, this.asOfViewSuffix);
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseId(initContext);
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initInheritInfo();
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseOther(initContext);
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initialiseDocMapping();
        }
        for (BeanDescriptor<?> d : this.descMap.values()) {
            d.initLast();
            if (d.isEmbedded()) continue;
            this.beanManagerMap.put(d.getFullName(), this.beanManagerFactory.create(d));
            this.checkForValidEmbeddedId(d);
        }
    }

    private void checkForValidEmbeddedId(BeanDescriptor<?> d) {
        IdBinder idBinder = d.getIdBinder();
        if (idBinder instanceof IdBinderEmbedded) {
            IdBinderEmbedded embId = (IdBinderEmbedded)idBinder;
            BeanDescriptor<?> idBeanDescriptor = embId.getIdBeanDescriptor();
            Class<?> idType = idBeanDescriptor.getBeanType();
            try {
                idType.getDeclaredMethod("hashCode", new Class[0]);
                idType.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException e) {
                this.checkMissingHashCodeOrEquals(e, idType, d.getBeanType());
            }
        }
    }

    private void checkMissingHashCodeOrEquals(Exception source, Class<?> idType, Class<?> beanType) {
        String msg = "SERIOUS ERROR: The hashCode() and equals() methods *MUST* be implemented ";
        msg = msg + "on Embedded bean " + idType + " as it is used as an Id for " + beanType;
        throw new PersistenceException(msg, (Throwable)source);
    }

    public boolean requiresViewEntityCacheInvalidation() {
        return !this.tableToViewDescMap.isEmpty();
    }

    public List<BeanDescriptor<?>> getBeanDescriptorList() {
        return this.immutableDescriptorList;
    }

    public BeanTable getBeanTable(Class<?> type) {
        return this.beanTableMap.get(type);
    }

    public BeanTable createCollectionBeanTable(String fullTableName, Class<?> targetType) {
        return new BeanTable(this, fullTableName, targetType);
    }

    public <T> BeanManager<T> getBeanManager(Class<T> entityType) {
        return this.getBeanManager(entityType.getName());
    }

    private BeanManager<?> getBeanManager(String beanClassName) {
        return this.beanManagerMap.get(beanClassName);
    }

    private void createListeners() {
        int qa = this.beanQueryAdapterManager.getRegisterCount();
        int cc = this.persistControllerManager.getRegisterCount();
        int pl = this.postLoadManager.getRegisterCount();
        int pc = this.postConstructManager.getRegisterCount();
        int lc = this.persistListenerManager.getRegisterCount();
        int fc = this.beanFinderManager.getRegisterCount();
        logger.debug("BeanPersistControllers[{}] BeanFinders[{}] BeanPersistListeners[{}] BeanQueryAdapters[{}] BeanPostLoaders[{}] BeanPostConstructors[{}]", new Object[]{cc, fc, lc, qa, pl, pc});
    }

    private void logStatus() {
        logger.debug("Entities[{}]", (Object)this.entityBeanCount);
    }

    public <T> DeployBeanInfo<T> getDeploy(Class<T> cls) {
        return this.deployInfoMap.get(cls);
    }

    private void registerBeanDescriptor(DeployBeanInfo<?> info) {
        BeanDescriptor desc = new BeanDescriptor(this, info.getDescriptor());
        this.descMap.put(desc.getBeanType().getName(), desc);
        if (desc.isDocStoreMapped()) {
            this.descQueueMap.put(desc.getDocStoreQueueId(), desc);
        }
    }

    private void readEntityDeploymentInitial() {
        DeployBeanInfo<?> info;
        for (Class<?> entityClass : this.bootupClasses.getEntities()) {
            info = this.createDeployBeanInfo(entityClass);
            this.deployInfoMap.put(entityClass, info);
            Class<?> embeddedIdType = info.getEmbeddedIdType();
            if (embeddedIdType == null) continue;
            this.embeddedIdTypes.add(embeddedIdType);
        }
        for (Class<?> entityClass : this.bootupClasses.getEmbeddables()) {
            info = this.createDeployBeanInfo(entityClass);
            this.deployInfoMap.put(entityClass, info);
            if (this.embeddedIdTypes.contains(entityClass)) {
                this.registerEmbeddedBean(info);
                continue;
            }
            this.embeddedBeans.add(info);
        }
    }

    private void registerEmbeddedBean(DeployBeanInfo<?> info) {
        this.readDeployAssociations(info);
        this.registerBeanDescriptor(info);
    }

    private void readEntityBeanTable() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            BeanTable beanTable = this.createBeanTable(info);
            this.beanTableMap.put(beanTable.getBeanType(), beanTable);
        }
        for (DeployBeanInfo<?> info : this.embeddedBeans) {
            this.registerEmbeddedBean(info);
        }
    }

    private void readEntityDeploymentAssociations() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            this.readDeployAssociations(info);
        }
    }

    private void readInheritedIdGenerators() {
        for (DeployBeanInfo<?> info : this.deployInfoMap.values()) {
            DeployBeanInfo<?> rootBeanInfo;
            PlatformIdGenerator rootIdGen;
            DeployBeanDescriptor<?> descriptor = info.getDescriptor();
            InheritInfo inheritInfo = descriptor.getInheritInfo();
            if (inheritInfo == null || inheritInfo.isRoot() || (rootIdGen = (rootBeanInfo = this.deployInfoMap.get(inheritInfo.getRoot().getType())).getDescriptor().getIdGenerator()) == null) continue;
            descriptor.setIdGenerator(rootIdGen);
        }
    }

    private BeanTable createBeanTable(DeployBeanInfo<?> info) {
        DeployBeanDescriptor<?> deployDescriptor = info.getDescriptor();
        DeployBeanTable beanTable = deployDescriptor.createDeployBeanTable();
        return new BeanTable(beanTable, this);
    }

    private void readEntityRelationships() {
        ArrayList primaryKeyJoinCheck = new ArrayList();
        for (DeployBeanInfo<?> deployBeanInfo : this.deployInfoMap.values()) {
            this.checkMappedBy(deployBeanInfo, primaryKeyJoinCheck);
        }
        for (DeployBeanPropertyAssocOne deployBeanPropertyAssocOne : primaryKeyJoinCheck) {
            this.checkUniDirectionalPrimaryKeyJoin(deployBeanPropertyAssocOne);
        }
        for (DeployBeanInfo<Object> deployBeanInfo : this.deployInfoMap.values()) {
            this.secondaryPropsJoins(deployBeanInfo);
        }
        for (DeployBeanInfo<Object> deployBeanInfo : this.deployInfoMap.values()) {
            this.setInheritanceInfo(deployBeanInfo);
        }
        for (DeployBeanInfo<Object> deployBeanInfo : this.deployInfoMap.values()) {
            if (deployBeanInfo.isEmbedded()) continue;
            this.registerBeanDescriptor(deployBeanInfo);
        }
    }

    private void setInheritanceInfo(DeployBeanInfo<?> info) {
        DeployBeanInfo<?> assoc;
        for (DeployBeanPropertyAssocOne<?> deployBeanPropertyAssocOne : info.getDescriptor().propertiesAssocOne()) {
            if (deployBeanPropertyAssocOne.isTransient() || (assoc = this.deployInfoMap.get(deployBeanPropertyAssocOne.getTargetType())) == null) continue;
            deployBeanPropertyAssocOne.getTableJoin().setInheritInfo(assoc.getDescriptor().getInheritInfo());
        }
        for (DeployBeanPropertyAssocMany deployBeanPropertyAssocMany : info.getDescriptor().propertiesAssocMany()) {
            if (deployBeanPropertyAssocMany.isTransient() || (assoc = this.deployInfoMap.get(deployBeanPropertyAssocMany.getTargetType())) == null) continue;
            deployBeanPropertyAssocMany.getTableJoin().setInheritInfo(assoc.getDescriptor().getInheritInfo());
        }
    }

    private void secondaryPropsJoins(DeployBeanInfo<?> info) {
        DeployBeanDescriptor<?> descriptor = info.getDescriptor();
        for (DeployBeanProperty prop : descriptor.propertiesBase()) {
            if (!prop.isSecondaryTable()) continue;
            String tableName = prop.getSecondaryTable();
            DeployBeanPropertyAssocOne<?> assocOne = descriptor.findJoinToTable(tableName);
            if (assocOne == null) {
                String msg = "Error with property " + prop.getFullBeanName() + ". Could not find a Relationship to table " + tableName + ". Perhaps you could use a @JoinColumn instead.";
                throw new RuntimeException(msg);
            }
            DeployTableJoin tableJoin = assocOne.getTableJoin();
            prop.setSecondaryTableJoin(tableJoin, assocOne.getName());
        }
    }

    private void checkMappedBy(DeployBeanInfo<?> info, List<DeployBeanPropertyAssocOne<?>> primaryKeyJoinCheck) {
        for (DeployBeanPropertyAssocOne<?> deployBeanPropertyAssocOne : info.getDescriptor().propertiesAssocOne()) {
            if (deployBeanPropertyAssocOne.isTransient()) continue;
            if (deployBeanPropertyAssocOne.getMappedBy() != null) {
                this.checkMappedByOneToOne(deployBeanPropertyAssocOne);
                continue;
            }
            if (!deployBeanPropertyAssocOne.isPrimaryKeyJoin()) continue;
            primaryKeyJoinCheck.add(deployBeanPropertyAssocOne);
        }
        for (DeployBeanPropertyAssocMany deployBeanPropertyAssocMany : info.getDescriptor().propertiesAssocMany()) {
            if (deployBeanPropertyAssocMany.isTransient()) continue;
            if (deployBeanPropertyAssocMany.isManyToMany()) {
                this.checkMappedByManyToMany(deployBeanPropertyAssocMany);
                continue;
            }
            this.checkMappedByOneToMany(info, deployBeanPropertyAssocMany);
        }
    }

    private DeployBeanDescriptor<?> getTargetDescriptor(DeployBeanPropertyAssoc<?> prop) {
        Class<?> targetType = prop.getTargetType();
        DeployBeanInfo<?> info = this.deployInfoMap.get(targetType);
        if (info == null) {
            String msg = "Can not find descriptor [" + targetType + "] for " + prop.getFullBeanName();
            throw new PersistenceException(msg);
        }
        return info.getDescriptor();
    }

    private boolean findMappedBy(DeployBeanPropertyAssocMany<?> prop) {
        String targetType;
        String shortTypeName;
        String name;
        int p;
        Class<?> owningType = prop.getOwningType();
        HashSet<String> matchSet = new HashSet<String>();
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        List<DeployBeanPropertyAssocOne<?>> ones = targetDesc.propertiesAssocOne();
        for (DeployBeanPropertyAssocOne<?> possibleMappedBy : ones) {
            Class possibleMappedByType = possibleMappedBy.getTargetType();
            if (!possibleMappedByType.equals(owningType)) continue;
            prop.setMappedBy(possibleMappedBy.getName());
            matchSet.add(possibleMappedBy.getName());
        }
        if (matchSet.isEmpty()) {
            return false;
        }
        if (matchSet.size() == 1) {
            prop.clearTableJoin();
            return true;
        }
        if (matchSet.size() == 2 && (p = (name = prop.getName()).indexOf(shortTypeName = (targetType = prop.getTargetType().getName()).substring(targetType.lastIndexOf(46) + 1))) > 1) {
            String searchName = name.substring(0, p).toLowerCase();
            for (String possibleMappedBy : matchSet) {
                String possibleLower = possibleMappedBy.toLowerCase();
                if (!possibleLower.contains(searchName)) continue;
                prop.setMappedBy(possibleMappedBy);
                String m = "Implicitly found mappedBy for " + targetDesc + "." + prop;
                m = m + " by searching for [" + searchName + "] against " + matchSet;
                logger.debug(m);
                return true;
            }
        }
        String msg = "Error on " + prop.getFullBeanName() + " missing mappedBy.";
        msg = msg + " There are [" + matchSet.size() + "] possible properties in " + targetDesc;
        msg = msg + " that this association could be mapped to. Please specify one using ";
        msg = msg + "the mappedBy attribute on @OneToMany.";
        throw new PersistenceException(msg);
    }

    private void makeOrderColumn(DeployBeanPropertyAssocMany<?> oneToMany) {
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(oneToMany);
        DeployOrderColumn orderColumn = oneToMany.getOrderColumn();
        DeployBeanProperty orderProperty = new DeployBeanProperty(targetDesc, Integer.class, ScalarTypeInteger.INSTANCE, null);
        orderProperty.setName("orderColumn");
        orderProperty.setDbColumn(orderColumn.getName());
        orderProperty.setNullable(orderColumn.isNullable());
        orderProperty.setDbInsertable(orderColumn.isInsertable());
        orderProperty.setDbUpdateable(orderColumn.isUpdatable());
        orderProperty.setDbRead(true);
        orderProperty.setOwningType(targetDesc.getBeanType());
        InheritInfo targetInheritInfo = targetDesc.getInheritInfo();
        if (targetInheritInfo != null) {
            for (InheritInfo child : targetInheritInfo.getChildren()) {
                DeployBeanDescriptor<?> childDescriptor = this.deployInfoMap.get(child.getType()).getDescriptor();
                childDescriptor.setOrderColumn(orderProperty);
            }
        }
        targetDesc.setOrderColumn(orderProperty);
    }

    private void makeUnidirectional(DeployBeanPropertyAssocMany<?> oneToMany) {
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(oneToMany);
        Class<?> owningType = oneToMany.getOwningType();
        if (!oneToMany.getCascadeInfo().isSave()) {
            Class targetType = oneToMany.getTargetType();
            String msg = "Error on " + oneToMany.getFullBeanName() + ". @OneToMany MUST have ";
            msg = msg + "Cascade.PERSIST or Cascade.ALL because this is a unidirectional ";
            msg = msg + "relationship. That is, there is no property of type " + owningType + " on " + targetType;
            throw new PersistenceException(msg);
        }
        oneToMany.setUnidirectional();
        BeanTable beanTable = this.getBeanTable(owningType);
        DeployTableJoin oneToManyJoin = oneToMany.getTableJoin();
        if (!oneToManyJoin.hasJoinColumns()) {
            throw new RuntimeException("No join columns");
        }
        this.createUnidirectional(targetDesc, owningType, beanTable, oneToManyJoin);
    }

    public <A> void createUnidirectional(DeployBeanDescriptor<?> targetDesc, Class<A> targetType, BeanTable beanTable, DeployTableJoin oneToManyJoin) {
        DeployBeanPropertyAssocOne<A> unidirectional = new DeployBeanPropertyAssocOne<A>(targetDesc, targetType);
        unidirectional.setUndirectionalShadow();
        unidirectional.setNullable(false);
        unidirectional.setDbRead(true);
        unidirectional.setDbInsertable(true);
        unidirectional.setDbUpdateable(false);
        unidirectional.setBeanTable(beanTable);
        unidirectional.setName(beanTable.getBaseTable());
        unidirectional.setJoinType(true);
        unidirectional.setJoinColumns(oneToManyJoin.columns(), true);
        targetDesc.setUnidirectional(unidirectional);
    }

    private void checkMappedByOneToOne(DeployBeanPropertyAssocOne<?> prop) {
        String mappedBy = prop.getMappedBy();
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        DeployBeanProperty mappedProp = targetDesc.getBeanProperty(mappedBy);
        if (mappedProp == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + targetDesc + "." + mappedBy + "] ";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocOne)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "]is not a OneToOne?";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocOne mappedAssocOne = (DeployBeanPropertyAssocOne)mappedProp;
        if (!mappedAssocOne.isOneToOne()) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "]is not a OneToOne?";
            throw new PersistenceException(m);
        }
        DeployTableJoin tableJoin = prop.getTableJoin();
        if (!tableJoin.hasJoinColumns()) {
            DeployTableJoin otherTableJoin = mappedAssocOne.getTableJoin();
            otherTableJoin.copyWithoutType(tableJoin, true, tableJoin.getTable());
        }
        if (mappedAssocOne.isPrimaryKeyJoin()) {
            mappedAssocOne.setPrimaryKeyJoin(false);
            prop.setPrimaryKeyExport();
            this.addPrimaryKeyJoin(prop);
        }
    }

    private void checkUniDirectionalPrimaryKeyJoin(DeployBeanPropertyAssocOne<?> prop) {
        if (prop.isPrimaryKeyJoin()) {
            prop.setPrimaryKeyExport();
            this.addPrimaryKeyJoin(prop);
        }
    }

    private void checkMappedByOneToMany(DeployBeanInfo<?> info, DeployBeanPropertyAssocMany<?> prop) {
        PropertyForeignKey foreignKey;
        String mappedBy;
        DeployBeanProperty mappedProp;
        if (prop.isElementCollection()) {
            return;
        }
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        if (targetDesc.isDraftableElement()) {
            prop.setModifyListenMode(BeanCollection.ModifyListenMode.REMOVALS);
            prop.getCascadeInfo().setSaveDelete(true, true);
        }
        if (prop.hasOrderColumn()) {
            this.makeOrderColumn(prop);
        }
        if (prop.getMappedBy() == null) {
            if (info.getDescriptor().isDocStoreOnly()) {
                prop.setUnidirectional();
                return;
            }
            if (!this.findMappedBy(prop)) {
                if (!prop.isO2mJoinTable()) {
                    this.makeUnidirectional(prop);
                }
                return;
            }
        }
        if ((mappedProp = targetDesc.getBeanProperty(mappedBy = prop.getMappedBy())) == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + mappedBy + "] ";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocOne)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + mappedBy + "]is not a ManyToOne?";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocOne mappedAssocOne = (DeployBeanPropertyAssocOne)mappedProp;
        DeployTableJoin tableJoin = prop.getTableJoin();
        if (!tableJoin.hasJoinColumns()) {
            DeployTableJoin otherTableJoin = mappedAssocOne.getTableJoin();
            otherTableJoin.copyTo(tableJoin, true, tableJoin.getTable());
        }
        if ((foreignKey = mappedAssocOne.getForeignKey()) != null) {
            ConstraintMode onDelete = foreignKey.getOnDelete();
            switch (onDelete) {
                case SET_DEFAULT: 
                case SET_NULL: 
                case CASCADE: {
                    prop.getCascadeInfo().setDelete(false);
                }
            }
        }
    }

    private void checkMappedByManyToMany(DeployBeanPropertyAssocMany<?> prop) {
        String mappedBy = prop.getMappedBy();
        if (mappedBy == null) {
            if (this.getTargetDescriptor(prop).isDraftable()) {
                prop.setIntersectionDraftTable();
            }
            return;
        }
        DeployBeanDescriptor<?> targetDesc = this.getTargetDescriptor(prop);
        DeployBeanProperty mappedProp = targetDesc.getBeanProperty(mappedBy);
        if (mappedProp == null) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + "  Can not find mappedBy property [" + mappedBy + "] ";
            m = m + "in [" + targetDesc + "]";
            throw new PersistenceException(m);
        }
        if (!(mappedProp instanceof DeployBeanPropertyAssocMany)) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "] is not a ManyToMany?";
            throw new PersistenceException(m);
        }
        DeployBeanPropertyAssocMany mappedAssocMany = (DeployBeanPropertyAssocMany)mappedProp;
        if (!mappedAssocMany.isManyToMany()) {
            String m = "Error on " + prop.getFullBeanName();
            m = m + ". mappedBy property [" + targetDesc + "." + mappedBy + "] is not a ManyToMany?";
            throw new PersistenceException(m);
        }
        DeployTableJoin mappedIntJoin = mappedAssocMany.getIntersectionJoin();
        DeployTableJoin mappendInverseJoin = mappedAssocMany.getInverseJoin();
        String intTableName = mappedIntJoin.getTable();
        DeployTableJoin tableJoin = prop.getTableJoin();
        mappedIntJoin.copyTo(tableJoin, true, targetDesc.getBaseTable());
        DeployTableJoin intJoin = new DeployTableJoin();
        mappendInverseJoin.copyTo(intJoin, false, intTableName);
        prop.setIntersectionJoin(intJoin);
        DeployTableJoin inverseJoin = new DeployTableJoin();
        mappedIntJoin.copyTo(inverseJoin, false, intTableName);
        prop.setInverseJoin(inverseJoin);
        if (targetDesc.isDraftable()) {
            prop.setIntersectionDraftTable();
        }
    }

    private <T> void setBeanControllerFinderListener(DeployBeanDescriptor<T> descriptor) {
        ChangeLogFilter changeFilter;
        this.persistControllerManager.addPersistControllers(descriptor);
        this.postLoadManager.addPostLoad(descriptor);
        this.postConstructManager.addPostConstructListeners(descriptor);
        this.persistListenerManager.addPersistListeners(descriptor);
        this.beanQueryAdapterManager.addQueryAdapter(descriptor);
        this.beanFinderManager.addFindControllers(descriptor);
        if (this.changeLogRegister != null && (changeFilter = this.changeLogRegister.getChangeFilter(descriptor.getBeanType())) != null) {
            descriptor.setChangeLogFilter(changeFilter);
        }
    }

    private <T> DeployBeanInfo<T> createDeployBeanInfo(Class<T> beanClass) {
        DeployBeanDescriptor<T> desc = new DeployBeanDescriptor<T>(this, beanClass, this.config);
        this.beanLifecycleAdapterFactory.addLifecycleMethods(desc);
        this.setBeanControllerFinderListener(desc);
        this.deplyInherit.process(desc);
        desc.checkInheritanceMapping();
        this.createProperties.createProperties(desc);
        DeployBeanInfo<T> info = new DeployBeanInfo<T>(this.deployUtil, desc);
        this.readAnnotations.readInitial(info);
        return info;
    }

    private <T> void readDeployAssociations(DeployBeanInfo<T> info) {
        DeployBeanDescriptor<T> desc = info.getDescriptor();
        this.readAnnotations.readAssociations(info, this);
        if (BeanDescriptor.EntityType.SQL == desc.getEntityType()) {
            desc.setBaseTable(null, null, null);
        }
        this.transientProperties.process(desc);
        this.setScalarType(desc);
        if (!desc.isEmbedded()) {
            this.setIdGeneration(desc);
            this.setConcurrencyMode(desc);
        }
        this.createByteCode(desc);
    }

    private <T> void setIdGeneration(DeployBeanDescriptor<T> desc) {
        if (desc.getIdGenerator() != null) {
            return;
        }
        if (desc.idProperty() == null) {
            return;
        }
        DeployIdentityMode identityMode = desc.getIdentityMode();
        if (identityMode.isSequence() && !this.dbIdentity.isSupportsSequence()) {
            logger.info("Explicit sequence on " + desc.getFullName() + " but not supported by DB Platform - ignored");
            identityMode.setIdType(IdType.AUTO);
        }
        if (identityMode.isIdentity() && !this.dbIdentity.isSupportsIdentity()) {
            logger.info("Explicit Identity on " + desc.getFullName() + " but not supported by DB Platform - ignored");
            identityMode.setIdType(IdType.AUTO);
        }
        if (identityMode.isAuto()) {
            if (desc.isPrimaryKeyCompoundOrNonNumeric()) {
                identityMode.setIdType(IdType.EXTERNAL);
                return;
            }
            if (desc.isIdGeneratedValue() || this.config.isIdGeneratorAutomatic()) {
                identityMode.setPlatformType(this.dbIdentity.getIdType());
            } else {
                identityMode.setIdType(IdType.EXTERNAL);
                return;
            }
        }
        if (desc.getBaseTable() == null) {
            return;
        }
        if (identityMode.isIdentity()) {
            String selectLastInsertedId = this.dbIdentity.getSelectLastInsertedId(desc.getBaseTable());
            String selectLastInsertedIdDraft = !desc.isDraftable() ? selectLastInsertedId : this.dbIdentity.getSelectLastInsertedId(desc.getDraftTable());
            desc.setSelectLastInsertedId(selectLastInsertedId, selectLastInsertedIdDraft);
            return;
        }
        if (identityMode.isSequence()) {
            String seqName = identityMode.getSequenceName();
            if (seqName == null || seqName.isEmpty()) {
                String primaryKeyColumn = desc.getSinglePrimaryKeyColumn();
                seqName = this.namingConvention.getSequenceName(desc.getBaseTable(), primaryKeyColumn);
            }
            int stepSize = desc.setIdentitySequenceBatchMode(this.databasePlatform.isSequenceBatchMode());
            desc.setIdGenerator(this.createSequenceIdGenerator(seqName, stepSize));
        }
    }

    private PlatformIdGenerator createSequenceIdGenerator(String seqName, int stepSize) {
        return this.databasePlatform.createSequenceIdGenerator(this.backgroundExecutor, this.dataSource, stepSize, seqName);
    }

    private void createByteCode(DeployBeanDescriptor<?> deploy) {
        this.setEntityBeanClass(deploy);
        this.setBeanReflect(deploy);
    }

    private void setScalarType(DeployBeanDescriptor<?> deployDesc) {
        for (DeployBeanProperty prop : deployDesc.propertiesAll()) {
            if (prop instanceof DeployBeanPropertyAssoc) continue;
            this.deployUtil.setScalarType(prop);
        }
    }

    private void setBeanReflect(DeployBeanDescriptor<?> desc) {
        BeanPropertiesReader reflectProps = new BeanPropertiesReader(desc.getBeanType());
        desc.setProperties(reflectProps.getProperties());
        for (DeployBeanProperty prop : desc.propertiesAll()) {
            String propName = prop.getName();
            Integer pos = reflectProps.getPropertyIndex(propName);
            if (pos == null) {
                if (!this.isPersistentField(prop)) continue;
                throw new IllegalStateException("If you are running in an IDE with enhancement plugin try a Build -> Rebuild Project to recompile and enhance all entity beans. Error - property " + propName + " not found in " + reflectProps + " for type " + desc.getBeanType());
            }
            int propertyIndex = pos;
            prop.setPropertyIndex(propertyIndex);
            prop.setGetter(this.beanPropertyAccess.getGetter(propertyIndex));
            prop.setSetter(this.beanPropertyAccess.getSetter(propertyIndex));
            if (!prop.isAggregation()) continue;
            prop.setAggregationPrefix(DetermineAggPath.manyPath(prop.getRawAggregation(), desc));
        }
    }

    private boolean isPersistentField(DeployBeanProperty prop) {
        Field field = prop.getField();
        if (field == null) {
            return false;
        }
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(Transient.class);
    }

    private void setConcurrencyMode(DeployBeanDescriptor<?> desc) {
        if (desc.getConcurrencyMode() != null) {
            return;
        }
        if (this.checkForVersionProperties(desc)) {
            desc.setConcurrencyMode(ConcurrencyMode.VERSION);
        } else {
            desc.setConcurrencyMode(ConcurrencyMode.NONE);
        }
    }

    private boolean checkForVersionProperties(DeployBeanDescriptor<?> desc) {
        boolean hasVersionProperty = false;
        List<DeployBeanProperty> props = desc.propertiesBase();
        for (DeployBeanProperty prop : props) {
            if (!prop.isVersionColumn()) continue;
            hasVersionProperty = true;
        }
        return hasVersionProperty;
    }

    private boolean hasEntityBeanInterface(Class<?> beanClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = beanClass.getInterfaces()) {
            if (!anInterface.equals(EntityBean.class)) continue;
            return true;
        }
        return false;
    }

    private void setEntityBeanClass(DeployBeanDescriptor<?> desc) {
        Class<?> beanClass = desc.getBeanType();
        if (!this.hasEntityBeanInterface(beanClass)) {
            String msg = "Bean " + beanClass + " is not enhanced? Check packages specified in ebean.mf. If you are running in IDEA or Eclipse check that the enhancement plugin is installed. See https://ebean.io/docs/trouble-shooting#not-enhanced";
            throw new BeanNotEnhancedException(msg);
        }
        this.checkInheritedClasses(beanClass);
        ++this.entityBeanCount;
    }

    private void checkInheritedClasses(Class<?> beanClass) {
        Class<?> superclass = beanClass.getSuperclass();
        if (Object.class.equals(superclass)) {
            return;
        }
        if (Model.class.equals(superclass)) {
            return;
        }
        if (!EntityBean.class.isAssignableFrom(superclass)) {
            if (this.isMappedSuperWithNoProperties(superclass)) {
                return;
            }
            throw new BeanNotEnhancedException("Super type " + superclass + " is not enhanced? Check the packages specified in ebean.mf See https://ebean.io/docs/trouble-shooting#not-enhanced");
        }
        this.checkInheritedClasses(superclass);
    }

    private boolean isMappedSuperWithNoProperties(Class<?> beanClass) {
        Field[] fields;
        MappedSuperclass annotation = (MappedSuperclass)AnnotationUtil.get(beanClass, MappedSuperclass.class);
        if (annotation == null) {
            return false;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isAnnotationPresent(Transient.class)) continue;
            return false;
        }
        return true;
    }

    public ChangeLogPrepare getChangeLogPrepare() {
        return this.changeLogPrepare;
    }

    public ChangeLogListener getChangeLogListener() {
        return this.changeLogListener;
    }

    private void addPrimaryKeyJoin(DeployBeanPropertyAssocOne<?> prop) {
        String baseTable = prop.getDesc().getBaseTable();
        DeployTableJoin inverse = prop.getTableJoin().createInverse(baseTable);
        TableJoin inverseJoin = new TableJoin(inverse, prop.getForeignKey());
        DeployBeanInfo<?> target = this.deployInfoMap.get(prop.getTargetType());
        target.setPrimaryKeyJoin(inverseJoin);
    }

    public <A> DeployBeanDescriptor<A> createDeployDescriptor(Class<A> targetType) {
        return new DeployBeanDescriptor<A>(this, targetType, this.config);
    }

    public <A> BeanDescriptor<A> createElementDescriptor(DeployBeanDescriptor<A> elementDescriptor, ManyType manyType, boolean scalar) {
        ElementHelp elementHelp = this.elementHelper(manyType);
        if (manyType.isMap()) {
            if (scalar) {
                return new BeanDescriptorElementScalarMap<A>(this, elementDescriptor, elementHelp);
            }
            return new BeanDescriptorElementEmbeddedMap<A>(this, elementDescriptor, elementHelp);
        }
        if (scalar) {
            return new BeanDescriptorElementScalar<A>(this, elementDescriptor, elementHelp);
        }
        return new BeanDescriptorElementEmbedded<A>(this, elementDescriptor, elementHelp);
    }

    private ElementHelp elementHelper(ManyType manyType) {
        switch (manyType) {
            case LIST: {
                return new ElementHelpList();
            }
            case SET: {
                return new ElementHelpSet();
            }
            case MAP: {
                return new ElementHelpMap();
            }
        }
        throw new IllegalStateException("manyType unexpected " + (Object)((Object)manyType));
    }

    public void visitMetrics(MetricVisitor visitor) {
        for (BeanDescriptor<?> desc : this.immutableDescriptorList) {
            desc.visitMetrics(visitor);
        }
    }

    public List<MetaQueryPlan> queryPlanInit(QueryPlanInit request) {
        ArrayList<MetaQueryPlan> list = new ArrayList<MetaQueryPlan>();
        for (BeanDescriptor<?> desc : this.immutableDescriptorList) {
            desc.queryPlanInit(request, list);
        }
        return list;
    }

    private static final class BeanDescComparator
    implements Comparator<BeanDescriptor<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BeanDescComparator() {
        }

        @Override
        public int compare(BeanDescriptor<?> o1, BeanDescriptor<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

