/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.deploy.BeanProperty;
import java.util.Map;
import java.util.Set;

public class BeanNaturalKey {
    private final String[] naturalKey;
    private final BeanProperty[] props;

    BeanNaturalKey(String[] naturalKey, BeanProperty[] props) {
        this.naturalKey = naturalKey;
        this.props = props;
    }

    public int length() {
        return this.naturalKey.length;
    }

    public boolean matchProperty(String propName) {
        for (String key : this.naturalKey) {
            if (!key.equals(propName)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleProperty() {
        return this.props.length == 1;
    }

    public boolean matchSingleProperty(String propertyName) {
        return this.naturalKey[0].equals(propertyName);
    }

    public boolean matchMultiProperties(Set<String> expressionProperties) {
        if (expressionProperties.size() != this.naturalKey.length) {
            return false;
        }
        for (String key : this.naturalKey) {
            if (expressionProperties.remove(key)) continue;
            return false;
        }
        return expressionProperties.isEmpty();
    }

    public String calculateKey(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (BeanProperty prop : this.props) {
            sb.append(prop.naturalKeyVal(map)).append(";");
        }
        return sb.toString();
    }
}

