/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.IdentityGenerated;
import io.ebean.config.dbplatform.IdType;
import io.ebeaninternal.server.deploy.meta.DeployIdentityMode;

public class IdentityMode {
    public static IdentityMode NONE = new IdentityMode();
    private final IdType type;
    private final IdentityGenerated generated;
    private final int start;
    private final int increment;
    private final int cache;
    private final String sequenceName;
    private final boolean platformDefault;

    public IdentityMode(DeployIdentityMode deploy) {
        this.type = deploy.getIdType();
        this.generated = deploy.getGenerated();
        this.start = deploy.getStart();
        this.increment = deploy.getIncrement();
        this.cache = deploy.getCache();
        this.sequenceName = deploy.getSequenceName();
        this.platformDefault = deploy.isPlatformDefault();
    }

    public IdentityMode(IdType type, IdentityGenerated auto, int start, int increment, int cache, String seqName) {
        this.type = type;
        this.generated = auto;
        this.start = start;
        this.increment = increment;
        this.cache = cache;
        this.sequenceName = seqName;
        this.platformDefault = false;
    }

    private IdentityMode() {
        this.type = null;
        this.generated = IdentityGenerated.AUTO;
        this.start = 0;
        this.increment = 0;
        this.cache = 0;
        this.sequenceName = "";
        this.platformDefault = false;
    }

    public boolean isPlatformDefault() {
        return this.platformDefault;
    }

    public IdType getIdType() {
        return this.type;
    }

    public IdentityGenerated getGenerated() {
        return this.generated;
    }

    public int getStart() {
        return this.start;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getCache() {
        return this.cache;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public boolean isSequence() {
        return this.type == IdType.SEQUENCE;
    }

    public boolean isIdentity() {
        return this.type == IdType.IDENTITY;
    }

    public boolean isExternal() {
        return this.type == IdType.EXTERNAL;
    }

    public boolean isAuto() {
        return this.type == IdType.AUTO;
    }

    public boolean isDatabaseIdentity() {
        return this.type != IdType.EXTERNAL && this.type != IdType.GENERATOR;
    }

    public boolean hasOptions() {
        return this.start > 0 || this.cache > 0 || this.increment > 0;
    }
}

