/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.query.CQueryPlan;

public final class CQueryPlanStats {
    private final CQueryPlan queryPlan;
    private final TimedMetric timedMetric;
    private boolean collected;
    private long lastQueryTime;

    CQueryPlanStats(CQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
        this.timedMetric = queryPlan.createTimedMetric();
    }

    public boolean isEmpty() {
        return this.timedMetric.isEmpty();
    }

    public void add(long timeMicros) {
        this.timedMetric.add(timeMicros);
        this.lastQueryTime = System.currentTimeMillis();
    }

    public void reset() {
        this.timedMetric.reset();
    }

    long getLastQueryTime() {
        return this.lastQueryTime;
    }

    Snapshot getSnapshot(boolean reset) {
        TimedMetricStats collect = this.timedMetric.collect(reset);
        Snapshot snapshot = new Snapshot(this.collected, this.queryPlan, collect);
        this.collected = true;
        return snapshot;
    }

    static class Snapshot
    implements MetaQueryMetric {
        private final boolean collected;
        private final CQueryPlan queryPlan;
        private final TimedMetricStats metrics;

        Snapshot(boolean collected, CQueryPlan queryPlan, TimedMetricStats metrics) {
            this.collected = collected;
            this.queryPlan = queryPlan;
            this.metrics = metrics;
        }

        public String toString() {
            return "label:" + this.getLabel() + " location:" + this.getLocation() + " metrics:" + this.metrics + " sql:" + this.getSql();
        }

        public Class<?> getType() {
            return this.queryPlan.getBeanType();
        }

        public String getLabel() {
            return this.queryPlan.getLabel();
        }

        public String getName() {
            return this.queryPlan.getName();
        }

        public String getLocation() {
            return this.queryPlan.getLocation();
        }

        public long getCount() {
            return this.metrics.getCount();
        }

        public long getTotal() {
            return this.metrics.getTotal();
        }

        public long getMax() {
            return this.metrics.getMax();
        }

        public long getMean() {
            return this.metrics.getMean();
        }

        public String getHash() {
            return this.queryPlan.getHash();
        }

        public String getSql() {
            return this.queryPlan.getSql();
        }

        public boolean initialCollection() {
            return !this.collected;
        }
    }
}

