/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.event.BeanFindController;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQueryEngine;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.persistence.PersistenceException;

public class DefaultOrmQueryEngine
implements OrmQueryEngine {
    private final CQueryEngine queryEngine;
    private final Binder binder;

    public DefaultOrmQueryEngine(CQueryEngine queryEngine, Binder binder) {
        this.queryEngine = queryEngine;
        this.binder = binder;
    }

    @Override
    public <T> PersistenceException translate(OrmQueryRequest<T> request, String bindLog, String sql, SQLException e) {
        return this.queryEngine.translate(request, bindLog, sql, e);
    }

    @Override
    public boolean isMultiValueSupported(Class<?> cls) {
        return this.binder.isMultiValueSupported(cls);
    }

    private <T> void flushJdbcBatchOnQuery(OrmQueryRequest<T> request) {
        Transaction t = request.getTransaction();
        if (t.isFlushOnQuery()) {
            t.flushBatch();
        }
    }

    @Override
    public <T> int delete(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.delete(request);
    }

    @Override
    public <T> int update(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.update(request);
    }

    @Override
    public <T> SpiResultSet findResultSet(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findResultSet(request);
    }

    @Override
    public <T> int findCount(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findCount(request);
    }

    @Override
    public <A> List<A> findIds(OrmQueryRequest<?> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIds(request);
    }

    @Override
    public <A> List<A> findSingleAttributeList(OrmQueryRequest<?> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findSingleAttributeList(request);
    }

    @Override
    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIterate(request);
    }

    @Override
    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findVersions(request);
    }

    @Override
    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.getBeanFinder();
        BeanCollection result = finder != null && finder.isInterceptFindMany(request) ? finder.findMany(request) : this.queryEngine.findMany(request);
        Query query = request.getQuery();
        if (request.isBeanCachePutMany()) {
            BeanDescriptor<T> descriptor = request.getBeanDescriptor();
            Collection c = result.getActualDetails();
            descriptor.cacheBeanPutAll(c);
        }
        request.mergeCacheHits(result);
        if (request.isQueryCachePut()) {
            result.setReadOnly(true);
            request.putToQueryCache(result);
            if (Boolean.FALSE.equals(query.isReadOnly())) {
                result = result.getShallowCopy();
            }
        }
        return result;
    }

    @Override
    public <T> T findId(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.getBeanFinder();
        Object result = finder != null && finder.isInterceptFind(request) ? finder.find(request) : this.queryEngine.find(request);
        if (result != null && request.isBeanCachePut()) {
            request.getBeanDescriptor().cacheBeanPut((EntityBean)result);
        }
        return result;
    }
}

