/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import io.ebean.annotation.DbArray;
import io.ebean.annotation.DbEnumType;
import io.ebean.annotation.DbEnumValue;
import io.ebean.annotation.EnumValue;
import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.JsonConfig;
import io.ebean.config.PlatformConfig;
import io.ebean.config.ScalarTypeConverter;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ExtraTypeFactory;
import io.ebean.core.type.ScalarType;
import io.ebean.types.Cidr;
import io.ebean.types.Inet;
import io.ebean.util.AnnotationUtil;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.GeoTypeProvider;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import io.ebeaninternal.server.type.AttributeConverterAdapter;
import io.ebeaninternal.server.type.DefaultTypeFactory;
import io.ebeaninternal.server.type.EnumToDbValueMap;
import io.ebeaninternal.server.type.GeoTypeBinder;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.ScalarTypeArrayList;
import io.ebeaninternal.server.type.ScalarTypeArrayListH2;
import io.ebeaninternal.server.type.ScalarTypeArraySet;
import io.ebeaninternal.server.type.ScalarTypeArraySetH2;
import io.ebeaninternal.server.type.ScalarTypeBigDecimal;
import io.ebeaninternal.server.type.ScalarTypeBool;
import io.ebeaninternal.server.type.ScalarTypeByte;
import io.ebeaninternal.server.type.ScalarTypeBytesBinary;
import io.ebeaninternal.server.type.ScalarTypeBytesBlob;
import io.ebeaninternal.server.type.ScalarTypeBytesLongVarbinary;
import io.ebeaninternal.server.type.ScalarTypeBytesVarbinary;
import io.ebeaninternal.server.type.ScalarTypeChar;
import io.ebeaninternal.server.type.ScalarTypeCharArray;
import io.ebeaninternal.server.type.ScalarTypeCidr;
import io.ebeaninternal.server.type.ScalarTypeClass;
import io.ebeaninternal.server.type.ScalarTypeClob;
import io.ebeaninternal.server.type.ScalarTypeCurrency;
import io.ebeaninternal.server.type.ScalarTypeDate;
import io.ebeaninternal.server.type.ScalarTypeDayOfWeek;
import io.ebeaninternal.server.type.ScalarTypeDouble;
import io.ebeaninternal.server.type.ScalarTypeDuration;
import io.ebeaninternal.server.type.ScalarTypeDurationWithNanos;
import io.ebeaninternal.server.type.ScalarTypeEnum;
import io.ebeaninternal.server.type.ScalarTypeEnumStandard;
import io.ebeaninternal.server.type.ScalarTypeEnumWithMapping;
import io.ebeaninternal.server.type.ScalarTypeFile;
import io.ebeaninternal.server.type.ScalarTypeFloat;
import io.ebeaninternal.server.type.ScalarTypeInet;
import io.ebeaninternal.server.type.ScalarTypeInetAddress;
import io.ebeaninternal.server.type.ScalarTypeInetAddressPostgres;
import io.ebeaninternal.server.type.ScalarTypeInstant;
import io.ebeaninternal.server.type.ScalarTypeInteger;
import io.ebeaninternal.server.type.ScalarTypeJodaDateMidnight;
import io.ebeaninternal.server.type.ScalarTypeJodaDateTime;
import io.ebeaninternal.server.type.ScalarTypeJodaLocalDate;
import io.ebeaninternal.server.type.ScalarTypeJodaLocalDateTime;
import io.ebeaninternal.server.type.ScalarTypeJodaLocalTime;
import io.ebeaninternal.server.type.ScalarTypeJodaLocalTimeUTC;
import io.ebeaninternal.server.type.ScalarTypeJodaPeriod;
import io.ebeaninternal.server.type.ScalarTypeJsonList;
import io.ebeaninternal.server.type.ScalarTypeJsonMap;
import io.ebeaninternal.server.type.ScalarTypeJsonNode;
import io.ebeaninternal.server.type.ScalarTypeJsonNodePostgres;
import io.ebeaninternal.server.type.ScalarTypeJsonObjectMapper;
import io.ebeaninternal.server.type.ScalarTypeJsonSet;
import io.ebeaninternal.server.type.ScalarTypeLocalDate;
import io.ebeaninternal.server.type.ScalarTypeLocalDateTime;
import io.ebeaninternal.server.type.ScalarTypeLocalTime;
import io.ebeaninternal.server.type.ScalarTypeLocalTimeWithNanos;
import io.ebeaninternal.server.type.ScalarTypeLocale;
import io.ebeaninternal.server.type.ScalarTypeLong;
import io.ebeaninternal.server.type.ScalarTypeLongVarchar;
import io.ebeaninternal.server.type.ScalarTypeMonth;
import io.ebeaninternal.server.type.ScalarTypeMonthDay;
import io.ebeaninternal.server.type.ScalarTypeOffsetDateTime;
import io.ebeaninternal.server.type.ScalarTypeOffsetTime;
import io.ebeaninternal.server.type.ScalarTypePath;
import io.ebeaninternal.server.type.ScalarTypePeriod;
import io.ebeaninternal.server.type.ScalarTypePostgresHstore;
import io.ebeaninternal.server.type.ScalarTypeShort;
import io.ebeaninternal.server.type.ScalarTypeString;
import io.ebeaninternal.server.type.ScalarTypeTime;
import io.ebeaninternal.server.type.ScalarTypeTimeZone;
import io.ebeaninternal.server.type.ScalarTypeTimestamp;
import io.ebeaninternal.server.type.ScalarTypeURI;
import io.ebeaninternal.server.type.ScalarTypeURL;
import io.ebeaninternal.server.type.ScalarTypeUUIDBase;
import io.ebeaninternal.server.type.ScalarTypeUUIDBinary;
import io.ebeaninternal.server.type.ScalarTypeUUIDNative;
import io.ebeaninternal.server.type.ScalarTypeUUIDVarchar;
import io.ebeaninternal.server.type.ScalarTypeWrapper;
import io.ebeaninternal.server.type.ScalarTypeYear;
import io.ebeaninternal.server.type.ScalarTypeYearMonthDate;
import io.ebeaninternal.server.type.ScalarTypeZoneId;
import io.ebeaninternal.server.type.ScalarTypeZoneOffset;
import io.ebeaninternal.server.type.ScalarTypeZonedDateTime;
import io.ebeaninternal.server.type.TypeManager;
import io.ebeaninternal.server.type.TypeReflectHelper;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.AttributeConverter;
import javax.persistence.EnumType;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTypeManager
implements TypeManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTypeManager.class);
    private final ConcurrentHashMap<Class<?>, ScalarType<?>> typeMap;
    private final ConcurrentHashMap<Integer, ScalarType<?>> nativeMap;
    private final ConcurrentHashMap<String, ScalarType<?>> logicalMap;
    private final DefaultTypeFactory extraTypeFactory;
    private final ScalarType<?> hstoreType = new ScalarTypePostgresHstore();
    private final ScalarTypeFile fileType = new ScalarTypeFile();
    private final ScalarType<?> charType = new ScalarTypeChar();
    private final ScalarType<?> charArrayType = new ScalarTypeCharArray();
    private final ScalarType<?> longVarcharType = new ScalarTypeLongVarchar();
    private final ScalarType<?> clobType = new ScalarTypeClob();
    private final ScalarType<?> byteType = new ScalarTypeByte();
    private final ScalarType<?> binaryType = new ScalarTypeBytesBinary();
    private final ScalarType<?> blobType = new ScalarTypeBytesBlob();
    private final ScalarType<?> varbinaryType = new ScalarTypeBytesVarbinary();
    private final ScalarType<?> longVarbinaryType = new ScalarTypeBytesLongVarbinary();
    private final ScalarType<?> shortType = new ScalarTypeShort();
    private final ScalarType<?> integerType = ScalarTypeInteger.INSTANCE;
    private final ScalarType<?> longType = new ScalarTypeLong();
    private final ScalarType<?> doubleType = new ScalarTypeDouble();
    private final ScalarType<?> floatType = new ScalarTypeFloat();
    private final ScalarType<?> bigDecimalType = new ScalarTypeBigDecimal();
    private final ScalarType<?> timeType = new ScalarTypeTime();
    private final ScalarType<?> urlType = new ScalarTypeURL();
    private final ScalarType<?> uriType = new ScalarTypeURI();
    private final ScalarType<?> localeType = new ScalarTypeLocale();
    private final ScalarType<?> currencyType = new ScalarTypeCurrency();
    private final ScalarType<?> timeZoneType = new ScalarTypeTimeZone();
    private final ScalarType<?> stringType = ScalarTypeString.INSTANCE;
    private final ScalarType<?> classType = new ScalarTypeClass();
    private final JsonConfig.DateTime jsonDateTime;
    private final JsonConfig.Date jsonDate;
    private final Object objectMapper;
    private final boolean objectMapperPresent;
    private final boolean postgres;
    private final boolean offlineMigrationGeneration;
    private final EnumType defaultEnumType;
    private ScalarType<?> jsonNodeClob;
    private ScalarType<?> jsonNodeBlob;
    private ScalarType<?> jsonNodeVarchar;
    private ScalarType<?> jsonNodeJson;
    private ScalarType<?> jsonNodeJsonb;
    private final PlatformArrayTypeFactory arrayTypeListFactory;
    private final PlatformArrayTypeFactory arrayTypeSetFactory;
    private GeoTypeBinder geoTypeBinder;

    public DefaultTypeManager(DatabaseConfig config, BootupClasses bootupClasses) {
        this.jsonDateTime = config.getJsonDateTime();
        this.jsonDate = config.getJsonDate();
        this.typeMap = new ConcurrentHashMap();
        this.nativeMap = new ConcurrentHashMap();
        this.logicalMap = new ConcurrentHashMap();
        this.objectMapperPresent = config.getClassLoadConfig().isJacksonObjectMapperPresent();
        this.objectMapper = this.objectMapperPresent ? this.initObjectMapper(config) : null;
        this.extraTypeFactory = new DefaultTypeFactory(config);
        this.postgres = this.isPostgres(config.getDatabasePlatform());
        this.arrayTypeListFactory = this.arrayTypeListFactory(config.getDatabasePlatform());
        this.arrayTypeSetFactory = this.arrayTypeSetFactory(config.getDatabasePlatform());
        this.offlineMigrationGeneration = DbOffline.isGenerateMigration();
        this.defaultEnumType = config.getDefaultEnumType();
        this.initialiseStandard(config);
        this.initialiseJavaTimeTypes(config);
        this.initialiseJodaTypes(config);
        this.initialiseJacksonTypes(config);
        this.loadTypesFromProviders(config, this.objectMapper);
        this.loadGeoTypeBinder(config);
        if (bootupClasses != null) {
            this.initialiseCustomScalarTypes(bootupClasses);
            this.initialiseScalarConverters(bootupClasses);
            this.initialiseAttributeConverters(bootupClasses);
        }
    }

    private void loadGeoTypeBinder(DatabaseConfig config) {
        GeoTypeProvider provider = (GeoTypeProvider)config.service(GeoTypeProvider.class);
        if (provider != null) {
            this.geoTypeBinder = provider.createBinder(config);
        }
    }

    private PlatformArrayTypeFactory arrayTypeListFactory(DatabasePlatform databasePlatform) {
        if (databasePlatform.isNativeArrayType()) {
            return ScalarTypeArrayList.factory();
        }
        if (databasePlatform.isPlatform(Platform.H2)) {
            return ScalarTypeArrayListH2.factory();
        }
        return null;
    }

    private PlatformArrayTypeFactory arrayTypeSetFactory(DatabasePlatform databasePlatform) {
        if (databasePlatform.isNativeArrayType()) {
            return ScalarTypeArraySet.factory();
        }
        if (databasePlatform.isPlatform(Platform.H2)) {
            return ScalarTypeArraySetH2.factory();
        }
        return null;
    }

    private void loadTypesFromProviders(DatabaseConfig config, Object objectMapper) {
        ServiceLoader<ExtraTypeFactory> factories = ServiceLoader.load(ExtraTypeFactory.class);
        Iterator<ExtraTypeFactory> iterator = factories.iterator();
        if (iterator.hasNext()) {
            ExtraTypeFactory plugin = iterator.next();
            List types = plugin.createTypes(config, objectMapper);
            for (ScalarType type : types) {
                logger.debug("adding ScalarType {}", type.getClass());
                this.addCustomType(type);
            }
        }
    }

    private boolean isPostgres(DatabasePlatform databasePlatform) {
        return databasePlatform.getPlatform().base() == Platform.POSTGRES;
    }

    @Override
    public void add(ScalarType<?> scalarType) {
        this.typeMap.put(scalarType.getType(), scalarType);
        this.logAdd(scalarType);
    }

    @Override
    public void addEnumType(ScalarType<?> scalarType, Class<? extends Enum> enumClass) {
        HashSet mappedClasses = new HashSet();
        mappedClasses.add(enumClass);
        for (Object value : EnumSet.allOf(enumClass).toArray()) {
            mappedClasses.add(value.getClass());
        }
        for (Class clazz : mappedClasses) {
            this.typeMap.put(clazz, scalarType);
        }
        this.logAdd(scalarType);
    }

    private void logAdd(ScalarType<?> scalarType) {
        if (logger.isTraceEnabled()) {
            String msg = "ScalarType register [" + scalarType.getClass().getName() + "]";
            msg = msg + " for [" + scalarType.getType().getName() + "]";
            logger.trace(msg);
        }
    }

    @Override
    public ScalarType<?> getScalarType(String cast) {
        return this.logicalMap.get(cast);
    }

    @Override
    public ScalarType<?> getScalarType(int jdbcType) {
        return this.nativeMap.get(jdbcType);
    }

    @Override
    public ScalarType<?> getScalarType(Class<?> type) {
        ScalarType<?> found = this.typeMap.get(type);
        if (found == null) {
            if (type.getName().equals("org.joda.time.LocalTime")) {
                throw new IllegalStateException("ScalarType of Joda LocalTime not defined. You need to set DatabaseConfig.jodaLocalTimeMode to either 'normal' or 'utc'.  UTC is the old mode using UTC timezone but local time zone is now preferred as 'normal' mode.");
            }
            found = this.checkInterfaceTypes(type);
        }
        return found;
    }

    private ScalarType<?> checkInterfaceTypes(Class<?> type) {
        if (Path.class.isAssignableFrom(type)) {
            return this.typeMap.get(Path.class);
        }
        return null;
    }

    @Override
    public GeoTypeBinder getGeoTypeBinder() {
        return this.geoTypeBinder;
    }

    @Override
    public ScalarType<?> getDbMapScalarType() {
        return this.postgres ? this.hstoreType : ScalarTypeJsonMap.typeFor(false, 12);
    }

    @Override
    public ScalarType<?> getArrayScalarType(Class<?> type, DbArray dbArray, Type genericType, boolean nullable) {
        Type valueType = this.getValueType(genericType);
        if (type.equals(List.class)) {
            return this.getArrayScalarTypeList(valueType, nullable);
        }
        if (type.equals(Set.class)) {
            return this.getArrayScalarTypeSet(valueType, nullable);
        }
        throw new IllegalStateException("Type [" + type + "] not supported for @DbArray");
    }

    private ScalarType<?> getArrayScalarTypeSet(Type valueType, boolean nullable) {
        if (this.arrayTypeSetFactory != null) {
            if (this.isEnumType(valueType)) {
                return this.arrayTypeSetFactory.typeForEnum(this.createEnumScalarType(this.asEnumClass(valueType), null), nullable);
            }
            return this.arrayTypeSetFactory.typeFor(valueType, nullable);
        }
        return new ScalarTypeJsonSet.Varchar(this.getDocType(valueType), nullable);
    }

    private ScalarType<?> getArrayScalarTypeList(Type valueType, boolean nullable) {
        if (this.arrayTypeListFactory != null) {
            if (this.isEnumType(valueType)) {
                return this.arrayTypeListFactory.typeForEnum(this.createEnumScalarType(this.asEnumClass(valueType), null), nullable);
            }
            return this.arrayTypeListFactory.typeFor(valueType, nullable);
        }
        return new ScalarTypeJsonList.Varchar(this.getDocType(valueType), nullable);
    }

    private Class<? extends Enum<?>> asEnumClass(Type valueType) {
        return TypeReflectHelper.asEnumClass(valueType);
    }

    private boolean isEnumType(Type valueType) {
        return TypeReflectHelper.isEnumType(valueType);
    }

    @Override
    public ScalarType<?> getJsonScalarType(DeployBeanProperty prop, int dbType, int dbLength) {
        boolean hasJacksonAnnotations;
        Class<?> type = prop.getPropertyType();
        Type genericType = prop.getGenericType();
        boolean bl = hasJacksonAnnotations = this.objectMapperPresent && this.checkJacksonAnnotations(prop);
        if (type.equals(List.class)) {
            DocPropertyType docType = this.getDocType(genericType);
            if (!hasJacksonAnnotations && this.isValueTypeSimple(genericType)) {
                return ScalarTypeJsonList.typeFor(this.postgres, dbType, docType, prop.isNullable());
            }
            return this.createJsonObjectMapperType(prop, dbType, docType);
        }
        if (type.equals(Set.class)) {
            DocPropertyType docType = this.getDocType(genericType);
            if (!hasJacksonAnnotations && this.isValueTypeSimple(genericType)) {
                return ScalarTypeJsonSet.typeFor(this.postgres, dbType, docType, prop.isNullable());
            }
            return this.createJsonObjectMapperType(prop, dbType, docType);
        }
        if (type.equals(Map.class)) {
            if (!hasJacksonAnnotations && this.isMapValueTypeObject(genericType)) {
                return ScalarTypeJsonMap.typeFor(this.postgres, dbType);
            }
            return this.createJsonObjectMapperType(prop, dbType, DocPropertyType.OBJECT);
        }
        if (this.objectMapperPresent && type.equals(JsonNode.class)) {
            switch (dbType) {
                case 12: {
                    return this.jsonNodeVarchar;
                }
                case 2004: {
                    return this.jsonNodeBlob;
                }
                case 2005: {
                    return this.jsonNodeClob;
                }
                case 5002: {
                    return this.jsonNodeJsonb;
                }
            }
            return this.jsonNodeJson;
        }
        return this.createJsonObjectMapperType(prop, dbType, DocPropertyType.OBJECT);
    }

    private boolean checkJacksonAnnotations(DeployBeanProperty prop) {
        return prop.getMetaAnnotation(JacksonAnnotation.class) != null;
    }

    private DocPropertyType getDocType(Type genericType) {
        ScalarType<?> found;
        if (genericType instanceof Class && (found = this.typeMap.get(genericType)) != null) {
            return found.getDocType();
        }
        return DocPropertyType.OBJECT;
    }

    private boolean isValueTypeSimple(Type collectionType) {
        Type typeArg = TypeReflectHelper.getValueType(collectionType);
        return String.class.equals((Object)typeArg) || Long.class.equals((Object)typeArg);
    }

    private Type getValueType(Type collectionType) {
        return TypeReflectHelper.getValueType(collectionType);
    }

    private boolean isMapValueTypeObject(Type genericType) {
        Type[] typeArgs = ((ParameterizedType)genericType).getActualTypeArguments();
        return Object.class.equals((Object)typeArgs[1]) || "?".equals(typeArgs[1].toString());
    }

    private ScalarType<?> createJsonObjectMapperType(DeployBeanProperty prop, int dbType, DocPropertyType docType) {
        Class<?> type = prop.getPropertyType();
        if (this.objectMapper == null) {
            throw new IllegalArgumentException("Type [" + type + "] unsupported for @DbJson mapping - Jackson ObjectMapper not present");
        }
        return ScalarTypeJsonObjectMapper.createTypeFor(this.postgres, (AnnotatedField)prop.getJacksonField(), (ObjectMapper)this.objectMapper, dbType, docType);
    }

    @Override
    public ScalarType<?> getScalarType(Class<?> type, int jdbcType) {
        if (File.class.equals(type)) {
            return this.fileType;
        }
        ScalarType<?> scalarType = this.getLobTypes(jdbcType);
        if (scalarType != null) {
            return scalarType;
        }
        scalarType = this.typeMap.get(type);
        if (scalarType != null && (jdbcType == 0 || scalarType.getJdbcType() == jdbcType)) {
            return scalarType;
        }
        if (type.equals(Date.class)) {
            return this.extraTypeFactory.createUtilDate(this.jsonDateTime, this.jsonDate, jdbcType);
        }
        if (type.equals(Calendar.class)) {
            return this.extraTypeFactory.createCalendar(this.jsonDateTime, jdbcType);
        }
        throw new IllegalArgumentException("Unmatched ScalarType for " + type + " jdbcType:" + jdbcType);
    }

    private ScalarType<?> getLobTypes(int jdbcType) {
        return this.getScalarType(jdbcType);
    }

    public Object convert(Object value, int toJdbcType) {
        if (value == null) {
            return null;
        }
        ScalarType<?> type = this.nativeMap.get(toJdbcType);
        if (type != null) {
            return type.toJdbcType(value);
        }
        return value;
    }

    boolean isIntegerType(String s) {
        if (this.isLeadingZeros(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isLeadingZeros(String s) {
        return s.length() > 1 && s.charAt(0) == '0';
    }

    private ScalarTypeEnum<?> createEnumScalarType2(Class<?> enumType) {
        Field[] fields;
        boolean integerType = true;
        LinkedHashMap<String, String> nameValueMap = new LinkedHashMap<String, String>();
        for (Field field : fields = enumType.getDeclaredFields()) {
            EnumValue enumValue = (EnumValue)AnnotationUtil.get((AnnotatedElement)field, EnumValue.class);
            if (enumValue == null) continue;
            nameValueMap.put(field.getName(), enumValue.value());
            if (!integerType || this.isIntegerType(enumValue.value())) continue;
            integerType = false;
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, 0);
    }

    @Override
    public ScalarType<?> createEnumScalarType(Class<? extends Enum<?>> enumType, EnumType type) {
        ScalarType<?> scalarType = this.getScalarType(enumType);
        if (scalarType instanceof ScalarTypeWrapper) {
            return scalarType;
        }
        ScalarTypeEnum<?> scalarEnum = (ScalarTypeEnum<?>)scalarType;
        if (scalarEnum != null && !scalarEnum.isOverrideBy(type)) {
            if (type != null && !scalarEnum.isCompatible(type)) {
                throw new IllegalStateException("Error mapping Enum type:" + enumType + " It is mapped using 2 different modes when only one is supported (ORDINAL, STRING or an Ebean mapping)");
            }
            return scalarEnum;
        }
        scalarEnum = this.createEnumScalarTypePerExtentions(enumType);
        if (scalarEnum == null) {
            scalarEnum = this.createEnumScalarTypePerSpec(enumType, type);
        }
        this.addEnumType(scalarEnum, enumType);
        return scalarEnum;
    }

    private ScalarTypeEnum<?> createEnumScalarTypePerSpec(Class<?> enumType, EnumType type) {
        if (type == null) {
            if (this.defaultEnumType == EnumType.ORDINAL) {
                return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
            }
            return new ScalarTypeEnumStandard.StringEnum(enumType);
        }
        if (type == EnumType.ORDINAL) {
            return new ScalarTypeEnumStandard.OrdinalEnum(enumType);
        }
        return new ScalarTypeEnumStandard.StringEnum(enumType);
    }

    private ScalarTypeEnum<?> createEnumScalarTypePerExtentions(Class<? extends Enum<?>> enumType) {
        Method[] methods;
        for (Method method : methods = enumType.getMethods()) {
            DbEnumValue dbValue = (DbEnumValue)AnnotationUtil.get((AnnotatedElement)method, DbEnumValue.class);
            if (dbValue == null) continue;
            boolean integerValues = DbEnumType.INTEGER == dbValue.storage();
            return this.createEnumScalarTypeDbValue(enumType, method, integerValues, dbValue.length());
        }
        return this.createEnumScalarType2(enumType);
    }

    private ScalarTypeEnum<?> createEnumScalarTypeDbValue(Class<? extends Enum<?>> enumType, Method method, boolean integerType, int length) {
        Enum<?>[] enumConstants;
        LinkedHashMap<String, String> nameValueMap = new LinkedHashMap<String, String>();
        for (Enum<?> enumConstant : enumConstants = enumType.getEnumConstants()) {
            try {
                Object value = method.invoke(enumConstant, new Object[0]);
                nameValueMap.put(enumConstant.name(), value.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error trying to invoke DbEnumValue method on " + enumConstant, e);
            }
        }
        if (nameValueMap.isEmpty()) {
            return null;
        }
        return this.createEnumScalarType(enumType, nameValueMap, integerType, length);
    }

    private ScalarTypeEnum<?> createEnumScalarType(Class enumType, Map<String, String> nameValueMap, boolean integerType, int dbColumnLength) {
        EnumToDbValueMap<?> beanDbMap = EnumToDbValueMap.create(integerType);
        int maxValueLen = 0;
        for (Map.Entry<String, String> entry : nameValueMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            maxValueLen = Math.max(maxValueLen, value.length());
            Object enumValue = Enum.valueOf(enumType, name.trim());
            beanDbMap.add(enumValue, value, name.trim());
        }
        if (dbColumnLength == 0 && !integerType) {
            dbColumnLength = maxValueLen;
        }
        return new ScalarTypeEnumWithMapping(beanDbMap, enumType, dbColumnLength);
    }

    private void initialiseCustomScalarTypes(BootupClasses bootupClasses) {
        for (Class<ScalarType<?>> cls : bootupClasses.getScalarTypes()) {
            try {
                ScalarType<?> scalarType;
                if (this.objectMapper == null) {
                    scalarType = cls.newInstance();
                } else {
                    try {
                        Constructor<ScalarType<?>> constructor = cls.getConstructor(ObjectMapper.class);
                        scalarType = constructor.newInstance((ObjectMapper)this.objectMapper);
                    }
                    catch (NoSuchMethodException e) {
                        scalarType = cls.newInstance();
                    }
                }
                this.addCustomType(scalarType);
            }
            catch (Exception e) {
                String msg = "Error loading ScalarType [" + cls.getName() + "]";
                logger.error(msg, (Throwable)e);
            }
        }
    }

    private void addCustomType(ScalarType<?> scalarType) {
        this.add(scalarType);
    }

    private Object initObjectMapper(DatabaseConfig config) {
        Object objectMapper = config.getObjectMapper();
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            config.setObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    private void initialiseScalarConverters(BootupClasses bootupClasses) {
        List<Class<ScalarTypeConverter<?, ?>>> foundTypes = bootupClasses.getScalarConverters();
        for (Class<ScalarTypeConverter<?, ?>> foundType : foundTypes) {
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(foundType, ScalarTypeConverter.class);
                if (paramTypes.length != 2) {
                    throw new IllegalStateException("Expected 2 generics paramtypes but got: " + Arrays.toString(paramTypes));
                }
                Class<?> logicalType = paramTypes[0];
                Class<?> persistType = paramTypes[1];
                ScalarType<?> wrappedType = this.getScalarType(persistType);
                if (wrappedType == null) {
                    throw new IllegalStateException("Could not find ScalarType for: " + paramTypes[1]);
                }
                ScalarTypeConverter<?, ?> converter = foundType.newInstance();
                ScalarTypeWrapper stw = new ScalarTypeWrapper(logicalType, wrappedType, converter);
                logger.debug("Register ScalarTypeWrapper from {} -> {} using:{}", new Object[]{logicalType, persistType, foundType});
                this.add(stw);
            }
            catch (Exception e) {
                logger.error("Error registering ScalarTypeConverter [" + foundType.getName() + "]", (Throwable)e);
            }
        }
    }

    private void initialiseAttributeConverters(BootupClasses bootupClasses) {
        List<Class<AttributeConverter<?, ?>>> foundTypes = bootupClasses.getAttributeConverters();
        for (Class<AttributeConverter<?, ?>> foundType : foundTypes) {
            try {
                Object[] paramTypes = TypeReflectHelper.getParams(foundType, AttributeConverter.class);
                if (paramTypes.length != 2) {
                    throw new IllegalStateException("Expected 2 generics paramtypes but got: " + Arrays.toString(paramTypes));
                }
                Class<?> logicalType = paramTypes[0];
                Class<?> persistType = paramTypes[1];
                ScalarType<?> wrappedType = this.getScalarType(persistType);
                if (wrappedType == null) {
                    throw new IllegalStateException("Could not find ScalarType for: " + paramTypes[1]);
                }
                AttributeConverter<?, ?> converter = foundType.newInstance();
                ScalarTypeWrapper stw = new ScalarTypeWrapper(logicalType, wrappedType, new AttributeConverterAdapter(converter));
                logger.debug("Register ScalarTypeWrapper from {} -> {} using:{}", new Object[]{logicalType, persistType, foundType});
                this.add(stw);
            }
            catch (Exception e) {
                logger.error("Error registering AttributeConverter [" + foundType.getName() + "]", (Throwable)e);
            }
        }
    }

    private void initialiseJacksonTypes(DatabaseConfig config) {
        if (this.objectMapper != null) {
            logger.trace("Registering JsonNode type support");
            ObjectMapper mapper = (ObjectMapper)this.objectMapper;
            this.jsonNodeClob = new ScalarTypeJsonNode.Clob(mapper);
            this.jsonNodeBlob = new ScalarTypeJsonNode.Blob(mapper);
            this.jsonNodeVarchar = new ScalarTypeJsonNode.Varchar(mapper);
            this.jsonNodeJson = this.jsonNodeClob;
            this.jsonNodeJsonb = this.jsonNodeClob;
            if (this.isPostgres(config.getDatabasePlatform())) {
                this.jsonNodeJson = new ScalarTypeJsonNodePostgres.JSON(mapper);
                this.jsonNodeJsonb = new ScalarTypeJsonNodePostgres.JSONB(mapper);
            }
            this.typeMap.put(JsonNode.class, this.jsonNodeJson);
        }
    }

    private void initialiseJavaTimeTypes(DatabaseConfig config) {
        this.typeMap.put(Path.class, new ScalarTypePath());
        this.addType(Period.class, new ScalarTypePeriod());
        this.addType(LocalDate.class, new ScalarTypeLocalDate(this.jsonDate));
        this.addType(java.time.LocalDateTime.class, new ScalarTypeLocalDateTime(this.jsonDateTime));
        this.addType(OffsetDateTime.class, new ScalarTypeOffsetDateTime(this.jsonDateTime));
        this.addType(ZonedDateTime.class, new ScalarTypeZonedDateTime(this.jsonDateTime));
        this.addType(Instant.class, new ScalarTypeInstant(this.jsonDateTime));
        this.addType(DayOfWeek.class, new ScalarTypeDayOfWeek());
        this.addType(Month.class, new ScalarTypeMonth());
        this.addType(Year.class, new ScalarTypeYear());
        this.addType(YearMonth.class, new ScalarTypeYearMonthDate(this.jsonDate));
        this.addType(MonthDay.class, new ScalarTypeMonthDay());
        this.addType(OffsetTime.class, new ScalarTypeOffsetTime());
        this.addType(ZoneId.class, new ScalarTypeZoneId());
        this.addType(ZoneOffset.class, new ScalarTypeZoneOffset());
        boolean localTimeNanos = config.isLocalTimeWithNanos();
        this.addType(java.time.LocalTime.class, localTimeNanos ? new ScalarTypeLocalTimeWithNanos() : new ScalarTypeLocalTime());
        boolean durationNanos = config.isDurationWithNanos();
        this.addType(Duration.class, durationNanos ? new ScalarTypeDurationWithNanos() : new ScalarTypeDuration());
    }

    private void addType(Class<?> clazz, ScalarType<?> scalarType) {
        this.typeMap.put(clazz, scalarType);
        this.logicalMap.putIfAbsent(clazz.getSimpleName(), scalarType);
    }

    private void initialiseJodaTypes(DatabaseConfig config) {
        if (config.getClassLoadConfig().isJodaTimePresent()) {
            logger.debug("Registering Joda data types");
            this.addType(LocalDateTime.class, new ScalarTypeJodaLocalDateTime(this.jsonDateTime));
            this.addType(DateTime.class, new ScalarTypeJodaDateTime(this.jsonDateTime));
            this.addType(org.joda.time.LocalDate.class, new ScalarTypeJodaLocalDate(this.jsonDate));
            this.addType(DateMidnight.class, new ScalarTypeJodaDateMidnight(this.jsonDate));
            this.addType(org.joda.time.Period.class, new ScalarTypeJodaPeriod());
            String jodaLocalTimeMode = config.getJodaLocalTimeMode();
            if ("normal".equalsIgnoreCase(jodaLocalTimeMode)) {
                this.addType(LocalTime.class, new ScalarTypeJodaLocalTime());
                logger.debug("registered ScalarTypeJodaLocalTime");
            } else if ("utc".equalsIgnoreCase(jodaLocalTimeMode)) {
                this.addType(LocalTime.class, new ScalarTypeJodaLocalTimeUTC());
                logger.debug("registered ScalarTypeJodaLocalTimeUTC");
            }
        }
    }

    private void initialiseStandard(DatabaseConfig config) {
        DatabasePlatform databasePlatform = config.getDatabasePlatform();
        int platformClobType = databasePlatform.getClobDbType();
        int platformBlobType = databasePlatform.getBlobDbType();
        this.nativeMap.put(5000, this.hstoreType);
        ScalarType<Date> utilDateType = this.extraTypeFactory.createUtilDate(this.jsonDateTime, this.jsonDate);
        this.addType(Date.class, utilDateType);
        ScalarType<Calendar> calType = this.extraTypeFactory.createCalendar(this.jsonDateTime);
        this.addType(Calendar.class, calType);
        ScalarType<BigInteger> mathBigIntType = this.extraTypeFactory.createMathBigInteger();
        this.addType(BigInteger.class, mathBigIntType);
        ScalarTypeBool booleanType = this.extraTypeFactory.createBoolean();
        this.addType(Boolean.class, booleanType);
        this.addType(Boolean.TYPE, booleanType);
        databasePlatform.setDbTrueLiteral(booleanType.getDbTrueLiteral());
        databasePlatform.setDbFalseLiteral(booleanType.getDbFalseLiteral());
        this.nativeMap.put(16, booleanType);
        if (booleanType.getJdbcType() == -7) {
            this.nativeMap.put(-7, booleanType);
        }
        PlatformConfig.DbUuid dbUuid = config.getPlatformConfig().getDbUuid();
        if (this.offlineMigrationGeneration || databasePlatform.isNativeUuidType() && dbUuid.useNativeType()) {
            this.addType(UUID.class, new ScalarTypeUUIDNative());
        } else {
            ScalarTypeUUIDBase uuidType = dbUuid.useBinary() ? new ScalarTypeUUIDBinary(dbUuid.useBinaryOptimized()) : new ScalarTypeUUIDVarchar();
            this.addType(UUID.class, uuidType);
        }
        if (this.offlineMigrationGeneration || this.postgres && !config.getPlatformConfig().isDatabaseInetAddressVarchar()) {
            this.addInetAddressType(new ScalarTypeInetAddressPostgres());
        } else {
            this.addInetAddressType(new ScalarTypeInetAddress());
        }
        if (this.offlineMigrationGeneration || this.postgres) {
            this.addType(Cidr.class, new ScalarTypeCidr.Postgres());
            this.addType(Inet.class, new ScalarTypeInet.Postgres());
        } else {
            this.addType(Cidr.class, new ScalarTypeCidr.Varchar());
            this.addType(Inet.class, new ScalarTypeInet.Varchar());
        }
        this.addType(File.class, this.fileType);
        this.addType(Locale.class, this.localeType);
        this.addType(Currency.class, this.currencyType);
        this.addType(TimeZone.class, this.timeZoneType);
        this.addType(URL.class, this.urlType);
        this.addType(URI.class, this.uriType);
        this.addType(char[].class, this.charArrayType);
        this.addType(Character.TYPE, this.charType);
        this.addType(String.class, this.stringType);
        this.nativeMap.put(12, this.stringType);
        this.nativeMap.put(1, this.stringType);
        this.nativeMap.put(-1, this.longVarcharType);
        this.addType(Class.class, this.classType);
        if (platformClobType == 2005) {
            this.nativeMap.put(2005, this.clobType);
        } else {
            ScalarType<?> platClobScalarType = this.nativeMap.get(platformClobType);
            if (platClobScalarType == null) {
                throw new IllegalArgumentException("Type for dbPlatform clobType [" + this.clobType + "] not found.");
            }
            this.nativeMap.put(2005, platClobScalarType);
        }
        this.addType(byte[].class, this.varbinaryType);
        this.nativeMap.put(-2, this.binaryType);
        this.nativeMap.put(-3, this.varbinaryType);
        this.nativeMap.put(-4, this.longVarbinaryType);
        if (platformBlobType == 2004) {
            this.nativeMap.put(2004, this.blobType);
        } else {
            ScalarType<?> platBlobScalarType = this.nativeMap.get(platformBlobType);
            if (platBlobScalarType == null) {
                throw new IllegalArgumentException("Type for dbPlatform blobType [" + this.blobType + "] not found.");
            }
            this.nativeMap.put(2004, platBlobScalarType);
        }
        this.addType(Byte.class, this.byteType);
        this.addType(Byte.TYPE, this.byteType);
        this.nativeMap.put(-6, this.byteType);
        this.addType(Short.class, this.shortType);
        this.addType(Short.TYPE, this.shortType);
        this.nativeMap.put(5, this.shortType);
        this.addType(Integer.class, this.integerType);
        this.addType(Integer.TYPE, this.integerType);
        this.nativeMap.put(4, this.integerType);
        this.addType(Long.class, this.longType);
        this.addType(Long.TYPE, this.longType);
        this.nativeMap.put(-5, this.longType);
        this.addType(Double.class, this.doubleType);
        this.addType(Double.TYPE, this.doubleType);
        this.nativeMap.put(6, this.doubleType);
        this.nativeMap.put(8, this.doubleType);
        this.addType(Float.class, this.floatType);
        this.addType(Float.TYPE, this.floatType);
        this.nativeMap.put(7, this.floatType);
        this.addType(BigDecimal.class, this.bigDecimalType);
        this.nativeMap.put(3, this.bigDecimalType);
        this.nativeMap.put(2, this.bigDecimalType);
        this.addType(Time.class, this.timeType);
        this.nativeMap.put(92, this.timeType);
        ScalarTypeDate dateType = new ScalarTypeDate(this.jsonDate);
        this.addType(java.sql.Date.class, dateType);
        this.nativeMap.put(91, dateType);
        ScalarTypeTimestamp timestampType = new ScalarTypeTimestamp(this.jsonDateTime);
        this.addType(Timestamp.class, timestampType);
        this.nativeMap.put(93, timestampType);
    }

    private void addInetAddressType(ScalarType scalarType) {
        this.addType(InetAddress.class, scalarType);
        this.addType(Inet4Address.class, scalarType);
        this.addType(Inet6Address.class, scalarType);
    }
}

